var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { getDashboardNameColumn, getDateColumn } from "../CustomDashboardListUtils/CustomDashboardListUtils";
import _ from "lodash";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
const CustomDashboardsTable = ({ driver, customDashboardData, setDashboardsData, isLoading, ouiaId, ouiaSafe, }) => {
    const [columns] = useState([
        getDashboardNameColumn((customDashboardInfo) => driver.openDashboard(customDashboardInfo)),
        getDateColumn("lastModified", "Last Modified"),
    ]);
    const [sortBy, setSortBy] = useState({
        property: "lastModified",
        direction: "desc",
    });
    useEffect(() => {
        if (!_.isEmpty(customDashboardData)) {
            onSort(2, "desc");
        }
    }, [isLoading]);
    const getSortBy = () => {
        return {
            index: columns.findIndex((column) => column.path === sortBy.property),
            direction: sortBy.direction,
        };
    };
    const onSort = (index, direction) => __awaiter(void 0, void 0, void 0, function* () {
        const sortObj = {
            property: columns[index - 1].path,
            direction: direction,
        };
        const sortedData = _.orderBy(customDashboardData, _.keys({
            [sortObj.property]: sortObj.direction,
        }), _.values({
            [sortObj.property]: sortObj.direction,
        }));
        setDashboardsData(sortedData);
        setSortBy(sortObj);
    });
    const customDashboardLoadingComponent = (React.createElement(Bullseye, null,
        React.createElement(KogitoSpinner, { spinnerText: "Loading Dashboard...", ouiaId: "custom-dashboard-list-custom-dashboard-list" })));
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "customDashboard-table", ouiaSafe)),
        React.createElement(DataTable, { data: customDashboardData, isLoading: isLoading, columns: columns, error: false, sortBy: getSortBy(), onSorting: onSort, LoadingComponent: customDashboardLoadingComponent })));
};
export default CustomDashboardsTable;
//# sourceMappingURL=CustomDashboardsTable.js.map