var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import isEmpty from "lodash/isEmpty";
export class FormDisplayerEnvelopeApiImpl {
    constructor(args) {
        this.args = args;
        this.capturedInitRequestYet = false;
        this.formDisplayer__notifyInit = (initArgs) => {
            this.view().initForm(initArgs);
        };
    }
    hasCapturedInitRequestYet() {
        return this.capturedInitRequestYet;
    }
    ackCapturedInitRequest() {
        this.capturedInitRequestYet = true;
    }
    formDisplayer__init(association, initArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            this.args.envelopeClient.associate(association.origin, association.envelopeServerId);
            if (this.hasCapturedInitRequestYet()) {
                return;
            }
            this.ackCapturedInitRequest();
            this.view = yield this.args.viewDelegate();
            if (!isEmpty(initArgs.form)) {
                this.view().initForm(initArgs);
            }
        });
    }
    formDisplayer__startSubmit(context) {
        return this.view().startSubmit(context);
    }
    formDisplayer__notifySubmitResponse(response) {
        this.view().notifySubmitResponse(response);
    }
}
//# sourceMappingURL=FormDisplayerEnvelopeApiImpl.js.map