import * as React from "react";
import { useImperativeHandle, useRef, useState } from "react";
import isEmpty from "lodash/isEmpty";
import FormDisplayer from "./components/FormDisplayer/FormDisplayer";
import ErrorBoundary from "./components/ErrorBoundary/ErrorBoundary";
export const FormDisplayerEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [content, setContent] = useState();
    const [data, setData] = useState();
    const [context, setContext] = useState();
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const formDisplayerApiRef = useRef({});
    useImperativeHandle(forwardedRef, () => {
        return {
            startSubmit: (context) => {
                return new Promise((resolve, reject) => {
                    var _a, _b, _c, _d;
                    try {
                        (_b = (_a = formDisplayerApiRef.current).beforeSubmit) === null || _b === void 0 ? void 0 : _b.call(_a, context);
                        resolve((_d = (_c = formDisplayerApiRef.current).getFormData) === null || _d === void 0 ? void 0 : _d.call(_c));
                    }
                    catch (err) {
                        reject(err.message);
                    }
                });
            },
            notifySubmitResponse: (response) => {
                var _a, _b;
                (_b = (_a = formDisplayerApiRef.current).afterSubmit) === null || _b === void 0 ? void 0 : _b.call(_a, response);
            },
            initForm: (args) => {
                var _a, _b;
                if (!isEmpty(args.form)) {
                    setEnvelopeConnectedToChannel(false);
                    setContent(args.form);
                    setData((_a = args.data) !== null && _a !== void 0 ? _a : {});
                    setContext((_b = args.context) !== null && _b !== void 0 ? _b : {});
                    setEnvelopeConnectedToChannel(true);
                }
            },
        };
    }, []);
    const onOpen = (opened) => {
        props.channelApi.notifications.notifyOnOpenForm.send(opened);
    };
    return (React.createElement(ErrorBoundary, { notifyOnError: onOpen },
        React.createElement(FormDisplayer, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, content: content, data: data, context: context, onOpenForm: onOpen, ref: formDisplayerApiRef })));
});
//# sourceMappingURL=FormDisplayerEnvelopeView.js.map