import React from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { FormGroup, Form } from "@patternfly/react-core/dist/js/components/Form";
import { Card, CardBody, CardHeaderMain, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { TextVariants, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import Moment from "react-moment";
const FormCard = ({ formData, driver, ouiaId, ouiaSafe }) => {
    const getLabel = () => {
        switch (formData.type) {
            case "HTML":
                return React.createElement(Label, { variant: "outline" }, "HTML");
            case "TSX":
                return React.createElement(Label, { variant: "outline" }, "REACT");
            default:
                return "";
        }
    };
    const handleCardClick = () => {
        driver.openForm(formData);
    };
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "forms-card", ouiaSafe), { isSelectable: true, onClick: handleCardClick }),
        React.createElement(CardHeader, null,
            React.createElement(CardHeaderMain, null, getLabel())),
        React.createElement(CardHeader, null,
            React.createElement(Text, { component: TextVariants.h1, className: "pf-u-font-weight-bold" }, formData.name)),
        React.createElement(CardBody, null,
            React.createElement("div", { className: "pf-u-mt-md" },
                React.createElement(Form, null,
                    React.createElement(FormGroup, { label: "Type", fieldId: "type" },
                        React.createElement(Text, { component: TextVariants.p }, formData.type)),
                    React.createElement(FormGroup, { label: "LastModified", fieldId: "lastModified" },
                        React.createElement(Text, { component: TextVariants.p },
                            React.createElement(Moment, { fromNow: true }, formData.lastModified))))))));
};
export default FormCard;
//# sourceMappingURL=FormCard.js.map