"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateDeployment = exports.GetDeployment = exports.DeleteDeployment = exports.ListDeployments = exports.CreateDeployment = exports.DEPLOYMENT_TEMPLATE = void 0;
var FetchConstants_1 = require("../../fetch/FetchConstants");
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var v1_1 = require("kubernetes-models/apps/v1");
var common_1 = require("../common");
var DEPLOYMENT_TEMPLATE = function (args) {
    var _a;
    var _b;
    var annotations = (_a = {},
        _a[common_1.ResourceLabelNames.URI] = args.uri,
        _a[common_1.ResourceLabelNames.WORKSPACE_NAME] = args.workspaceName,
        _a);
    return new v1_1.Deployment({
        metadata: {
            annotations: annotations,
            name: args.resourceName,
            namespace: args.namespace,
            labels: __assign(__assign({}, (0, common_1.commonLabels)(__assign({}, args))), (0, common_1.runtimeLabels)()),
        },
        spec: {
            replicas: 1,
            selector: {
                matchLabels: {
                    app: args.resourceName,
                },
            },
            template: {
                metadata: {
                    labels: {
                        app: args.resourceName,
                        deploymentconfig: args.resourceName,
                    },
                },
                spec: {
                    containers: [
                        {
                            name: args.resourceName,
                            image: args.containerImageUrl,
                            ports: [
                                {
                                    containerPort: 8080,
                                    protocol: "TCP",
                                },
                            ],
                            env: args.envVars,
                            imagePullPolicy: (_b = args.imagePullPolicy) !== null && _b !== void 0 ? _b : "Always",
                        },
                    ],
                },
            },
        },
    }).toJSON();
};
exports.DEPLOYMENT_TEMPLATE = DEPLOYMENT_TEMPLATE;
var CreateDeployment = (function (_super) {
    __extends(CreateDeployment, _super);
    function CreateDeployment(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateDeployment.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateDeployment.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.DEPLOYMENT_TEMPLATE)(__assign({}, this.args)));
    };
    CreateDeployment.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.Deployment.apiVersion, "/namespaces/").concat(this.args.namespace, "/deployments");
    };
    return CreateDeployment;
}(ResourceFetch_1.ResourceFetch));
exports.CreateDeployment = CreateDeployment;
var ListDeployments = (function (_super) {
    __extends(ListDeployments, _super);
    function ListDeployments(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    ListDeployments.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    ListDeployments.prototype.endpoint = function () {
        var selector = this.args.labelSelector ? "?labelSelector=".concat(this.args.labelSelector) : "";
        return "/apis/".concat(v1_1.Deployment.apiVersion, "/namespaces/").concat(this.args.namespace, "/deployments").concat(selector);
    };
    return ListDeployments;
}(ResourceFetch_1.ResourceFetch));
exports.ListDeployments = ListDeployments;
var DeleteDeployment = (function (_super) {
    __extends(DeleteDeployment, _super);
    function DeleteDeployment(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteDeployment.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteDeployment.prototype.body = function () {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    };
    DeleteDeployment.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.Deployment.apiVersion, "/namespaces/").concat(this.args.namespace, "/deployments/").concat(this.args.resourceName);
    };
    return DeleteDeployment;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteDeployment = DeleteDeployment;
var GetDeployment = (function (_super) {
    __extends(GetDeployment, _super);
    function GetDeployment(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    GetDeployment.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    GetDeployment.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.Deployment.apiVersion, "/namespaces/").concat(this.args.namespace, "/deployments/").concat(this.args.resourceName);
    };
    return GetDeployment;
}(ResourceFetch_1.ResourceFetch));
exports.GetDeployment = GetDeployment;
var UpdateDeployment = (function (_super) {
    __extends(UpdateDeployment, _super);
    function UpdateDeployment(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    UpdateDeployment.prototype.method = function () {
        return FetchConstants_1.HttpMethod.PUT;
    };
    UpdateDeployment.prototype.body = function () {
        return JSON.stringify(this.args.descriptor);
    };
    UpdateDeployment.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.Deployment.apiVersion, "/namespaces/").concat(this.args.namespace, "/deployments/").concat(this.args.resourceName);
    };
    return UpdateDeployment;
}(ResourceFetch_1.ResourceFetch));
exports.UpdateDeployment = UpdateDeployment;
//# sourceMappingURL=Deployment.js.map