"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteIngress = exports.ListIngresses = exports.CreateIngress = exports.INGRESS_TEMPLATE = void 0;
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var FetchConstants_1 = require("../../fetch/FetchConstants");
var v1_1 = require("kubernetes-models/networking.k8s.io/v1");
var common_1 = require("../common");
var INGRESS_TEMPLATE = function (args) {
    return new v1_1.Ingress({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: __assign(__assign({}, (0, common_1.commonLabels)(__assign({}, args))), (0, common_1.runtimeLabels)()),
            annotations: {
                "nginx.ingress.kubernetes.io/ssl-redirect": "false",
                "nginx.ingress.kubernetes.io/backend-protocol": "HTTP",
            },
        },
        spec: {
            rules: [
                {
                    http: {
                        paths: [
                            {
                                path: "/".concat(args.resourceName),
                                pathType: "Prefix",
                                backend: {
                                    service: {
                                        name: args.resourceName,
                                        port: {
                                            number: 8080,
                                        },
                                    },
                                },
                            },
                        ],
                    },
                },
            ],
        },
    }).toJSON();
};
exports.INGRESS_TEMPLATE = INGRESS_TEMPLATE;
var CreateIngress = (function (_super) {
    __extends(CreateIngress, _super);
    function CreateIngress(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateIngress.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateIngress.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.INGRESS_TEMPLATE)(__assign({}, this.args)));
    };
    CreateIngress.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.Ingress.apiVersion, "/namespaces/").concat(this.args.namespace, "/ingresses");
    };
    return CreateIngress;
}(ResourceFetch_1.ResourceFetch));
exports.CreateIngress = CreateIngress;
var ListIngresses = (function (_super) {
    __extends(ListIngresses, _super);
    function ListIngresses() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ListIngresses.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    ListIngresses.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.Ingress.apiVersion, "/namespaces/").concat(this.args.namespace, "/ingresses");
    };
    return ListIngresses;
}(ResourceFetch_1.ResourceFetch));
exports.ListIngresses = ListIngresses;
var DeleteIngress = (function (_super) {
    __extends(DeleteIngress, _super);
    function DeleteIngress(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteIngress.prototype.body = function () {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    };
    DeleteIngress.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteIngress.prototype.endpoint = function () {
        return "/apis/".concat(v1_1.Ingress.apiVersion, "/namespaces/").concat(this.args.namespace, "/ingresses/").concat(this.args.resourceName);
    };
    return DeleteIngress;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteIngress = DeleteIngress;
//# sourceMappingURL=Ingress.js.map