"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isHostValid = exports.isTokenValid = exports.isNamespaceValid = exports.isKubernetesConnectionValid = exports.KubernetesConnectionStatus = exports.EMPTY_KUBERNETES_CONNECTION = void 0;
exports.EMPTY_KUBERNETES_CONNECTION = {
    namespace: "",
    host: "",
    token: "",
    insecurelyDisableTlsCertificateValidation: false,
};
var KubernetesConnectionStatus;
(function (KubernetesConnectionStatus) {
    KubernetesConnectionStatus["CONNECTED"] = "CONNECTED";
    KubernetesConnectionStatus["ERROR"] = "ERROR";
    KubernetesConnectionStatus["MISSING_PERMISSIONS"] = "MISSING_PERMISSIONS";
    KubernetesConnectionStatus["NAMESPACE_NOT_FOUND"] = "NAMESPACE_NOT_FOUND";
})(KubernetesConnectionStatus = exports.KubernetesConnectionStatus || (exports.KubernetesConnectionStatus = {}));
var isKubernetesConnectionValid = function (connection) {
    return (0, exports.isNamespaceValid)(connection.namespace) && (0, exports.isHostValid)(connection.host) && (0, exports.isTokenValid)(connection.token);
};
exports.isKubernetesConnectionValid = isKubernetesConnectionValid;
var isNamespaceValid = function (namespace) { return namespace.trim().length > 0; };
exports.isNamespaceValid = isNamespaceValid;
var isTokenValid = function (token) { return token.trim().length > 0; };
exports.isTokenValid = isTokenValid;
var isHostValid = function (host) {
    if (host.trim().length === 0) {
        return false;
    }
    try {
        new URL(host);
        return true;
    }
    catch (_) {
        return false;
    }
};
exports.isHostValid = isHostValid;
//# sourceMappingURL=KubernetesConnection.js.map