"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Expression = void 0;
var Expression = (function () {
    function Expression(uuid, fullExpression) {
        this._uuid = uuid;
        this._variables = new Array();
        this._fullExpression = fullExpression !== null && fullExpression !== void 0 ? fullExpression : "";
    }
    Expression.prototype.renameVariable = function (renamedVariable, newName) {
        var e_1, _a;
        var offset = 0;
        try {
            for (var _b = __values(this._variables), _c = _b.next(); !_c.done; _c = _b.next()) {
                var variable = _c.value;
                variable.startIndex += offset;
                if (variable.source != undefined && variable.source === renamedVariable) {
                    this.replaceAt(variable.startIndex, renamedVariable.value.length, newName);
                    offset += renamedVariable.value.length - newName.length;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    Expression.prototype.replaceAt = function (position, oldLength, newVariable) {
        var part1 = this.fullExpression.substring(0, position);
        var newPart = newVariable;
        var part2 = this.fullExpression.substring(position + oldLength);
        this.fullExpression = part1 + newPart + part2;
    };
    Object.defineProperty(Expression.prototype, "variables", {
        get: function () {
            return this._variables;
        },
        set: function (value) {
            this._variables = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Expression.prototype, "fullExpression", {
        get: function () {
            return this._fullExpression;
        },
        set: function (value) {
            this._fullExpression = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Expression.prototype, "uuid", {
        get: function () {
            return this._uuid;
        },
        enumerable: false,
        configurable: true
    });
    return Expression;
}());
exports.Expression = Expression;
//# sourceMappingURL=VariableOccurrence.js.map