"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariablesRepository = void 0;
var FeelSyntacticSymbolNature_1 = require("./FeelSyntacticSymbolNature");
var VariableOccurrence_1 = require("./VariableOccurrence");
var VariablesRepository = (function () {
    function VariablesRepository(dmnDefinitions, externalDefinitions) {
        this.dataTypes = new Map();
        this.variablesIndexedByUuid = new Map();
        this.expressionsIndexedByUuid = new Map();
        this.loadImportedVariables(dmnDefinitions, externalDefinitions);
        this.currentVariablePrefix = "";
        this.currentUuidPrefix = "";
        this.loadVariables(dmnDefinitions);
    }
    Object.defineProperty(VariablesRepository.prototype, "variables", {
        get: function () {
            return this.variablesIndexedByUuid;
        },
        enumerable: false,
        configurable: true
    });
    VariablesRepository.prototype.updateVariableType = function (variableUuid, newType) {
        var variableContext = this.variablesIndexedByUuid.get(variableUuid);
        if (variableContext) {
            variableContext.variable.typeRef = this.getTypeRef(newType);
        }
    };
    Object.defineProperty(VariablesRepository.prototype, "expressions", {
        get: function () {
            return this.expressionsIndexedByUuid;
        },
        enumerable: false,
        configurable: true
    });
    VariablesRepository.prototype.renameVariable = function (variableUuid, newName) {
        var e_1, _a;
        var variableContext = this.variablesIndexedByUuid.get(variableUuid);
        if (variableContext) {
            try {
                for (var _b = __values(variableContext.variable.expressions.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var expression = _c.value;
                    expression.renameVariable(variableContext.variable, newName);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            variableContext.variable.value = newName;
        }
    };
    VariablesRepository.prototype.addVariableToContext = function (variableUuid, variableName, parentUuid, childUuid) {
        var parentContext = this.variablesIndexedByUuid.get(parentUuid);
        if (parentContext) {
            var newVariable = {
                value: variableName,
                feelSyntacticSymbolNature: FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.GlobalVariable,
                typeRef: undefined,
                expressions: new Map(),
            };
            var newContext = {
                uuid: variableUuid,
                parent: parentContext,
                variable: newVariable,
                children: new Map(),
                inputVariables: new Array(),
            };
            this.variablesIndexedByUuid.set(newContext.uuid, newContext);
            parentContext.children.set(variableUuid, newContext);
            if (childUuid) {
                var childContext = this.variablesIndexedByUuid.get(childUuid);
                if (childContext) {
                    parentContext.children.delete(childUuid);
                    childContext.parent = newContext;
                }
            }
        }
    };
    VariablesRepository.prototype.removeVariable = function (variableUuid, removeChildren) {
        var e_2, _a, e_3, _b;
        var _c;
        var variable = this.variablesIndexedByUuid.get(variableUuid);
        if (variable) {
            var newChildParent = variable.parent;
            if (!removeChildren) {
                if (newChildParent) {
                    newChildParent.children.delete(variableUuid);
                    try {
                        for (var _d = __values(variable.children.values()), _e = _d.next(); !_e.done; _e = _d.next()) {
                            var child = _e.value;
                            child.parent = newChildParent;
                            newChildParent.children.set(child.uuid, child);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                }
            }
            else {
                (_c = variable.parent) === null || _c === void 0 ? void 0 : _c.children.delete(variableUuid);
                try {
                    for (var _f = __values(variable.children.keys()), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var child = _g.value;
                        this.removeVariable(child, true);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
            }
            this.variablesIndexedByUuid.delete(variableUuid);
        }
    };
    VariablesRepository.prototype.createDataTypes = function (definitions) {
        var _this = this;
        var _a;
        (_a = definitions.itemDefinition) === null || _a === void 0 ? void 0 : _a.forEach(function (itemDefinition) {
            var _a;
            var dataType = _this.createDataType(itemDefinition);
            (_a = itemDefinition.itemComponent) === null || _a === void 0 ? void 0 : _a.forEach(function (itemComponent) {
                var innerType = _this.createInnerType(itemComponent);
                dataType.properties.set(innerType.name, innerType);
            });
            _this.dataTypes.set(dataType.name, dataType);
        });
    };
    VariablesRepository.prototype.createVariables = function (definitions) {
        var _this = this;
        var _a;
        (_a = definitions.drgElement) === null || _a === void 0 ? void 0 : _a.forEach(function (drg) {
            switch (drg.__$$element) {
                case "decision":
                    _this.createVariablesFromDecision(drg);
                    break;
                case "inputData":
                    _this.createVariablesFromInputData(drg);
                    break;
                case "businessKnowledgeModel":
                    _this.createVariablesFromBkm(drg);
                    break;
                case "decisionService":
                    _this.createVariablesFromDecisionService(drg);
                    break;
                default:
                    break;
            }
        });
    };
    VariablesRepository.prototype.createVariablesFromInputData = function (drg) {
        var _a, _b;
        this.addVariable((_a = drg["@_id"]) !== null && _a !== void 0 ? _a : "", drg["@_name"], FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.GlobalVariable, undefined, (_b = drg.variable) === null || _b === void 0 ? void 0 : _b["@_typeRef"]);
    };
    VariablesRepository.prototype.createVariablesFromDecisionService = function (drg) {
        var _a, _b;
        this.addVariable((_a = drg["@_id"]) !== null && _a !== void 0 ? _a : "", drg["@_name"], FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.Invocable, undefined, (_b = drg.variable) === null || _b === void 0 ? void 0 : _b["@_typeRef"]);
    };
    VariablesRepository.prototype.createVariablesFromBkm = function (drg) {
        var e_4, _a;
        var _b, _c, _d, _e;
        var parent = this.addVariable((_b = drg["@_id"]) !== null && _b !== void 0 ? _b : "", drg["@_name"], FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.Invocable, undefined, (_c = drg.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"]);
        if (drg.encapsulatedLogic) {
            var parentElement = parent;
            if (drg.encapsulatedLogic.formalParameter) {
                try {
                    for (var _f = __values(drg.encapsulatedLogic.formalParameter), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var parameter = _g.value;
                        parentElement = this.addVariable((_d = parameter["@_id"]) !== null && _d !== void 0 ? _d : "", (_e = parameter["@_name"]) !== null && _e !== void 0 ? _e : "<parameter>", FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.Parameter, parentElement);
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_a = _f.return)) _a.call(_f);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
            if (drg.encapsulatedLogic.expression) {
                this.addInnerExpression(parentElement, drg.encapsulatedLogic.expression);
            }
        }
    };
    VariablesRepository.prototype.createVariablesFromDecision = function (drg) {
        var e_5, _a, e_6, _b;
        var _c, _d;
        var parent = this.addVariable((_c = drg["@_id"]) !== null && _c !== void 0 ? _c : "", drg["@_name"], FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.InvisibleVariables, undefined, (_d = drg.variable) === null || _d === void 0 ? void 0 : _d["@_typeRef"]);
        if (drg.informationRequirement) {
            try {
                for (var _e = __values(drg.informationRequirement), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var requirement = _f.value;
                    this.addInputVariable(parent, requirement);
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
                }
                finally { if (e_5) throw e_5.error; }
            }
        }
        if (drg.knowledgeRequirement) {
            try {
                for (var _g = __values(drg.knowledgeRequirement), _h = _g.next(); !_h.done; _h = _g.next()) {
                    var knowledgeRequirement = _h.value;
                    this.addInputVariableFromKnowledge(parent, knowledgeRequirement);
                }
            }
            catch (e_6_1) { e_6 = { error: e_6_1 }; }
            finally {
                try {
                    if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
                }
                finally { if (e_6) throw e_6.error; }
            }
        }
        if (drg.expression) {
            this.addInnerExpression(parent, drg.expression);
        }
    };
    VariablesRepository.prototype.addVariable = function (uuid, name, variableType, parent, typeRef, allowDynamicVariables) {
        var node = this.createVariableNode(this.buildVariableUuid(uuid), this.buildName(name), variableType, parent, typeRef, allowDynamicVariables);
        this.variablesIndexedByUuid.set(this.buildVariableUuid(uuid), node);
        return node;
    };
    VariablesRepository.prototype.createVariableNode = function (uuid, name, variableType, parent, typeRef, allowDynamicVariables) {
        return {
            uuid: uuid,
            children: new Map(),
            parent: parent,
            inputVariables: new Array(),
            allowDynamicVariables: allowDynamicVariables,
            variable: {
                value: name,
                feelSyntacticSymbolNature: variableType,
                typeRef: this.getTypeRef(typeRef),
                expressions: new Map(),
            },
        };
    };
    VariablesRepository.prototype.getTypeRef = function (typeRef) {
        return this.dataTypes.has(typeRef !== null && typeRef !== void 0 ? typeRef : "") ? this.dataTypes.get(typeRef !== null && typeRef !== void 0 ? typeRef : "") : typeRef;
    };
    VariablesRepository.prototype.createDataType = function (itemDefinition) {
        var _a, _b;
        return {
            name: this.buildName(itemDefinition["@_name"]),
            properties: new Map(),
            typeRef: (_b = (_a = itemDefinition["typeRef"]) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : itemDefinition["@_name"],
        };
    };
    VariablesRepository.prototype.createInnerType = function (itemComponent) {
        var _a, _b;
        return {
            name: itemComponent["@_name"],
            properties: this.buildProperties(itemComponent),
            typeRef: (_b = (_a = itemComponent["typeRef"]) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : itemComponent["@_name"],
        };
    };
    VariablesRepository.prototype.buildProperties = function (itemComponent) {
        var _this = this;
        var _a;
        var properties = new Map();
        (_a = itemComponent.itemComponent) === null || _a === void 0 ? void 0 : _a.forEach(function (def) {
            var _a, _b;
            var rootProperty = {
                name: def["@_name"],
                properties: _this.buildProperties(def),
                typeRef: (_b = (_a = def["typeRef"]) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : def["@_name"],
            };
            properties.set(rootProperty.name, rootProperty);
        });
        return properties;
    };
    VariablesRepository.prototype.addLiteralExpression = function (parent, element) {
        var _a, _b;
        var id = (_a = element["@_id"]) !== null && _a !== void 0 ? _a : "";
        var expression = new VariableOccurrence_1.Expression(id, (_b = element.text) === null || _b === void 0 ? void 0 : _b.__$$text);
        this.expressionsIndexedByUuid.set(id, expression);
        this.addVariable(id, "", FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.LocalVariable, parent);
    };
    VariablesRepository.prototype.addInvocation = function (parent, element) {
        var e_7, _a;
        if (element.binding) {
            try {
                for (var _b = __values(element.binding), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var bindingElement = _c.value;
                    if (bindingElement.expression) {
                        this.addInnerExpression(parent, bindingElement.expression);
                    }
                }
            }
            catch (e_7_1) { e_7 = { error: e_7_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_7) throw e_7.error; }
            }
        }
    };
    VariablesRepository.prototype.addContext = function (parent, element) {
        var e_8, _a;
        var parentNode = parent;
        if (element.contextEntry) {
            try {
                for (var _b = __values(element.contextEntry), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var innerEntry = _c.value;
                    parentNode = this.addContextEntry(parentNode, innerEntry);
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_8) throw e_8.error; }
            }
        }
    };
    VariablesRepository.prototype.addContextEntry = function (parentNode, contextEntry) {
        var _a, _b, _c, _d, _e;
        var variableNode = this.addVariable((_b = (_a = contextEntry.variable) === null || _a === void 0 ? void 0 : _a["@_id"]) !== null && _b !== void 0 ? _b : "", (_d = (_c = contextEntry.variable) === null || _c === void 0 ? void 0 : _c["@_name"]) !== null && _d !== void 0 ? _d : "", FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.LocalVariable, parentNode, (_e = contextEntry.variable) === null || _e === void 0 ? void 0 : _e["@_typeRef"]);
        parentNode.children.set(variableNode.uuid, variableNode);
        if (contextEntry.expression) {
            if (contextEntry.expression.__$$element) {
                this.addInnerExpression(parentNode, contextEntry.expression);
            }
        }
        return variableNode;
    };
    VariablesRepository.prototype.addFunctionDefinition = function (parent, element) {
        var e_9, _a;
        var _b, _c;
        var parentElement = parent;
        if (element.formalParameter) {
            try {
                for (var _d = __values(element.formalParameter), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var parameter = _e.value;
                    parentElement = this.addVariable((_b = parameter["@_id"]) !== null && _b !== void 0 ? _b : "", (_c = parameter["@_name"]) !== null && _c !== void 0 ? _c : "<parameter>", FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.Parameter, parentElement);
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                }
                finally { if (e_9) throw e_9.error; }
            }
        }
        if (element.expression) {
            this.addInnerExpression(parentElement, element.expression);
        }
    };
    VariablesRepository.prototype.addRelation = function (parent, element) {
        var e_10, _a, e_11, _b;
        if (element.row) {
            try {
                for (var _c = __values(element.row), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var rowElement = _d.value;
                    if (rowElement.expression) {
                        try {
                            for (var _e = (e_11 = void 0, __values(rowElement.expression)), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var expression = _f.value;
                                this.addInnerExpression(parent, expression);
                            }
                        }
                        catch (e_11_1) { e_11 = { error: e_11_1 }; }
                        finally {
                            try {
                                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                            }
                            finally { if (e_11) throw e_11.error; }
                        }
                    }
                }
            }
            catch (e_10_1) { e_10 = { error: e_10_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_10) throw e_10.error; }
            }
        }
    };
    VariablesRepository.prototype.addList = function (parent, element) {
        var e_12, _a;
        if (element.expression) {
            try {
                for (var _b = __values(element.expression), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var expression = _c.value;
                    if (expression) {
                        this.addInnerExpression(parent, expression);
                    }
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_12) throw e_12.error; }
            }
        }
    };
    VariablesRepository.prototype.addConditional = function (parent, element) {
        var _a, _b, _c;
        if ((_a = element.if) === null || _a === void 0 ? void 0 : _a.expression) {
            this.addInnerExpression(parent, element.if.expression);
        }
        if ((_b = element.then) === null || _b === void 0 ? void 0 : _b.expression) {
            this.addInnerExpression(parent, element.then.expression);
        }
        if ((_c = element.else) === null || _c === void 0 ? void 0 : _c.expression) {
            this.addInnerExpression(parent, element.else.expression);
        }
    };
    VariablesRepository.prototype.addIterable = function (parent, expression) {
        var localParent = this.addIteratorVariable(parent, expression);
        if (expression.in.expression) {
            this.addInnerExpression(localParent, expression.in.expression);
        }
        if (expression.satisfies.expression) {
            this.addInnerExpression(localParent, expression.satisfies.expression);
        }
    };
    VariablesRepository.prototype.addFor = function (parent, expression) {
        var localParent = this.addIteratorVariable(parent, expression);
        if (expression.return.expression) {
            this.addInnerExpression(localParent, expression.return.expression);
        }
        if (expression.in.expression) {
            this.addInnerExpression(localParent, expression.in.expression);
        }
    };
    VariablesRepository.prototype.addFilterVariable = function (parent, expression) {
        var _a;
        var type = undefined;
        if (expression.in.expression) {
            type = expression.in.expression["@_typeRef"];
        }
        return this.addVariable((_a = expression["@_id"]) !== null && _a !== void 0 ? _a : "", "item", FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.LocalVariable, parent, type, true);
    };
    VariablesRepository.prototype.addIteratorVariable = function (parent, expression) {
        var _a;
        var localParent = parent;
        if (expression["@_iteratorVariable"]) {
            var type = undefined;
            if (expression.in.expression) {
                type = expression.in.expression["@_typeRef"];
            }
            localParent = this.addVariable((_a = expression["@_id"]) !== null && _a !== void 0 ? _a : "", expression["@_iteratorVariable"], FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.LocalVariable, parent, type, true);
        }
        return localParent;
    };
    VariablesRepository.prototype.addFilter = function (parent, expression) {
        if (expression.in.expression) {
            this.addInnerExpression(parent, expression.in.expression);
        }
        var localParent = this.addFilterVariable(parent, expression);
        if (expression.match.expression) {
            this.addInnerExpression(localParent, expression.match.expression);
        }
    };
    VariablesRepository.prototype.addInnerExpression = function (parent, expression) {
        switch (expression.__$$element) {
            case "literalExpression":
                this.addLiteralExpression(parent, expression);
                break;
            case "invocation":
                this.addInvocation(parent, expression);
                break;
            case "decisionTable":
                break;
            case "context":
                this.addContext(parent, expression);
                break;
            case "functionDefinition":
                this.addFunctionDefinition(parent, expression);
                break;
            case "relation":
                this.addRelation(parent, expression);
                break;
            case "list":
                this.addList(parent, expression);
                break;
            case "conditional":
                this.addConditional(parent, expression);
                break;
            case "every":
            case "some":
                this.addIterable(parent, expression);
                break;
            case "for":
                this.addFor(parent, expression);
                break;
            case "filter":
                this.addFilter(parent, expression);
                break;
            default:
        }
    };
    VariablesRepository.prototype.addInputVariable = function (parent, requirement) {
        var _a, _b;
        if (requirement.requiredDecision) {
            parent.inputVariables.push((_a = requirement.requiredDecision["@_href"]) === null || _a === void 0 ? void 0 : _a.replace("#", ""));
        }
        else if (requirement.requiredInput) {
            parent.inputVariables.push((_b = requirement.requiredInput["@_href"]) === null || _b === void 0 ? void 0 : _b.replace("#", ""));
        }
    };
    VariablesRepository.prototype.addInputVariableFromKnowledge = function (parent, knowledgeRequirement) {
        var _a;
        if (knowledgeRequirement.requiredKnowledge) {
            parent.inputVariables.push((_a = knowledgeRequirement.requiredKnowledge["@_href"]) === null || _a === void 0 ? void 0 : _a.replace("#", ""));
        }
    };
    VariablesRepository.prototype.buildVariableUuid = function (uuid) {
        if (this.currentUuidPrefix.length != 0) {
            return this.currentUuidPrefix + uuid;
        }
        return uuid;
    };
    VariablesRepository.prototype.buildName = function (name) {
        if (this.currentVariablePrefix.length != 0) {
            return this.currentVariablePrefix + "." + name;
        }
        return name;
    };
    VariablesRepository.prototype.loadVariables = function (dmnDefinitions) {
        this.createDataTypes(dmnDefinitions);
        this.createVariables(dmnDefinitions);
    };
    VariablesRepository.prototype.loadImportedVariables = function (dmnDefinitions, externalDefinitions) {
        var e_13, _a;
        if (dmnDefinitions.import) {
            try {
                for (var _b = __values(dmnDefinitions.import), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var dmnImport = _c.value;
                    if (externalDefinitions.has(dmnImport["@_namespace"])) {
                        this.currentVariablePrefix = dmnImport["@_name"];
                        this.currentUuidPrefix = dmnImport["@_namespace"];
                        var externalDef = externalDefinitions.get(dmnImport["@_namespace"]);
                        if (externalDef) {
                            this.loadVariables(externalDef.definitions);
                        }
                    }
                }
            }
            catch (e_13_1) { e_13 = { error: e_13_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_13) throw e_13.error; }
            }
        }
    };
    return VariablesRepository;
}());
exports.VariablesRepository = VariablesRepository;
//# sourceMappingURL=VariablesRepository.js.map