import { Symbol } from "./Symbol";
import { Type } from "./Type";
export interface Scope {
    getName(): string;
    getParentScope(): Scope | undefined;
    addChildScope: (scope: Scope) => void;
    getChildScopes(): Map<string, Scope>;
    define(symbol: Symbol): boolean;
    resolve(id: string): Symbol | undefined;
    resolve(qualifiedName: string[]): Symbol | undefined;
    start: (token: string) => void;
    followUp(token: string, isPredict: boolean): boolean;
    getSymbols(): Map<string, Symbol>;
    getType(): Type | undefined;
    allowDynamicVariables: boolean | undefined;
}
//# sourceMappingURL=Scope.d.ts.map