import { ATN, DFA, FailedPredicateException, Parser, RuleContext, ParserRuleContext, TerminalNode, Token, TokenStream } from "antlr4";
import FEEL_1_1Listener from "./FEEL_1_1Listener";
import { ParserHelper } from "../ParserHelper";
export default class FEEL_1_1Parser extends Parser {
    static readonly BooleanLiteral = 1;
    static readonly FOR = 2;
    static readonly RETURN = 3;
    static readonly IN = 4;
    static readonly IF = 5;
    static readonly THEN = 6;
    static readonly ELSE = 7;
    static readonly SOME = 8;
    static readonly EVERY = 9;
    static readonly SATISFIES = 10;
    static readonly INSTANCE = 11;
    static readonly OF = 12;
    static readonly FUNCTION = 13;
    static readonly EXTERNAL = 14;
    static readonly OR = 15;
    static readonly AND = 16;
    static readonly BETWEEN = 17;
    static readonly NULL = 18;
    static readonly TRUE = 19;
    static readonly FALSE = 20;
    static readonly QUOTE = 21;
    static readonly IntegerLiteral = 22;
    static readonly FloatingPointLiteral = 23;
    static readonly StringLiteral = 24;
    static readonly LPAREN = 25;
    static readonly RPAREN = 26;
    static readonly LBRACE = 27;
    static readonly RBRACE = 28;
    static readonly LBRACK = 29;
    static readonly RBRACK = 30;
    static readonly COMMA = 31;
    static readonly ELIPSIS = 32;
    static readonly DOT = 33;
    static readonly EQUAL = 34;
    static readonly GT = 35;
    static readonly LT = 36;
    static readonly LE = 37;
    static readonly GE = 38;
    static readonly NOTEQUAL = 39;
    static readonly COLON = 40;
    static readonly RARROW = 41;
    static readonly POW = 42;
    static readonly ADD = 43;
    static readonly SUB = 44;
    static readonly MUL = 45;
    static readonly DIV = 46;
    static readonly BANG = 47;
    static readonly NOT = 48;
    static readonly AT = 49;
    static readonly Identifier = 50;
    static readonly WS = 51;
    static readonly COMMENT = 52;
    static readonly LINE_COMMENT = 53;
    static readonly ANY_OTHER_CHAR = 54;
    static readonly EOF: number;
    static readonly RULE_compilation_unit = 0;
    static readonly RULE_expression = 1;
    static readonly RULE_textualExpression = 2;
    static readonly RULE_parameters = 3;
    static readonly RULE_namedParameters = 4;
    static readonly RULE_namedParameter = 5;
    static readonly RULE_positionalParameters = 6;
    static readonly RULE_forExpression = 7;
    static readonly RULE_iterationContexts = 8;
    static readonly RULE_iterationContext = 9;
    static readonly RULE_ifExpression = 10;
    static readonly RULE_quantifiedExpression = 11;
    static readonly RULE_type = 12;
    static readonly RULE_list = 13;
    static readonly RULE_functionDefinition = 14;
    static readonly RULE_formalParameters = 15;
    static readonly RULE_formalParameter = 16;
    static readonly RULE_context = 17;
    static readonly RULE_contextEntries = 18;
    static readonly RULE_contextEntry = 19;
    static readonly RULE_key = 20;
    static readonly RULE_nameDefinition = 21;
    static readonly RULE_nameDefinitionWithEOF = 22;
    static readonly RULE_nameDefinitionTokens = 23;
    static readonly RULE_iterationNameDefinition = 24;
    static readonly RULE_iterationNameDefinitionTokens = 25;
    static readonly RULE_additionalNameSymbol = 26;
    static readonly RULE_conditionalOrExpression = 27;
    static readonly RULE_conditionalAndExpression = 28;
    static readonly RULE_comparisonExpression = 29;
    static readonly RULE_relationalExpression = 30;
    static readonly RULE_expressionList = 31;
    static readonly RULE_additiveExpression = 32;
    static readonly RULE_multiplicativeExpression = 33;
    static readonly RULE_powerExpression = 34;
    static readonly RULE_filterPathExpression = 35;
    static readonly RULE_unaryExpression = 36;
    static readonly RULE_unaryExpressionNotPlusMinus = 37;
    static readonly RULE_primary = 38;
    static readonly RULE_literal = 39;
    static readonly RULE_atLiteral = 40;
    static readonly RULE_atLiteralValue = 41;
    static readonly RULE_simplePositiveUnaryTest = 42;
    static readonly RULE_simplePositiveUnaryTests = 43;
    static readonly RULE_simpleUnaryTests = 44;
    static readonly RULE_positiveUnaryTest = 45;
    static readonly RULE_positiveUnaryTests = 46;
    static readonly RULE_unaryTestsRoot = 47;
    static readonly RULE_unaryTests = 48;
    static readonly RULE_endpoint = 49;
    static readonly RULE_interval = 50;
    static readonly RULE_qualifiedName = 51;
    static readonly RULE_nameRef = 52;
    static readonly RULE_nameRefOtherToken = 53;
    static readonly RULE_reusableKeywords = 54;
    static readonly literalNames: (string | null)[];
    static readonly symbolicNames: (string | null)[];
    static readonly ruleNames: string[];
    get grammarFileName(): string;
    get literalNames(): (string | null)[];
    get symbolicNames(): (string | null)[];
    get ruleNames(): string[];
    get serializedATN(): number[];
    protected createFailedPredicateException(predicate?: string, message?: string): FailedPredicateException;
    readonly helper: ParserHelper;
    constructor(input: TokenStream);
    compilation_unit(): Compilation_unitContext;
    expression(): ExpressionContext;
    textualExpression(): TextualExpressionContext;
    parameters(): ParametersContext;
    namedParameters(): NamedParametersContext;
    namedParameter(): NamedParameterContext;
    positionalParameters(): PositionalParametersContext;
    forExpression(): ForExpressionContext;
    iterationContexts(): IterationContextsContext;
    iterationContext(): IterationContextContext;
    ifExpression(): IfExpressionContext;
    quantifiedExpression(): QuantifiedExpressionContext;
    type_(): TypeContext;
    list(): ListContext;
    functionDefinition(): FunctionDefinitionContext;
    formalParameters(): FormalParametersContext;
    formalParameter(): FormalParameterContext;
    context(): ContextContext;
    contextEntries(): ContextEntriesContext;
    contextEntry(): ContextEntryContext;
    key(): KeyContext;
    nameDefinition(): NameDefinitionContext;
    nameDefinitionWithEOF(): NameDefinitionWithEOFContext;
    nameDefinitionTokens(): NameDefinitionTokensContext;
    iterationNameDefinition(): IterationNameDefinitionContext;
    iterationNameDefinitionTokens(): IterationNameDefinitionTokensContext;
    additionalNameSymbol(): AdditionalNameSymbolContext;
    conditionalOrExpression(): ConditionalOrExpressionContext;
    conditionalOrExpression(_p: number): ConditionalOrExpressionContext;
    conditionalAndExpression(): ConditionalAndExpressionContext;
    conditionalAndExpression(_p: number): ConditionalAndExpressionContext;
    comparisonExpression(): ComparisonExpressionContext;
    comparisonExpression(_p: number): ComparisonExpressionContext;
    relationalExpression(): RelationalExpressionContext;
    relationalExpression(_p: number): RelationalExpressionContext;
    expressionList(): ExpressionListContext;
    additiveExpression(): AdditiveExpressionContext;
    additiveExpression(_p: number): AdditiveExpressionContext;
    multiplicativeExpression(): MultiplicativeExpressionContext;
    multiplicativeExpression(_p: number): MultiplicativeExpressionContext;
    powerExpression(): PowerExpressionContext;
    powerExpression(_p: number): PowerExpressionContext;
    filterPathExpression(): FilterPathExpressionContext;
    filterPathExpression(_p: number): FilterPathExpressionContext;
    unaryExpression(): UnaryExpressionContext;
    unaryExpression(_p: number): UnaryExpressionContext;
    unaryExpressionNotPlusMinus(): UnaryExpressionNotPlusMinusContext;
    primary(): PrimaryContext;
    literal(): LiteralContext;
    atLiteral(): AtLiteralContext;
    atLiteralValue(): AtLiteralValueContext;
    simplePositiveUnaryTest(): SimplePositiveUnaryTestContext;
    simplePositiveUnaryTests(): SimplePositiveUnaryTestsContext;
    simpleUnaryTests(): SimpleUnaryTestsContext;
    positiveUnaryTest(): PositiveUnaryTestContext;
    positiveUnaryTests(): PositiveUnaryTestsContext;
    unaryTestsRoot(): UnaryTestsRootContext;
    unaryTests(): UnaryTestsContext;
    endpoint(): EndpointContext;
    interval(): IntervalContext;
    qualifiedName(): QualifiedNameContext;
    nameRef(): NameRefContext;
    nameRefOtherToken(): NameRefOtherTokenContext;
    reusableKeywords(): ReusableKeywordsContext;
    sempred(localctx: RuleContext, ruleIndex: number, predIndex: number): boolean;
    private iterationContext_sempred;
    private type_sempred;
    private conditionalOrExpression_sempred;
    private conditionalAndExpression_sempred;
    private comparisonExpression_sempred;
    private relationalExpression_sempred;
    private additiveExpression_sempred;
    private multiplicativeExpression_sempred;
    private powerExpression_sempred;
    private filterPathExpression_sempred;
    private unaryExpression_sempred;
    private nameRefOtherToken_sempred;
    static readonly _serializedATN: number[];
    private static __ATN;
    static get _ATN(): ATN;
    static DecisionsToDFA: DFA[];
}
export declare class Compilation_unitContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    expression(): ExpressionContext;
    EOF(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: ExpressionContext): void;
}
export declare class ExpressionTextualContext extends ExpressionContext {
    _expr: TextualExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: ExpressionContext);
    textualExpression(): TextualExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class TextualExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    functionDefinition(): FunctionDefinitionContext;
    conditionalOrExpression(): ConditionalOrExpressionContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ParametersContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: ParametersContext): void;
}
export declare class ParametersNamedContext extends ParametersContext {
    constructor(parser: FEEL_1_1Parser, ctx: ParametersContext);
    LPAREN(): TerminalNode;
    namedParameters(): NamedParametersContext;
    RPAREN(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ParametersEmptyContext extends ParametersContext {
    constructor(parser: FEEL_1_1Parser, ctx: ParametersContext);
    LPAREN(): TerminalNode;
    RPAREN(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ParametersPositionalContext extends ParametersContext {
    constructor(parser: FEEL_1_1Parser, ctx: ParametersContext);
    LPAREN(): TerminalNode;
    positionalParameters(): PositionalParametersContext;
    RPAREN(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NamedParametersContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    namedParameter_list(): NamedParameterContext[];
    namedParameter(i: number): NamedParameterContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NamedParameterContext extends ParserRuleContext {
    _name: NameDefinitionContext;
    _value: ExpressionContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    COLON(): TerminalNode;
    nameDefinition(): NameDefinitionContext;
    expression(): ExpressionContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PositionalParametersContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    expression_list(): ExpressionContext[];
    expression(i: number): ExpressionContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ForExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    FOR(): TerminalNode;
    iterationContexts(): IterationContextsContext;
    RETURN(): TerminalNode;
    expression(): ExpressionContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class IterationContextsContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    iterationContext_list(): IterationContextContext[];
    iterationContext(i: number): IterationContextContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class IterationContextContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    iterationNameDefinition(): IterationNameDefinitionContext;
    IN(): TerminalNode;
    expression_list(): ExpressionContext[];
    expression(i: number): ExpressionContext;
    ELIPSIS(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class IfExpressionContext extends ParserRuleContext {
    _c: ExpressionContext;
    _t: ExpressionContext;
    _e: ExpressionContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    IF(): TerminalNode;
    THEN(): TerminalNode;
    ELSE(): TerminalNode;
    expression_list(): ExpressionContext[];
    expression(i: number): ExpressionContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class QuantifiedExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: QuantifiedExpressionContext): void;
}
export declare class QuantExprSomeContext extends QuantifiedExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: QuantifiedExpressionContext);
    SOME(): TerminalNode;
    iterationContexts(): IterationContextsContext;
    SATISFIES(): TerminalNode;
    expression(): ExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class QuantExprEveryContext extends QuantifiedExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: QuantifiedExpressionContext);
    EVERY(): TerminalNode;
    iterationContexts(): IterationContextsContext;
    SATISFIES(): TerminalNode;
    expression(): ExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class TypeContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: TypeContext): void;
}
export declare class ContextTypeContext extends TypeContext {
    _sk: Token;
    constructor(parser: FEEL_1_1Parser, ctx: TypeContext);
    LT(): TerminalNode;
    Identifier_list(): TerminalNode[];
    Identifier(i: number): TerminalNode;
    COLON_list(): TerminalNode[];
    COLON(i: number): TerminalNode;
    type__list(): TypeContext[];
    type_(i: number): TypeContext;
    GT(): TerminalNode;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class FunctionTypeContext extends TypeContext {
    constructor(parser: FEEL_1_1Parser, ctx: TypeContext);
    FUNCTION(): TerminalNode;
    LT(): TerminalNode;
    GT(): TerminalNode;
    RARROW(): TerminalNode;
    type__list(): TypeContext[];
    type_(i: number): TypeContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ListTypeContext extends TypeContext {
    _sk: Token;
    constructor(parser: FEEL_1_1Parser, ctx: TypeContext);
    LT(): TerminalNode;
    type_(): TypeContext;
    GT(): TerminalNode;
    Identifier(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class QnTypeContext extends TypeContext {
    constructor(parser: FEEL_1_1Parser, ctx: TypeContext);
    FUNCTION(): TerminalNode;
    qualifiedName(): QualifiedNameContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ListContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    LBRACK(): TerminalNode;
    RBRACK(): TerminalNode;
    expressionList(): ExpressionListContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class FunctionDefinitionContext extends ParserRuleContext {
    _external: Token;
    _body: ExpressionContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    FUNCTION(): TerminalNode;
    LPAREN(): TerminalNode;
    RPAREN(): TerminalNode;
    expression(): ExpressionContext;
    formalParameters(): FormalParametersContext;
    EXTERNAL(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class FormalParametersContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    formalParameter_list(): FormalParameterContext[];
    formalParameter(i: number): FormalParameterContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class FormalParameterContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    nameDefinition(): NameDefinitionContext;
    COLON(): TerminalNode;
    type_(): TypeContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ContextContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    LBRACE(): TerminalNode;
    RBRACE(): TerminalNode;
    contextEntries(): ContextEntriesContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ContextEntriesContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    contextEntry_list(): ContextEntryContext[];
    contextEntry(i: number): ContextEntryContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ContextEntryContext extends ParserRuleContext {
    _key: KeyContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    key(): KeyContext;
    COLON(): TerminalNode;
    expression(): ExpressionContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class KeyContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: KeyContext): void;
}
export declare class KeyNameContext extends KeyContext {
    constructor(parser: FEEL_1_1Parser, ctx: KeyContext);
    nameDefinition(): NameDefinitionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class KeyStringContext extends KeyContext {
    constructor(parser: FEEL_1_1Parser, ctx: KeyContext);
    StringLiteral(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NameDefinitionContext extends ParserRuleContext {
    _nameDefinitionTokens: NameDefinitionTokensContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    nameDefinitionTokens(): NameDefinitionTokensContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NameDefinitionWithEOFContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    nameDefinition(): NameDefinitionContext;
    EOF(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NameDefinitionTokensContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    Identifier_list(): TerminalNode[];
    Identifier(i: number): TerminalNode;
    additionalNameSymbol_list(): AdditionalNameSymbolContext[];
    additionalNameSymbol(i: number): AdditionalNameSymbolContext;
    IntegerLiteral_list(): TerminalNode[];
    IntegerLiteral(i: number): TerminalNode;
    FloatingPointLiteral_list(): TerminalNode[];
    FloatingPointLiteral(i: number): TerminalNode;
    reusableKeywords_list(): ReusableKeywordsContext[];
    reusableKeywords(i: number): ReusableKeywordsContext;
    IN_list(): TerminalNode[];
    IN(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class IterationNameDefinitionContext extends ParserRuleContext {
    _iterationNameDefinitionTokens: IterationNameDefinitionTokensContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    iterationNameDefinitionTokens(): IterationNameDefinitionTokensContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class IterationNameDefinitionTokensContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    Identifier_list(): TerminalNode[];
    Identifier(i: number): TerminalNode;
    additionalNameSymbol_list(): AdditionalNameSymbolContext[];
    additionalNameSymbol(i: number): AdditionalNameSymbolContext;
    IntegerLiteral_list(): TerminalNode[];
    IntegerLiteral(i: number): TerminalNode;
    FloatingPointLiteral_list(): TerminalNode[];
    FloatingPointLiteral(i: number): TerminalNode;
    reusableKeywords_list(): ReusableKeywordsContext[];
    reusableKeywords(i: number): ReusableKeywordsContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class AdditionalNameSymbolContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    DOT(): TerminalNode;
    DIV(): TerminalNode;
    SUB(): TerminalNode;
    ADD(): TerminalNode;
    MUL(): TerminalNode;
    QUOTE(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ConditionalOrExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: ConditionalOrExpressionContext): void;
}
export declare class CondOrContext extends ConditionalOrExpressionContext {
    _left: ConditionalOrExpressionContext;
    _op: Token;
    _right: ConditionalAndExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: ConditionalOrExpressionContext);
    conditionalOrExpression(): ConditionalOrExpressionContext;
    OR(): TerminalNode;
    conditionalAndExpression(): ConditionalAndExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class CondOrAndContext extends ConditionalOrExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: ConditionalOrExpressionContext);
    conditionalAndExpression(): ConditionalAndExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ConditionalAndExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: ConditionalAndExpressionContext): void;
}
export declare class CondAndCompContext extends ConditionalAndExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: ConditionalAndExpressionContext);
    comparisonExpression(): ComparisonExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class CondAndContext extends ConditionalAndExpressionContext {
    _left: ConditionalAndExpressionContext;
    _op: Token;
    _right: ComparisonExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: ConditionalAndExpressionContext);
    conditionalAndExpression(): ConditionalAndExpressionContext;
    AND(): TerminalNode;
    comparisonExpression(): ComparisonExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ComparisonExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: ComparisonExpressionContext): void;
}
export declare class CompExpressionContext extends ComparisonExpressionContext {
    _left: ComparisonExpressionContext;
    _op: Token;
    _right: RelationalExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: ComparisonExpressionContext);
    comparisonExpression(): ComparisonExpressionContext;
    relationalExpression(): RelationalExpressionContext;
    LT(): TerminalNode;
    GT(): TerminalNode;
    LE(): TerminalNode;
    GE(): TerminalNode;
    EQUAL(): TerminalNode;
    NOTEQUAL(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class CompExpressionRelContext extends ComparisonExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: ComparisonExpressionContext);
    relationalExpression(): RelationalExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class RelationalExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: RelationalExpressionContext): void;
}
export declare class RelExpressionBetweenContext extends RelationalExpressionContext {
    _val: RelationalExpressionContext;
    _start: AdditiveExpressionContext;
    _end: AdditiveExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: RelationalExpressionContext);
    BETWEEN(): TerminalNode;
    AND(): TerminalNode;
    relationalExpression(): RelationalExpressionContext;
    additiveExpression_list(): AdditiveExpressionContext[];
    additiveExpression(i: number): AdditiveExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class RelExpressionValueContext extends RelationalExpressionContext {
    _val: RelationalExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: RelationalExpressionContext);
    IN(): TerminalNode;
    expression(): ExpressionContext;
    relationalExpression(): RelationalExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class RelExpressionTestListContext extends RelationalExpressionContext {
    _val: RelationalExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: RelationalExpressionContext);
    IN(): TerminalNode;
    LPAREN(): TerminalNode;
    positiveUnaryTests(): PositiveUnaryTestsContext;
    RPAREN(): TerminalNode;
    relationalExpression(): RelationalExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class RelExpressionAddContext extends RelationalExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: RelationalExpressionContext);
    additiveExpression(): AdditiveExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class RelExpressionInstanceOfContext extends RelationalExpressionContext {
    _val: RelationalExpressionContext;
    constructor(parser: FEEL_1_1Parser, ctx: RelationalExpressionContext);
    INSTANCE(): TerminalNode;
    OF(): TerminalNode;
    type_(): TypeContext;
    relationalExpression(): RelationalExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ExpressionListContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    expression_list(): ExpressionContext[];
    expression(i: number): ExpressionContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class AdditiveExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: AdditiveExpressionContext): void;
}
export declare class AddExpressionMultContext extends AdditiveExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: AdditiveExpressionContext);
    multiplicativeExpression(): MultiplicativeExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class AddExpressionContext extends AdditiveExpressionContext {
    _op: Token;
    constructor(parser: FEEL_1_1Parser, ctx: AdditiveExpressionContext);
    additiveExpression(): AdditiveExpressionContext;
    multiplicativeExpression(): MultiplicativeExpressionContext;
    ADD(): TerminalNode;
    SUB(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class MultiplicativeExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: MultiplicativeExpressionContext): void;
}
export declare class MultExpressionPowContext extends MultiplicativeExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: MultiplicativeExpressionContext);
    powerExpression(): PowerExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class MultExpressionContext extends MultiplicativeExpressionContext {
    _op: Token;
    constructor(parser: FEEL_1_1Parser, ctx: MultiplicativeExpressionContext);
    multiplicativeExpression(): MultiplicativeExpressionContext;
    powerExpression(): PowerExpressionContext;
    MUL(): TerminalNode;
    DIV(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PowerExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: PowerExpressionContext): void;
}
export declare class PowExpressionUnaryContext extends PowerExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: PowerExpressionContext);
    filterPathExpression(): FilterPathExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PowExpressionContext extends PowerExpressionContext {
    _op: Token;
    constructor(parser: FEEL_1_1Parser, ctx: PowerExpressionContext);
    powerExpression(): PowerExpressionContext;
    filterPathExpression(): FilterPathExpressionContext;
    POW(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class FilterPathExpressionContext extends ParserRuleContext {
    _n0: FilterPathExpressionContext;
    _n1: FilterPathExpressionContext;
    _filter: ExpressionContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    unaryExpression(): UnaryExpressionContext;
    LBRACK(): TerminalNode;
    RBRACK(): TerminalNode;
    filterPathExpression(): FilterPathExpressionContext;
    expression(): ExpressionContext;
    DOT(): TerminalNode;
    qualifiedName(): QualifiedNameContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class UnaryExpressionContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: UnaryExpressionContext): void;
}
export declare class SignedUnaryExpressionPlusContext extends UnaryExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryExpressionContext);
    ADD(): TerminalNode;
    unaryExpressionNotPlusMinus(): UnaryExpressionNotPlusMinusContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class SignedUnaryExpressionMinusContext extends UnaryExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryExpressionContext);
    SUB(): TerminalNode;
    unaryExpression(): UnaryExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class FnInvocationContext extends UnaryExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryExpressionContext);
    unaryExpression(): UnaryExpressionContext;
    parameters(): ParametersContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NonSignedUnaryExpressionContext extends UnaryExpressionContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryExpressionContext);
    unaryExpressionNotPlusMinus(): UnaryExpressionNotPlusMinusContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class UnaryExpressionNotPlusMinusContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: UnaryExpressionNotPlusMinusContext): void;
}
export declare class UenpmPrimaryContext extends UnaryExpressionNotPlusMinusContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryExpressionNotPlusMinusContext);
    primary(): PrimaryContext;
    DOT(): TerminalNode;
    qualifiedName(): QualifiedNameContext;
    parameters(): ParametersContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: PrimaryContext): void;
}
export declare class PrimaryQuantifiedExpressionContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    quantifiedExpression(): QuantifiedExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryContextContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    context(): ContextContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryIfExpressionContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    ifExpression(): IfExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryIntervalContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    interval(): IntervalContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryListContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    list(): ListContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryUnaryTestContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    simplePositiveUnaryTest(): SimplePositiveUnaryTestContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryNameContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    qualifiedName(): QualifiedNameContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryForExpressionContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    forExpression(): ForExpressionContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryParensContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    LPAREN(): TerminalNode;
    expression(): ExpressionContext;
    RPAREN(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PrimaryLiteralContext extends PrimaryContext {
    constructor(parser: FEEL_1_1Parser, ctx: PrimaryContext);
    literal(): LiteralContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class LiteralContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: LiteralContext): void;
}
export declare class NullLiteralContext extends LiteralContext {
    constructor(parser: FEEL_1_1Parser, ctx: LiteralContext);
    NULL(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class StringLiteralContext extends LiteralContext {
    constructor(parser: FEEL_1_1Parser, ctx: LiteralContext);
    StringLiteral(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class AtLiteralLabelContext extends LiteralContext {
    constructor(parser: FEEL_1_1Parser, ctx: LiteralContext);
    atLiteral(): AtLiteralContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class BoolLiteralContext extends LiteralContext {
    constructor(parser: FEEL_1_1Parser, ctx: LiteralContext);
    BooleanLiteral(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NumberLiteralContext extends LiteralContext {
    constructor(parser: FEEL_1_1Parser, ctx: LiteralContext);
    IntegerLiteral(): TerminalNode;
    FloatingPointLiteral(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class AtLiteralContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    AT(): TerminalNode;
    atLiteralValue(): AtLiteralValueContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class AtLiteralValueContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    StringLiteral(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class SimplePositiveUnaryTestContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: SimplePositiveUnaryTestContext): void;
}
export declare class PositiveUnaryTestIntervalContext extends SimplePositiveUnaryTestContext {
    constructor(parser: FEEL_1_1Parser, ctx: SimplePositiveUnaryTestContext);
    interval(): IntervalContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PositiveUnaryTestIneqContext extends SimplePositiveUnaryTestContext {
    _op: Token;
    constructor(parser: FEEL_1_1Parser, ctx: SimplePositiveUnaryTestContext);
    endpoint(): EndpointContext;
    EQUAL(): TerminalNode;
    NOTEQUAL(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PositiveUnaryTestIneqIntervalContext extends SimplePositiveUnaryTestContext {
    _op: Token;
    constructor(parser: FEEL_1_1Parser, ctx: SimplePositiveUnaryTestContext);
    endpoint(): EndpointContext;
    LT(): TerminalNode;
    GT(): TerminalNode;
    LE(): TerminalNode;
    GE(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class SimplePositiveUnaryTestsContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    simplePositiveUnaryTest_list(): SimplePositiveUnaryTestContext[];
    simplePositiveUnaryTest(i: number): SimplePositiveUnaryTestContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class SimpleUnaryTestsContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: SimpleUnaryTestsContext): void;
}
export declare class PositiveUnaryTestDashContext extends SimpleUnaryTestsContext {
    constructor(parser: FEEL_1_1Parser, ctx: SimpleUnaryTestsContext);
    SUB(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PositiveSimplePositiveUnaryTestsContext extends SimpleUnaryTestsContext {
    constructor(parser: FEEL_1_1Parser, ctx: SimpleUnaryTestsContext);
    simplePositiveUnaryTests(): SimplePositiveUnaryTestsContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NegatedSimplePositiveUnaryTestsContext extends SimpleUnaryTestsContext {
    constructor(parser: FEEL_1_1Parser, ctx: SimpleUnaryTestsContext);
    NOT(): TerminalNode;
    LPAREN(): TerminalNode;
    simplePositiveUnaryTests(): SimplePositiveUnaryTestsContext;
    RPAREN(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PositiveUnaryTestContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    expression(): ExpressionContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class PositiveUnaryTestsContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    positiveUnaryTest_list(): PositiveUnaryTestContext[];
    positiveUnaryTest(i: number): PositiveUnaryTestContext;
    COMMA_list(): TerminalNode[];
    COMMA(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class UnaryTestsRootContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    unaryTests(): UnaryTestsContext;
    EOF(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class UnaryTestsContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    get ruleIndex(): number;
    copyFrom(ctx: UnaryTestsContext): void;
}
export declare class UnaryTests_emptyContext extends UnaryTestsContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryTestsContext);
    SUB(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class UnaryTests_positiveContext extends UnaryTestsContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryTestsContext);
    positiveUnaryTests(): PositiveUnaryTestsContext;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class UnaryTests_negatedContext extends UnaryTestsContext {
    constructor(parser: FEEL_1_1Parser, ctx: UnaryTestsContext);
    NOT(): TerminalNode;
    LPAREN(): TerminalNode;
    positiveUnaryTests(): PositiveUnaryTestsContext;
    RPAREN(): TerminalNode;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class EndpointContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    additiveExpression(): AdditiveExpressionContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class IntervalContext extends ParserRuleContext {
    _low: Token;
    _start: EndpointContext;
    _end: EndpointContext;
    _up: Token;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    ELIPSIS(): TerminalNode;
    LPAREN(): TerminalNode;
    endpoint_list(): EndpointContext[];
    endpoint(i: number): EndpointContext;
    RPAREN(): TerminalNode;
    LBRACK_list(): TerminalNode[];
    LBRACK(i: number): TerminalNode;
    RBRACK_list(): TerminalNode[];
    RBRACK(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class QualifiedNameContext extends ParserRuleContext {
    qns: Array<string>;
    _n1: NameRefContext;
    _n2: NameRefContext;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    nameRef_list(): NameRefContext[];
    nameRef(i: number): NameRefContext;
    DOT_list(): TerminalNode[];
    DOT(i: number): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NameRefContext extends ParserRuleContext {
    _st: Token;
    _not_st: Token;
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    Identifier(): TerminalNode;
    NOT(): TerminalNode;
    nameRefOtherToken_list(): NameRefOtherTokenContext[];
    nameRefOtherToken(i: number): NameRefOtherTokenContext;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class NameRefOtherTokenContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    LPAREN(): TerminalNode;
    RPAREN(): TerminalNode;
    LBRACK(): TerminalNode;
    RBRACK(): TerminalNode;
    LBRACE(): TerminalNode;
    RBRACE(): TerminalNode;
    LT(): TerminalNode;
    GT(): TerminalNode;
    EQUAL(): TerminalNode;
    BANG(): TerminalNode;
    COMMA(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
export declare class ReusableKeywordsContext extends ParserRuleContext {
    constructor(parser?: FEEL_1_1Parser, parent?: ParserRuleContext, invokingState?: number);
    FOR(): TerminalNode;
    RETURN(): TerminalNode;
    IF(): TerminalNode;
    THEN(): TerminalNode;
    ELSE(): TerminalNode;
    SOME(): TerminalNode;
    EVERY(): TerminalNode;
    SATISFIES(): TerminalNode;
    INSTANCE(): TerminalNode;
    OF(): TerminalNode;
    FUNCTION(): TerminalNode;
    EXTERNAL(): TerminalNode;
    OR(): TerminalNode;
    AND(): TerminalNode;
    BETWEEN(): TerminalNode;
    NOT(): TerminalNode;
    NULL(): TerminalNode;
    TRUE(): TerminalNode;
    FALSE(): TerminalNode;
    get ruleIndex(): number;
    enterRule(listener: FEEL_1_1Listener): void;
    exitRule(listener: FEEL_1_1Listener): void;
}
//# sourceMappingURL=FEEL_1_1Parser.d.ts.map