var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useState } from "react";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { SearchIcon } from "@patternfly/react-icons/dist/js/icons/search-icon";
import { Redirect } from "react-router";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const NoData = (_a) => {
    var { ouiaId, ouiaSafe } = _a, props = __rest(_a, ["ouiaId", "ouiaSafe"]);
    let prevPath;
    if (props.location.state !== undefined) {
        prevPath = props.location.state.prev;
    }
    else {
        prevPath = props.defaultPath;
    }
    const tempPath = prevPath.split("/");
    prevPath = tempPath.filter((item) => item);
    const [isRedirect, setIsredirect] = useState(false);
    const redirectHandler = () => {
        setIsredirect(true);
    };
    return (React.createElement(React.Fragment, null,
        isRedirect && React.createElement(Redirect, { to: `/${prevPath[0]}` }),
        React.createElement(PageSection, Object.assign({ isFilled: true }, componentOuiaProps(ouiaId, "no-data", ouiaSafe ? ouiaSafe : !isRedirect)),
            React.createElement(Bullseye, null,
                React.createElement(EmptyState, { variant: EmptyStateVariant.full },
                    React.createElement(EmptyStateIcon, { icon: SearchIcon }),
                    React.createElement(Title, { headingLevel: "h1", size: "4xl" }, props.location.state ? props.location.state.title : "No matches"),
                    React.createElement(EmptyStateBody, null, props.location.state ? props.location.state.description : "No data to display"),
                    React.createElement(Button, { variant: "primary", onClick: redirectHandler, "data-testid": "redirect-button" }, props.location.state ? props.location.state.buttonText : props.defaultButton))))));
};
//# sourceMappingURL=NoData.js.map