"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getJsonStateNameFromOffset = exports.getJsonStateNameOffset = void 0;
var channel_1 = require("@kie-tools/json-yaml-language-service/dist/channel");
var SwfOffsets_1 = require("./SwfOffsets");
function getJsonStateNameOffset(args) {
    var rootNode = (0, channel_1.parseJsonContent)(args.content);
    return (0, SwfOffsets_1.getStateNameOffset)(__assign(__assign({}, args), { rootNode: rootNode }));
}
exports.getJsonStateNameOffset = getJsonStateNameOffset;
function getJsonStateNameFromOffset(args) {
    var rootNode = (0, channel_1.parseJsonContent)(args.content);
    return (0, SwfOffsets_1.getStateNameFromOffset)(__assign(__assign({}, args), { rootNode: rootNode }));
}
exports.getJsonStateNameFromOffset = getJsonStateNameFromOffset;
//# sourceMappingURL=SwfJsonOffsets.js.map