"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStateNameFromOffset = exports.getStateNameOffset = exports.getAllStateOffsets = void 0;
var channel_1 = require("@kie-tools/json-yaml-language-service/dist/channel");
function getAllStateOffsets(args) {
    var result = { states: {} };
    var allStateNames = (0, channel_1.findNodesAtLocation)({ root: args.rootNode, path: ["states", "*", "name"] });
    allStateNames.forEach(function (node) {
        if (!node.parent || !node.parent.parent) {
            return;
        }
        result.states[node.value] = {
            stateNameOffset: node.parent.offset,
            offset: {
                start: node.parent.parent.offset,
                end: node.parent.parent.offset + node.parent.parent.length,
            },
        };
    });
    return result;
}
exports.getAllStateOffsets = getAllStateOffsets;
function getStateNameOffset(args) {
    if (!args.rootNode || !args.stateName) {
        return;
    }
    var stateNode = (0, channel_1.findNodesAtLocation)({
        root: args.rootNode,
        path: ["states", "*", "name"],
    }).filter(function (node) { return node.value === args.stateName; })[0];
    if (!stateNode || !stateNode.parent) {
        return undefined;
    }
    return stateNode.parent.offset;
}
exports.getStateNameOffset = getStateNameOffset;
function getStateNameFromOffset(args) {
    if (!args.rootNode || !args.offset) {
        return;
    }
    var fullTextOffsets = getAllStateOffsets({ rootNode: args.rootNode });
    for (var stateName in fullTextOffsets === null || fullTextOffsets === void 0 ? void 0 : fullTextOffsets.states) {
        var blockOffset = fullTextOffsets.states[stateName].offset;
        if (args.offset >= blockOffset.start && args.offset <= blockOffset.end) {
            return stateName;
        }
    }
    return;
}
exports.getStateNameFromOffset = getStateNameFromOffset;
//# sourceMappingURL=SwfOffsets.js.map