/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jbpm.process.core.datatype;

import java.io.Externalizable;

/**
 * Abstract representation of a datatype.
 */
public interface DataType extends Externalizable {

    /**
     * Returns true if the given value is a valid value of this data type.
     */
    boolean verifyDataType(Object value);

    String writeValue(Object value);

    Object readValue(String value);

    /**
     * Returns the corresponding Java type of this datatype
     */
    String getStringType();

    default Class<?> getObjectClass() {
        return Object.class;
    }

    default boolean isAssignableFrom(DataType dataType) {
        return DataTypeUtils.isAssignableFrom(this, dataType);
    }

    default Object clone(Object value) {
        return value;
    }
}
