/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

/**
 * Kubernetes object used to deploy this Kogito service.
 */
public class KogitoServiceDeploymentTarget {

    private final String group;
    private final String version;
    private final String kind;
    private final String name;

    public KogitoServiceDeploymentTarget(String group, String version, String kind, String name) {
        this.group = group;
        this.version = version;
        this.kind = kind;
        this.name = name;
    }

    public String getGroup() {
        return group;
    }

    public String getVersion() {
        return version;
    }

    public String getKind() {
        return kind;
    }

    public String getName() {
        return name;
    }

    public String getApiVersion() {
        return String.format("%s/%s", this.group, this.version);
    }
}
