"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LfsWorkspaceDescriptorService = void 0;
var uuid_1 = require("uuid");
var kie_sandbox_fs_1 = __importDefault(require("@kie-tools/kie-sandbox-fs"));
var DefaultBackend_1 = __importDefault(require("@kie-tools/kie-sandbox-fs/dist/DefaultBackend"));
var DexieBackend_1 = __importDefault(require("@kie-tools/kie-sandbox-fs/dist/DexieBackend"));
var path_1 = require("path");
var EncoderDecoder_1 = require("../encoderdecoder/EncoderDecoder");
var LfsStorageService_1 = require("./LfsStorageService");
var WorkspaceOrigin_1 = require("../worker/api/WorkspaceOrigin");
var GitConstants_1 = require("../constants/GitConstants");
var LfsWorkspaceDescriptorService = (function () {
    function LfsWorkspaceDescriptorService(databaseName, storageService) {
        this.storageService = storageService;
        this.descriptorFs = new kie_sandbox_fs_1.default(databaseName, {
            backend: new DefaultBackend_1.default({
                idbBackendDelegate: function (fileDbName, fileStoreName) { return new DexieBackend_1.default(fileDbName, fileStoreName); },
            }),
        });
    }
    LfsWorkspaceDescriptorService.prototype.listAll = function () {
        return __awaiter(this, void 0, void 0, function () {
            var descriptorsFilePaths, descriptorFiles;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.walk({
                            fs: this.descriptorFs,
                            startFromDirPath: "/",
                            shouldExcludeDir: function () { return false; },
                            onVisit: function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var absolutePath = _b.absolutePath;
                                return __generator(this, function (_c) {
                                    return [2, absolutePath];
                                });
                            }); },
                        })];
                    case 1:
                        descriptorsFilePaths = _a.sent();
                        return [4, this.storageService.getFiles(this.descriptorFs, descriptorsFilePaths)];
                    case 2:
                        descriptorFiles = _a.sent();
                        return [2, Promise.all(descriptorFiles.map(function (f) { return __awaiter(_this, void 0, void 0, function () { var _a, _b, _c, _d; return __generator(this, function (_e) {
                                switch (_e.label) {
                                    case 0:
                                        _b = (_a = JSON).parse;
                                        _d = (_c = EncoderDecoder_1.decoder).decode;
                                        return [4, f.getFileContents()];
                                    case 1: return [2, _b.apply(_a, [_d.apply(_c, [_e.sent()])])];
                                }
                            }); }); }))];
                }
            });
        });
    };
    LfsWorkspaceDescriptorService.prototype.bumpLastUpdatedDate = function (id) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, _c, _d, _e;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        _b = (_a = this.storageService).updateFile;
                        _c = [this.descriptorFs];
                        _d = this.toStorageFile;
                        _e = [{}];
                        return [4, this.get(id)];
                    case 1: return [4, _b.apply(_a, _c.concat([_d.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _e.concat([(_f.sent())])), { lastUpdatedDateISO: new Date().toISOString() }])])]))];
                    case 2:
                        _f.sent();
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceDescriptorService.prototype.exists = function (workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.getFile(this.descriptorFs, this.getAbsolutePath(workspaceId))];
                    case 1: return [2, (_a.sent()) != undefined];
                }
            });
        });
    };
    LfsWorkspaceDescriptorService.prototype.get = function (workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            var descriptorFile, _a, _b, _c, _d;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0: return [4, this.storageService.getFile(this.descriptorFs, this.getAbsolutePath(workspaceId))];
                    case 1:
                        descriptorFile = _e.sent();
                        if (!descriptorFile) {
                            throw new Error("Descriptor not found (".concat(workspaceId, ")"));
                        }
                        _b = (_a = JSON).parse;
                        _d = (_c = EncoderDecoder_1.decoder).decode;
                        return [4, descriptorFile.getFileContents()];
                    case 2: return [2, _b.apply(_a, [_d.apply(_c, [_e.sent()])])];
                }
            });
        });
    };
    LfsWorkspaceDescriptorService.prototype.create = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var descriptor;
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        descriptor = {
                            workspaceId: (_a = args.workspaceId) !== null && _a !== void 0 ? _a : this.newWorkspaceId(),
                            name: args.name,
                            origin: (_b = args.origin) !== null && _b !== void 0 ? _b : { kind: WorkspaceOrigin_1.WorkspaceKind.LOCAL, branch: GitConstants_1.GIT_DEFAULT_BRANCH },
                            createdDateISO: new Date().toISOString(),
                            lastUpdatedDateISO: new Date().toISOString(),
                            gitAuthSessionId: undefined,
                            gitInsecurelyDisableTlsCertificateValidation: undefined,
                        };
                        return [4, this.storageService.createOrOverwriteFile(this.descriptorFs, this.toStorageFile(descriptor))];
                    case 1:
                        _c.sent();
                        return [2, descriptor];
                }
            });
        });
    };
    LfsWorkspaceDescriptorService.prototype.delete = function (workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.deleteFile(this.descriptorFs, this.getAbsolutePath(workspaceId))];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceDescriptorService.prototype.rename = function (workspaceId, newName) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, _c, _d, _e;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        _b = (_a = this.storageService).updateFile;
                        _c = [this.descriptorFs];
                        _d = this.toStorageFile;
                        _e = [{}];
                        return [4, this.get(workspaceId)];
                    case 1: return [4, _b.apply(_a, _c.concat([_d.apply(this, [__assign.apply(void 0, [__assign.apply(void 0, _e.concat([(_f.sent())])), { name: newName }])])]))];
                    case 2:
                        _f.sent();
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceDescriptorService.prototype.toStorageFile = function (descriptor) {
        var _this = this;
        return new LfsStorageService_1.LfsStorageFile({
            path: this.getAbsolutePath(descriptor.workspaceId),
            getFileContents: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                return [2, EncoderDecoder_1.encoder.encode(JSON.stringify(descriptor))];
            }); }); },
        });
    };
    LfsWorkspaceDescriptorService.prototype.getAbsolutePath = function (relativePath) {
        return (0, path_1.join)("/", relativePath !== null && relativePath !== void 0 ? relativePath : "");
    };
    LfsWorkspaceDescriptorService.prototype.newWorkspaceId = function () {
        return (0, uuid_1.v4)();
    };
    return LfsWorkspaceDescriptorService;
}());
exports.LfsWorkspaceDescriptorService = LfsWorkspaceDescriptorService;
//# sourceMappingURL=LfsWorkspaceDescriptorService.js.map