import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { ExclamationTriangleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { I18nWrapped } from "@kie-tools-core/i18n/dist/react-components";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { ExclamationIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-icon";
const ISSUES_URL = "https://github.com/apache/incubator-kie-issues/issues";
export var FormStatus;
(function (FormStatus) {
    FormStatus[FormStatus["WITHOUT_ERROR"] = 0] = "WITHOUT_ERROR";
    FormStatus[FormStatus["VALIDATOR_ERROR"] = 1] = "VALIDATOR_ERROR";
    FormStatus[FormStatus["AUTO_GENERATION_ERROR"] = 2] = "AUTO_GENERATION_ERROR";
    FormStatus[FormStatus["EMPTY"] = 3] = "EMPTY";
})(FormStatus || (FormStatus = {}));
export function EmptyFormStatus({ i18n }) {
    return (_jsx("div", { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(TextContent, { children: _jsx(Text, { component: "h2", children: i18n.form.status.emptyForm.title }) }), _jsx(EmptyStateBody, { children: _jsx(TextContent, { children: _jsx(Text, { component: TextVariants.p, children: i18n.form.status.emptyForm.explanation }) }) })] }) }));
}
export function AutoGenerationErrorFormStatus(props) {
    return (_jsx("div", { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: ExclamationIcon }), _jsx(TextContent, { children: _jsx(Text, { component: "h2", children: props.i18n.form.status.autoGenerationError.title }) }), _jsxs(EmptyStateBody, { children: [_jsx(TextContent, { children: props.i18n.form.status.autoGenerationError.explanation }), _jsx("br", {}), props.notificationsPanel && (_jsx(TextContent, { children: _jsx(I18nWrapped, { components: { link: _jsx("a", { onClick: props.openValidationTab, children: props.i18n.terms.validation }) }, children: props.i18n.form.status.autoGenerationError.checkNotificationPanel }) }))] })] }) }));
}
export function ValidatorErrorFormStatus({ i18n }) {
    return (_jsx("div", { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: ExclamationTriangleIcon }), _jsx(TextContent, { children: _jsx(Text, { component: "h2", children: i18n.form.status.validatorError.title }) }), _jsx(EmptyStateBody, { children: _jsx(TextContent, { children: _jsx(Text, { children: _jsx(I18nWrapped, { components: {
                                    jira: (_jsx("a", { href: ISSUES_URL, target: "_blank", rel: "noopener noreferrer", children: ISSUES_URL })),
                                }, children: i18n.form.status.validatorError.message }) }) }) })] }) }));
}
//# sourceMappingURL=FormStatus.js.map