import { CreateResourceFetchArgs, UniqueResourceFetchArgs, ResourceFetch } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { IObjectReference, IResourceRequirements } from "kubernetes-models/v1";
import { ResourceDescriptor, ResourceDataSource } from "../common";
export interface DockerBuildStrategy {
    type: "Docker";
}
export interface BinaryBuildSource {
    type: "Binary";
    binary: {};
}
export interface BuildOutput {
    to: IObjectReference;
}
export type BuildSource = BinaryBuildSource;
export type BuildStrategy = DockerBuildStrategy;
export interface BuildConfigSpec {
    output: BuildOutput;
    resources: IResourceRequirements;
    source: BuildSource;
    strategy: BuildStrategy;
}
export interface BuildConfigDescriptor extends ResourceDescriptor {
    spec: BuildConfigSpec;
}
export type CreateBuildConfigTemplateArgs = {
    resourceDataSource: ResourceDataSource.TEMPLATE;
};
export type CreateBuildConfigArgs = CreateResourceFetchArgs & (CreateBuildConfigTemplateArgs | {
    descriptor: BuildConfigDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const BUILD_CONFIG_TEMPLATE: (args: CreateResourceFetchArgs & CreateBuildConfigTemplateArgs) => BuildConfigDescriptor;
export declare class CreateBuildConfig extends ResourceFetch {
    protected args: CreateBuildConfigArgs;
    constructor(args: CreateBuildConfigArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class DeleteBuildConfig extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
export declare class InstantiateBinary extends ResourceFetch {
    protected args: UniqueResourceFetchArgs & {
        zipBlob: Blob;
    };
    constructor(args: UniqueResourceFetchArgs & {
        zipBlob: Blob;
    });
    method(): HttpMethod;
    body(): Blob;
    contentType(): string;
    endpoint(): string;
}
//# sourceMappingURL=BuildConfig.d.ts.map