import { jsx as _jsx } from "react/jsx-runtime";
import _ from "lodash";
import { ActionList, ActionListItem } from "@patternfly/react-core/dist/js/components/ActionList";
import { convertActionsToButton } from "../../utils";
import { componentOuiaProps } from "../../ouiaTools";
import "../styles.css";
export const FormFooter = ({ actions, enabled = true, onSubmitForm, ouiaId, ouiaSafe, }) => {
    var _a;
    if (_.isEmpty(actions)) {
        return null;
    }
    const actionItems = (_a = convertActionsToButton(actions, enabled, onSubmitForm)) === null || _a === void 0 ? void 0 : _a.map((button, index) => {
        return (_jsx(ActionListItem, { "data-testid": "action-list-item", children: button }, `form-action-${index}`));
    });
    return (_jsx("div", { className: "kogito-components-common__form-footer-padding-top", ...componentOuiaProps(ouiaId, "form-footer", ouiaSafe), children: _jsx(ActionList, { "data-testid": "action-list", children: actionItems }) }));
};
//# sourceMappingURL=FormFooter.js.map