import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { componentOuiaProps } from "../../ouiaTools";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { Page, PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { EmptyState, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { ClusterIcon } from "@patternfly/react-icons/dist/js/icons/cluster-icon";
export const KeycloakUnavailablePage = ({ ouiaId, ouiaSafe }) => {
    return (_jsx(Page, { children: _jsx(PageSection, { children: _jsx(Bullseye, { children: _jsxs(EmptyState, { ...componentOuiaProps(ouiaId, "server-unavailable", ouiaSafe), children: [_jsx(EmptyStateIcon, { icon: ClusterIcon }), _jsx(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: "503: We couldn't contact the server" }), _jsx(Text, { component: TextVariants.blockquote, children: "We could not reach the server, you can contact the administrator or try to reload the page by clicking on the button below." }), _jsx(Button, { variant: "primary", onClick: () => window.location.reload(), isInline: true, children: "Retry" })] }) }) }) }));
};
//# sourceMappingURL=KeycloakUnavailablePage.js.map