import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React from "react";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { componentOuiaProps } from "../../ouiaTools";
import { BulkList } from "../BulkList";
export const ProcessInfoModal = ({ modalContent, modalTitle, isModalOpen, handleModalToggle, resetSelected, operationResult, processName, ouiaId, ouiaSafe, }) => {
    const onOkClick = () => {
        handleModalToggle();
        operationResult && (resetSelected === null || resetSelected === void 0 ? void 0 : resetSelected());
    };
    const createBoldText = (text, shouldBeBold) => {
        if (shouldBeBold && shouldBeBold.length > 0) {
            const textArray = text.split(shouldBeBold);
            return (_jsx("span", { children: textArray.map((item, index) => (_jsxs(React.Fragment, { children: [item, index !== textArray.length - 1 && _jsx("b", { children: shouldBeBold })] }, index))) }));
        }
        else {
            return _jsx("span", { children: text });
        }
    };
    return (_jsxs(Modal, { variant: "small", title: "", header: modalTitle, isOpen: isModalOpen, onClose: onOkClick, "aria-label": "process list modal", "aria-labelledby": "process list modal", actions: [
            _jsx(Button, { variant: "primary", onClick: onOkClick, children: "OK" }, "confirm-selection"),
        ], ...componentOuiaProps(ouiaId, "process-list-modal", ouiaSafe), children: [operationResult !== undefined && _jsx(BulkList, { operationResult: operationResult }), modalContent && processName && (_jsx(TextContent, { children: _jsx(Text, { children: createBoldText(modalContent, processName) }) }))] }));
};
//# sourceMappingURL=ProcessInfoModal.js.map