import { StateControl } from "../../channel";
import { KogitoEditorChannelApi, StateControlCommand, EditorContent } from "../../api";
import { WorkspaceEdit, ResourceContent, ResourceContentRequest, ResourceListRequest, ResourcesList } from "@kie-tools-core/workspace/dist/api";
import { EmbeddedEditorFile } from "../../channel";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { EditorTheme } from "../../api";
export declare class EmbeddedEditorChannelApiImpl implements KogitoEditorChannelApi {
    private readonly stateControl;
    private readonly file;
    private readonly locale;
    private readonly overrides;
    constructor(stateControl: StateControl, file: EmbeddedEditorFile, locale: string, overrides: Partial<KogitoEditorChannelApi>);
    kogitoWorkspace_newEdit(edit: WorkspaceEdit): void;
    kogitoEditor_stateControlCommandUpdate(command: StateControlCommand): void;
    kogitoEditor_contentRequest(): Promise<{
        content: string;
        normalizedPosixPathRelativeToTheWorkspaceRoot: string;
    }>;
    kogitoWorkspace_resourceContentRequest(request: ResourceContentRequest): Promise<ResourceContent | undefined>;
    kogitoWorkspace_resourceListRequest(request: ResourceListRequest): Promise<ResourcesList>;
    kogitoWorkspace_openFile(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoEditor_ready(): void;
    kogitoEditor_setContentError(editorContent: EditorContent): void;
    kogitoEditor_theme(): import("@kie-tools-core/envelope-bus/dist/api").SharedValueProvider<EditorTheme>;
    kogitoI18n_getLocale(): Promise<string>;
    kogitoNotifications_createNotification(notification: Notification): void;
    kogitoNotifications_setNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]): void;
    kogitoNotifications_removeNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
}
//# sourceMappingURL=EmbeddedEditorChannelApiImpl.d.ts.map