import { Editor, KogitoEditorChannelApi, KogitoEditorEnvelopeApi, KogitoEditorEnvelopeContextType } from "../api";
import { EditorEnvelopeViewApi } from "./EditorEnvelopeView";
import { Envelope, EnvelopeApiFactory } from "@kie-tools-core/envelope";
import { I18nService } from "@kie-tools-core/i18n/dist/envelope";
import { ApiDefinition } from "@kie-tools-core/envelope-bus/dist/api";
import { KeyboardShortcutsService } from "@kie-tools-core/keyboard-shortcuts/dist/envelope/KeyboardShortcutsService";
export declare class KogitoEditorEnvelope<E extends Editor, EnvelopeApi extends KogitoEditorEnvelopeApi & ApiDefinition<EnvelopeApi>, ChannelApi extends KogitoEditorChannelApi & ApiDefinition<ChannelApi>> {
    private readonly kogitoEditorEnvelopeApiFactory;
    private readonly keyboardShortcutsService;
    private readonly i18nService;
    private readonly envelope;
    private readonly context;
    constructor(kogitoEditorEnvelopeApiFactory: EnvelopeApiFactory<EnvelopeApi, ChannelApi, EditorEnvelopeViewApi<E>, KogitoEditorEnvelopeContextType<EnvelopeApi, ChannelApi>>, keyboardShortcutsService: KeyboardShortcutsService, i18nService: I18nService, envelope: Envelope<EnvelopeApi, ChannelApi, EditorEnvelopeViewApi<E>, KogitoEditorEnvelopeContextType<EnvelopeApi, ChannelApi>>, context?: KogitoEditorEnvelopeContextType<EnvelopeApi, ChannelApi>);
    start(container: HTMLElement): Promise<import("@kie-tools-core/envelope-bus/dist/envelope").EnvelopeClient<EnvelopeApi, ChannelApi>>;
    private renderView;
}
//# sourceMappingURL=KogitoEditorEnvelope.d.ts.map