import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { CustomDashboardListChannelApiImpl } from "./CustomDashboardListChannelApiImpl";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
export const EmbeddedCustomDashboardList = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.customDashboardList__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        });
    }, []);
    return (_jsx(EmbeddedCustomDashboardListEnvelope, { ref: forwardedRef, apiImpl: new CustomDashboardListChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedCustomDashboardListEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedCustomDashboardList.js.map