import { jsx as _jsx } from "react/jsx-runtime";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Gallery, GalleryItem } from "@patternfly/react-core/dist/js/layouts/Gallery";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import CustomDashboardCard from "../CustomDashboardCard/CustomDashboardCard";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
const CustomDashboardsGallery = ({ driver, customDashboardsDatas, isLoading, ouiaId, ouiaSafe, }) => {
    if (isLoading) {
        return (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Loading customDashboard...", ouiaId: "custom-dashboard-list-loading-custom-dashboard" }) }));
    }
    if (!isLoading && customDashboardsDatas && customDashboardsDatas.length === 0) {
        return (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }));
    }
    return (_jsx(Gallery, { hasGutter: true, style: { margin: "25px" }, ...componentOuiaProps(ouiaId, "customDashboard-gallery", ouiaSafe), children: customDashboardsDatas &&
            customDashboardsDatas.map((customDashboardData, index) => (_jsx(GalleryItem, { children: _jsx(CustomDashboardCard, { customDashboardData: customDashboardData, driver: driver }, index) }, index))) }));
};
export default CustomDashboardsGallery;
//# sourceMappingURL=CustomDashboardsGallery.js.map