import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import React, { useImperativeHandle, useState } from "react";
import CustomDashboardView from "./components/CustomDashboardView/CustomDashboardView";
import CustomDashboardViewEnvelopeViewDriver from "./CustomDashboardViewEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const CustomDashboardViewEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [customDashboardName, setCustomDashboardName] = useState();
    const [targetOrigin, setTargetOrigin] = useState();
    useImperativeHandle(forwardedRef, () => ({
        initialize: (dashboardName, targetOrigin) => {
            setEnvelopeConnectedToChannel(true);
            setCustomDashboardName(dashboardName);
            setTargetOrigin(targetOrigin);
        },
    }), []);
    return (_jsx(_Fragment, { children: customDashboardName && customDashboardName != "undefined" && (_jsx(CustomDashboardView, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new CustomDashboardViewEnvelopeViewDriver(props.channelApi), customDashboardName: customDashboardName, targetOrigin: targetOrigin })) }));
});
export default CustomDashboardViewEnvelopeView;
//# sourceMappingURL=CustomDashboardViewEnvelopeView.js.map