import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { FormDetailsEnvelopeView } from "./FormDetailsEnvelopeView";
import { FormDetailsEnvelopeApiImpl } from "./FormDetailsEnvelopeApiImpl";
import { Envelope } from "@kie-tools-core/envelope";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            args.container.className = "kogito-form-details-container";
            ReactDOM.render(_jsx(FormDetailsEnvelopeView, { ref: ref, channelApi: envelope.channelApi, targetOrigin: args.targetOrigin }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new FormDetailsEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=FormDetailsEnvelope.js.map