import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Card } from "@patternfly/react-core/dist/js/components/Card";
import { Drawer, DrawerContent, DrawerContentBody, DrawerHead, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { Tab, Tabs, TabTitleText } from "@patternfly/react-core/dist/js/components/Tabs";
import isEmpty from "lodash/isEmpty";
import { useEffect, useRef, useState, useCallback } from "react";
import FormDisplayerContainer from "../../containers/FormDisplayerContainer/FormDisplayerContainer";
import FormEditor from "../FormEditor/FormEditor";
import { useFormDetailsContext } from "../contexts/FormDetailsContext";
const FormDetails = ({ isEnvelopeConnectedToChannel, driver, formData, ouiaId, ouiaSafe, targetOrigin, }) => {
    const [activeTab, setActiveTab] = useState(0);
    const [formContent, setFormContent] = useState({});
    const [error, setError] = useState(null);
    const [isLoading, setIsLoading] = useState(true);
    const editorResize = useRef({});
    const appContext = useFormDetailsContext();
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            init();
        }
    }, [isEnvelopeConnectedToChannel]);
    const init = useCallback(async () => {
        try {
            if (formData) {
                const response = await driver.getFormContent(formData.name);
                setFormContent(response);
                setIsLoading(false);
            }
        }
        catch (error) {
            setError(error);
        }
    }, [driver, formData]);
    const saveContent = useCallback((args) => (content) => {
        try {
            setFormContent((prev) => {
                if (args.isSource) {
                    const newForm = { ...prev, source: content };
                    driver.saveFormContent(formData.name, newForm);
                    appContext.updateContent(newForm);
                    return newForm;
                }
                if (args.isConfig) {
                    const newForm = { ...prev, configuration: { ...prev.configuration, resources: JSON.parse(content) } };
                    driver.saveFormContent(formData.name, newForm);
                    appContext.updateContent(newForm);
                    return newForm;
                }
                return prev;
            });
        }
        catch (error) {
            setError(error);
        }
    }, [appContext, driver, formData.name]);
    const onTabSelect = useCallback((_event, tabIndex) => {
        setActiveTab(tabIndex);
    }, []);
    const getSource = useCallback(() => {
        var _a;
        if (!isEmpty(formContent)) {
            return (_a = formContent === null || formContent === void 0 ? void 0 : formContent.source) !== null && _a !== void 0 ? _a : "";
        }
        return "";
    }, [formContent]);
    const getType = useCallback(() => {
        if (!isEmpty(formData)) {
            return formData.type;
        }
        return "";
    }, [formData]);
    const getConfig = useCallback(() => {
        if (!isEmpty(formContent)) {
            return JSON.stringify(formContent === null || formContent === void 0 ? void 0 : formContent.configuration.resources, null, 2);
        }
        return "";
    }, [formContent]);
    const getFormLanguage = useCallback((args) => {
        if (args.isSource && args.formType) {
            if (args.formType.toLowerCase() === "tsx") {
                return "typescript";
            }
            if (args.formType.toLowerCase() === "html") {
                return "html";
            }
        }
        if (args.isConfig) {
            return "json";
        }
        return "txt";
    }, []);
    return error ? (_jsx(ServerErrors, { error: error, variant: "large" })) : (_jsx("div", { ...componentOuiaProps(ouiaId, "form-details", ouiaSafe), style: { height: "100%" }, children: !isLoading ? (_jsx(Drawer, { isStatic: true, children: _jsx(DrawerContent, { panelContent: _jsx(DrawerPanelContent, { isResizable: true, defaultSize: "800px", onResize: () => {
                        var _a;
                        (_a = editorResize === null || editorResize === void 0 ? void 0 : editorResize.current) === null || _a === void 0 ? void 0 : _a.doResize();
                    }, children: _jsx(DrawerHead, { style: { height: "100%" }, children: formContent && Object.keys(formContent)[0] && Object.keys(formContent)[0].length > 0 && (_jsx("span", { children: _jsx(FormDisplayerContainer, { formContent: formContent, targetOrigin: targetOrigin }) })) }) }), children: _jsxs(Tabs, { isFilled: true, activeKey: activeTab, onSelect: onTabSelect, children: [_jsx(Tab, { eventKey: 0, title: _jsx(TabTitleText, { children: "Source" }), id: "source-tab", "aria-labelledby": "source-tab", children: _jsx(DrawerContentBody, { style: {
                                    padding: "0px",
                                    background: "var(--pf-c-page__main-section--BackgroundColor)",
                                }, children: activeTab === 0 && (_jsx(FormEditor, { textContent: getSource(), saveContent: saveContent({ isSource: true }), formLanguage: getFormLanguage({ formType: getType(), isSource: true }), ref: editorResize })) }) }), _jsx(Tab, { eventKey: 1, title: _jsx(TabTitleText, { children: "Connections" }), id: "config-tab", "aria-labelledby": "config-tab", children: _jsx(DrawerContentBody, { style: {
                                    padding: "0px",
                                    background: "var(--pf-c-page__main-section--BackgroundColor)",
                                }, children: activeTab === 1 && (_jsx(FormEditor, { textContent: getConfig(), saveContent: saveContent({ isConfig: true }), formLanguage: getFormLanguage({ isConfig: true }), ref: editorResize })) }) })] }) }) })) : (_jsx(Card, { children: _jsx(KogitoSpinner, { spinnerText: "Loading form ..." }) })) }));
};
export default FormDetails;
//# sourceMappingURL=FormDetails.js.map