import isEmpty from "lodash/isEmpty";
export class FormDisplayerEnvelopeApiImpl {
    constructor(args) {
        this.args = args;
        this.capturedInitRequestYet = false;
        this.formDisplayer__notifyInit = (initArgs) => {
            this.view().initForm(initArgs);
        };
    }
    hasCapturedInitRequestYet() {
        return this.capturedInitRequestYet;
    }
    ackCapturedInitRequest() {
        this.capturedInitRequestYet = true;
    }
    async formDisplayer__init(association, initArgs) {
        this.args.envelopeClient.associate(association.origin, association.envelopeServerId);
        if (this.hasCapturedInitRequestYet()) {
            return;
        }
        this.ackCapturedInitRequest();
        this.view = await this.args.viewDelegate();
        if (!isEmpty(initArgs.form)) {
            this.view().initForm(initArgs);
        }
    }
    formDisplayer__startSubmit(context) {
        return this.view().startSubmit(context);
    }
    formDisplayer__notifySubmitResponse(response) {
        this.view().notifySubmitResponse(response);
    }
}
//# sourceMappingURL=FormDisplayerEnvelopeApiImpl.js.map