import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import React, { useEffect } from "react";
import { v4 as uuidv4 } from "uuid";
import { transform } from "@babel/standalone";
import ReactDOM from "react-dom";
import * as PatternflyReact from "@patternfly/react-core/dist/js";
import * as PatternflyReactIcons from "@patternfly/react-icons/dist/js";
import { sourceHandler } from "../../../utils";
import ResourcesContainer from "../ResourcesContainer/ResourcesContainer";
import "@patternfly/patternfly/patternfly.css";
const ReactFormRenderer = ({ source, resources, setIsExecuting }) => {
    useEffect(() => {
        if (source) {
            renderform();
        }
    }, [source, resources]);
    const renderform = () => {
        if (source) {
            setIsExecuting(true);
            try {
                window.React = React;
                window.ReactDOM = ReactDOM;
                window.PatternFlyReact = PatternflyReact;
                window.PatternflyReactIcons = PatternflyReactIcons;
                const container = document.getElementById("formContainer");
                if (!container) {
                    return;
                }
                container.innerHTML = "";
                const containerId = uuidv4();
                const formContainer = document.createElement("div");
                formContainer.id = containerId;
                container.appendChild(formContainer);
                const { reactElements, patternflyElements, patternflyIconElements, formName, trimmedSource } = sourceHandler(source);
                const content = `
        const {${reactElements}} = React;
        const {${patternflyElements}} = PatternFlyReact;
        ${patternflyIconElements !== undefined ? `const {${patternflyIconElements}} = PatternflyReactIcons;` : ""}
        ${trimmedSource}
        const target = document.getElementById("${containerId}");
        const element = window.React.createElement(${formName}, {});
        window.ReactDOM.render(element, target);
        `;
                const reactCode = transform(content.trim(), {
                    presets: [
                        "react",
                        [
                            "typescript",
                            {
                                allExtensions: true,
                                isTSX: true,
                            },
                        ],
                    ],
                }).code;
                const scriptElement = document.createElement("script");
                scriptElement.type = "module";
                scriptElement.text = reactCode;
                container.appendChild(scriptElement);
            }
            finally {
                setIsExecuting(false);
            }
        }
    };
    return (_jsx(_Fragment, { children: _jsxs("div", { children: [_jsx(ResourcesContainer, { resources: resources }), _jsx("div", { style: {
                        height: "100%",
                    }, id: "formContainer" })] }) }));
};
export default ReactFormRenderer;
//# sourceMappingURL=ReactFormRenderer.js.map