import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { enableMapSet, enablePatches } from "immer";
import { createStore } from "redux";
import { Actions, DataDictionaryFieldReducer, DataDictionaryReducer, HeaderReducer, ModelReducer, PMMLReducer, } from "./reducers";
import { PMML2XML, XML2PMML } from "@kie-tools/pmml-editor-marshaller";
import { Provider } from "react-redux";
import mergeReducers from "combine-reducer";
import { HistoryContext, HistoryService } from "./history";
import { LandingPage } from "./components/LandingPage/templates";
import { Page } from "@patternfly/react-core/dist/js/components/Page";
import { HashRouter } from "react-router-dom";
import { Redirect, Route, Switch } from "react-router";
import { EmptyStateNoContent } from "./components/LandingPage/organisms";
import { SingleEditorRouter } from "./components/EditorCore/organisms";
import { PMMLModels, SupportedCapability } from "./PMMLModelHelper";
import { Operation, OperationContext } from "./components/EditorScorecard";
import { toNotifications, ValidationContext, ValidationRegistry } from "./validation";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { Builder } from "./paths";
const EMPTY_PMML = `<PMML xmlns="http://www.dmg.org/PMML-4_4" version="4.4"><Header /><DataDictionary/></PMML>`;
export class PMMLEditor extends React.Component {
    constructor(props) {
        super(props);
        this.history = new HistoryService([
            (id) => {
                this.props.newEdit(new WorkspaceEdit(id));
            },
            () => {
                this.props.setNotifications(this.state.path, this.validate());
            },
        ]);
        this.validationRegistry = new ValidationRegistry();
        props.exposing(this);
        this.state = {
            path: "",
            content: "",
            originalContent: "",
            activeOperation: Operation.NONE,
        };
        enableMapSet();
        enablePatches();
        this.reducer = mergeReducers(PMMLReducer(this.history, this.validationRegistry), {
            Header: HeaderReducer(this.history),
            DataDictionary: mergeReducers(DataDictionaryReducer(this.history, this.validationRegistry), {
                DataField: DataDictionaryFieldReducer(this.history, this.validationRegistry),
            }),
            models: ModelReducer(this.history, this.validationRegistry),
        });
    }
    componentDidMount() {
        this.props.ready();
    }
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        try {
            this.doSetContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
            this.props.setNotifications(this.state.path, this.validate());
            return Promise.resolve();
        }
        catch (e) {
            console.error(e);
            return Promise.reject();
        }
    }
    doSetContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        var _a;
        let pmml;
        let _content = content;
        if (content === "") {
            _content = EMPTY_PMML;
            pmml = XML2PMML(_content);
            const supportedEditorTypes = PMMLModels.filter((m) => m.capability === SupportedCapability.EDITOR);
            if (content === "" && supportedEditorTypes.length === 1) {
                const factory = supportedEditorTypes[0].factory;
                if (factory) {
                    pmml.models = [factory()];
                }
            }
        }
        else {
            pmml = XML2PMML(_content);
        }
        this.store = createStore(this.reducer, pmml);
        (_a = this.store) === null || _a === void 0 ? void 0 : _a.dispatch({
            type: Actions.Validate,
            payload: {},
        });
        this.setState({
            path: normalizedPosixPathRelativeToTheWorkspaceRoot,
            content: _content,
            originalContent: _content,
            activeOperation: Operation.NONE,
        });
    }
    getContent() {
        return Promise.resolve(this.doGetContent());
    }
    doGetContent() {
        var _a;
        const pmml = (_a = this.store) === null || _a === void 0 ? void 0 : _a.getState();
        return pmml ? PMML2XML(pmml) : "";
    }
    async undo() {
        return Promise.resolve(this.doUndo());
    }
    doUndo() {
        var _a, _b, _c;
        const pmml = (_a = this.store) === null || _a === void 0 ? void 0 : _a.getState();
        if (pmml !== undefined) {
            (_b = this.store) === null || _b === void 0 ? void 0 : _b.dispatch({
                type: Actions.Undo,
                payload: undefined,
            });
            (_c = this.store) === null || _c === void 0 ? void 0 : _c.dispatch({
                type: Actions.Validate,
                payload: {},
            });
            this.props.setNotifications(this.state.path, this.validate());
        }
    }
    async redo() {
        return Promise.resolve(this.doRedo());
    }
    doRedo() {
        var _a, _b, _c;
        const pmml = (_a = this.store) === null || _a === void 0 ? void 0 : _a.getState();
        if (pmml !== undefined) {
            (_b = this.store) === null || _b === void 0 ? void 0 : _b.dispatch({
                type: Actions.Redo,
                payload: undefined,
            });
            (_c = this.store) === null || _c === void 0 ? void 0 : _c.dispatch({
                type: Actions.Validate,
                payload: {},
            });
            this.props.setNotifications(this.state.path, this.validate());
        }
    }
    validate() {
        return toNotifications(this.state.path, this.validationRegistry.get(Builder().build()));
    }
    isSingleModel() {
        if (!this.store) {
            return false;
        }
        const models = this.store.getState().models;
        if (models !== undefined) {
            if (models.length === 1) {
                return true;
            }
        }
        return false;
    }
    render() {
        const isSingleModel = this.isSingleModel();
        if (this.store) {
            const path = this.state.path;
            return (_jsx(HashRouter, { children: _jsx(Page, { children: _jsx(Provider, { store: this.store, children: _jsx(ValidationContext.Provider, { value: { validationRegistry: this.validationRegistry }, children: _jsx(HistoryContext.Provider, { value: {
                                    service: this.history,
                                    getCurrentState: () => { var _a; return (_a = this.store) === null || _a === void 0 ? void 0 : _a.getState(); },
                                }, children: _jsxs(Switch, { children: [_jsxs(Route, { exact: true, path: "/", children: [!isSingleModel && _jsx(LandingPage, { path: path }), isSingleModel && _jsx(Redirect, { from: "/", to: "/editor/0" })] }), _jsx(Route, { exact: true, path: "/editor/:index", children: _jsx(OperationContext.Provider, { value: {
                                                    activeOperation: this.state.activeOperation,
                                                    setActiveOperation: (operation) => this.setState({
                                                        ...this.state,
                                                        activeOperation: operation,
                                                    }),
                                                }, children: _jsx(SingleEditorRouter, { path: path }) }) })] }) }) }) }) }) }));
        }
        else {
            return _jsx(EmptyStateNoContent, {});
        }
    }
}
//# sourceMappingURL=PMMLEditor.js.map