import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { CharacteristicLabel } from "./CharacteristicLabel";
import { useValidationRegistry } from "../../../validation";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
import { Builder } from "../../../paths";
export const CharacteristicLabels = (props) => {
    const { modelIndex, characteristicIndex, activeCharacteristic, areReasonCodesUsed, scorecardBaselineScore } = props;
    const { validationRegistry } = useValidationRegistry();
    const reasonCodeValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forReasonCode()
        .build()), [modelIndex, characteristicIndex, areReasonCodesUsed, activeCharacteristic]);
    const baselineScoreValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forBaselineScore()
        .build()), [modelIndex, characteristicIndex, areReasonCodesUsed, scorecardBaselineScore, activeCharacteristic]);
    return (_jsxs(_Fragment, { children: [areReasonCodesUsed && activeCharacteristic.reasonCode !== undefined && reasonCodeValidation.length === 0 && (_jsx(CharacteristicLabel, { name: "Reason code", value: activeCharacteristic.reasonCode })), areReasonCodesUsed && reasonCodeValidation.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: reasonCodeValidation, cssClass: "characteristic-list__item__label", children: _jsxs(_Fragment, { children: [_jsx("strong", { children: "Reason code:" }), "\u00A0", _jsx("em", { children: "Missing" })] }) })), activeCharacteristic.baselineScore !== undefined && baselineScoreValidation.length === 0 && (_jsx(CharacteristicLabel, { name: "Baseline score", value: activeCharacteristic.baselineScore.toString() })), areReasonCodesUsed && activeCharacteristic.baselineScore === undefined && baselineScoreValidation.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: baselineScoreValidation, cssClass: "characteristic-list__item__label", children: _jsxs(_Fragment, { children: [_jsx("strong", { children: "Baseline score:" }), "\u00A0", _jsx("em", { children: "Missing" })] }) }))] }));
};
//# sourceMappingURL=CharacteristicLabels.js.map