import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { Toolbar, ToolbarContent, ToolbarItem } from "@patternfly/react-core/dist/js/components/Toolbar";
import { SearchIcon } from "@patternfly/react-icons/dist/js/icons/search-icon";
import "./CharacteristicsToolbar.scss";
export const CharacteristicsToolbar = (props) => {
    const { filter, setFilter, onFilter, onAddCharacteristic } = props;
    return (_jsx(Toolbar, { id: "characteristics-toolbar", "data-testid": "characteristics-toolbar", children: _jsx(ToolbarContent, { children: _jsxs(Split, { hasGutter: true, style: { width: "100%" }, children: [_jsx(SplitItem, { children: _jsx(TextContent, { children: _jsx(Title, { size: "lg", headingLevel: "h1", children: "Characteristics" }) }) }), _jsx(SplitItem, { isFilled: true, "data-ouia-component-type": "filler" }), _jsx(SplitItem, { children: _jsx(ToolbarItem, { children: _jsx(InputGroup, { children: _jsx("form", { onSubmit: (e) => e.preventDefault(), children: _jsxs("span", { style: { display: "flex" }, children: [_jsx(TextInput, { id: "characteristics-filter-input", name: "characteristics-filter-input", "data-testid": "characteristics-toolbar__characteristics-filter", type: "search", "aria-label": "filter characteristics", placeholder: "Filter by name", value: filter, onChange: (e) => setFilter(e) }), _jsx(Button, { id: "characteristics-filter", type: "submit", "data-testid": "characteristics-toolbar__submit", variant: ButtonVariant.control, "aria-label": "filter button for filter input", onClick: () => onFilter(), children: _jsx(SearchIcon, {}) })] }) }) }) }) }), _jsx(SplitItem, { children: _jsx(ToolbarItem, { children: _jsx(Button, { id: "add-characteristic-button", "data-testid": "characteristics-toolbar__add-characteristic", variant: "primary", onClick: () => onAddCharacteristic(), ouiaId: "add-characteristic", children: "Add Characteristic" }) }) })] }) }) }));
};
//# sourceMappingURL=CharacteristicsToolbar.js.map