var ownKeys = Reflect.ownKeys;
import { get, set, unset } from "lodash";
import { ValidationEntry } from "./ValidationRegistry";
export class ValidationStore {
    constructor() {
        this.registry = {};
        this.set = (path, entry) => {
            set(this.registry, path.path, entry);
        };
        this.get = (path) => {
            const node = path.path === "" ? this.registry : get(this.registry, path.path);
            if (node === undefined) {
                return [];
            }
            if (node instanceof ValidationEntry) {
                return [node];
            }
            if (node.level !== undefined) {
                return [node];
            }
            if (!(node instanceof Object)) {
                return [];
            }
            const mapped = ownKeys(node).map((key) => this.get({ path: this.childPath(path.path, String(key)) }));
            if (mapped.length === 0) {
                return [];
            }
            return mapped.reduce((pv, cv) => {
                return pv.concat(cv);
            });
        };
        this.childPath = (parentPath, key) => {
            if (parentPath === "") {
                return key;
            }
            return `${parentPath}.${key}`;
        };
        this.clear = (path) => {
            unset(this.registry, path.path);
        };
    }
}
//# sourceMappingURL=ValidationStore.js.map