import { EditorContent, EditorTheme, KogitoEditorChannelApi, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { SharedValueProvider } from "@kie-tools-core/envelope-bus/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { WorkspaceEdit, ResourceContent, ResourceContentRequest, ResourceListRequest, ResourcesList } from "@kie-tools-core/workspace/dist/api";
import { SwfLanguageServiceChannelApi } from "@kie-tools/serverless-workflow-language-service/dist/api";
import { SwfServiceCatalogChannelApi, SwfServiceCatalogService, SwfServiceRegistriesSettings } from "@kie-tools/serverless-workflow-service-catalog/dist/api";
import { CodeLens, CompletionItem, Position, Range } from "vscode-languageserver-types";
import { ServerlessWorkflowCombinedEditorChannelApi, SwfPreviewOptions, SwfPreviewOptionsChannelApi } from "../api";
import { SwfStaticEnvelopeContentProviderChannelApi } from "../api/SwfStaticEnvelopeContentProviderChannelApi";
export declare class SwfCombinedEditorChannelApiImpl implements ServerlessWorkflowCombinedEditorChannelApi {
    private readonly args;
    constructor(args: {
        defaultApiImpl: KogitoEditorChannelApi;
        swfServiceCatalogApiImpl?: SwfServiceCatalogChannelApi;
        swfLanguageServiceChannelApiImpl?: SwfLanguageServiceChannelApi;
        swfPreviewOptionsChannelApiImpl?: SwfPreviewOptionsChannelApi;
        swfStaticEnvelopeContentProviderChannelApi?: SwfStaticEnvelopeContentProviderChannelApi;
    });
    kogitoEditor_contentRequest(): Promise<EditorContent>;
    kogitoEditor_ready(): void;
    kogitoEditor_setContentError(content: EditorContent): void;
    kogitoEditor_stateControlCommandUpdate(command: StateControlCommand): void;
    kogitoI18n_getLocale(): Promise<string>;
    kogitoNotifications_createNotification(notification: Notification): void;
    kogitoNotifications_removeNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoNotifications_setNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]): void;
    kogitoWorkspace_newEdit(edit: WorkspaceEdit): void;
    kogitoWorkspace_openFile(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoWorkspace_resourceContentRequest(request: ResourceContentRequest): Promise<ResourceContent | undefined>;
    kogitoWorkspace_resourceListRequest(request: ResourceListRequest): Promise<ResourcesList>;
    kogitoEditor_theme(): SharedValueProvider<EditorTheme>;
    kogitoSwfServiceCatalog_services(): SharedValueProvider<SwfServiceCatalogService[]>;
    kogitoSwfServiceCatalog_refresh(): void;
    kogitoSwfServiceCatalog_importFunctionFromCompletionItem(args: {
        containingService: SwfServiceCatalogService;
        documentUri: string;
    }): void;
    kogitoSwfLanguageService__getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
    }): Promise<CompletionItem[]>;
    kogitoSwfLanguageService__getCodeLenses(args: {
        uri: string;
        content: string;
    }): Promise<CodeLens[]>;
    kogitoSwfServiceCatalog_serviceRegistriesSettings(): SharedValueProvider<SwfServiceRegistriesSettings>;
    kogitoSwfServiceCatalog_logInServiceRegistries(): void;
    kogitoSwfServiceCatalog_setupServiceRegistriesSettings(): void;
    kogitoSwfPreviewOptions_get(): SharedValueProvider<SwfPreviewOptions>;
    kogitoSwfGetDiagramEditorEnvelopeContent(): SharedValueProvider<string>;
    kogitoSwfGetTextEditorEnvelopeContent(): SharedValueProvider<string>;
    kogitoSwfCombinedEditor_combinedEditorReady(): void;
}
//# sourceMappingURL=SwfCombinedEditorChannelApiImpl.d.ts.map