import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { KogitoEditorIframe } from "./KogitoEditorIframe";
import { useGitHubApi } from "./GitHubContext";
const RefForwardingIsolatedEditor = (props, forwardedRef) => {
    const shouldRenderIframe = (props.keepRenderedEditorInTextMode && props.textMode) || !props.textMode;
    const githubApi = useGitHubApi();
    return (_jsx(_Fragment, { children: shouldRenderIframe && (_jsx(KogitoEditorIframe, { ref: forwardedRef, contentPath: props.contentPath, openFileExtension: props.openFileExtension, getFileContents: props.getFileContents, readonly: props.readonly, onSetContentError: props.onSetContentError }, githubApi.token)) }));
};
export const IsolatedEditor = React.forwardRef(RefForwardingIsolatedEditor);
//# sourceMappingURL=IsolatedEditor.js.map