import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as ReactDOM from "react-dom";
import { PrEditorsApp } from "./PrEditorsApp";
import { createAndGetMainContainer, openRepoInExternalEditorContainer, removeAllChildren } from "../../utils";
import { Main } from "../common/Main";
import { KOGITO_IFRAME_CONTAINER_PR_CLASS, KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS, KOGITO_TOOLBAR_CONTAINER_PR_CLASS, KOGITO_VIEW_ORIGINAL_LINK_CONTAINER_PR_CLASS, } from "../../constants";
import { OpenInExternalEditorButton } from "../openRepoInExternalEditor/OpenInExternalEditorButton";
export function renderPrEditorsApp(args) {
    cleanup(args.id);
    ReactDOM.render(_jsxs(Main, { id: args.id, editorEnvelopeLocator: args.editorEnvelopeLocator, dependencies: args.dependencies, logger: args.logger, githubAuthTokenCookieName: args.githubAuthTokenCookieName, extensionIconUrl: args.extensionIconUrl, resourceContentServiceFactory: args.resourceContentServiceFactory, externalEditorManager: args.externalEditorManager, children: [_jsx(PrEditorsApp, { prInfo: parsePrInfo(args.dependencies), pageType: args.pageType }), ReactDOM.createPortal(_jsx(OpenInExternalEditorButton, { className: args.className, pageType: args.pageType }), openRepoInExternalEditorContainer(args.id, args.container()))] }), createAndGetMainContainer(args.id, args.dependencies.all.body()), () => args.logger.log("Mounted."));
}
export function parsePrInfo(dependencies) {
    const prInfos = dependencies.all.array.pr__prInfoContainer().map((e) => e.textContent);
    const targetOrganization = window.location.pathname.split("/")[1];
    const repository = window.location.pathname.split("/")[2];
    if (prInfos.length < 6) {
        return {
            repo: repository,
            targetOrg: targetOrganization,
            targetGitRef: prInfos[1],
            org: targetOrganization,
            gitRef: prInfos[3],
        };
    }
    return {
        repo: repository,
        targetOrg: targetOrganization,
        targetGitRef: prInfos[2],
        org: prInfos[4],
        gitRef: prInfos[5],
    };
}
function cleanup(id) {
    Array.from(document.querySelectorAll(`.${KOGITO_IFRAME_CONTAINER_PR_CLASS}.${id}`)).forEach((e) => {
        removeAllChildren(e);
    });
    Array.from(document.querySelectorAll(`.${KOGITO_VIEW_ORIGINAL_LINK_CONTAINER_PR_CLASS}.${id}`)).forEach((e) => {
        removeAllChildren(e);
    });
    Array.from(document.querySelectorAll(`.${KOGITO_TOOLBAR_CONTAINER_PR_CLASS}.${id}`)).forEach((e) => {
        removeAllChildren(e);
    });
    Array.from(document.querySelectorAll(`.${KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS}.${id}`)).forEach((e) => {
        removeAllChildren(e);
        e.remove();
    });
}
//# sourceMappingURL=prEditors.js.map