import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useState, useEffect, useCallback, useRef } from "react";
import { init } from "echarts";
const OPTION_PARAM = "option";
const DATASET_PARAM = "dataSet";
const INIT_OPTIONS = {
    tooltip: {},
    xAxis: { type: "category" },
    yAxis: {},
    series: [],
};
export function ECharts(props) {
    const container = useRef(null);
    const [chart, setChart] = useState();
    useEffect(() => {
        if (container.current && !chart) {
            const _chart = init(container.current, props.theme);
            _chart.setOption(INIT_OPTIONS);
            _chart.theme = props.theme;
            setChart(_chart);
        }
    }, [chart, props]);
    window.onresize = useCallback(() => {
        if (chart)
            chart.resize();
    }, [chart]);
    useEffect(() => {
        var _a, _b;
        if (!chart) {
            return;
        }
        if (chart.theme != props.theme) {
            chart.dispose();
            setChart(undefined);
        }
        else {
            console.log(props);
            let option = props.option || {};
            if (props.params) {
                props.params.delete(DATASET_PARAM);
                option = fillProperties(props.params, option);
            }
            const nColumns = ((_b = (_a = option.dataset) === null || _a === void 0 ? void 0 : _a.source[0]) === null || _b === void 0 ? void 0 : _b.length) || 0;
            if (option.series && !option.series.length && nColumns > 1) {
                const series = Array(nColumns - 1).fill(option.series);
                option.series = series;
            }
            chart.setOption(option);
        }
    }, [props, chart]);
    return (_jsx(_Fragment, { children: _jsx("div", { style: { width: "100%", height: "100%" }, ref: container }) }));
}
export const fillProperties = (props, option) => {
    if (!option) {
        option = {};
    }
    const optionStr = props.get(OPTION_PARAM);
    if (optionStr) {
        try {
            const parsedOption = JSON.parse(optionStr);
            option = { ...option, ...parsedOption };
        }
        catch (e) {
            console.log("Not able to parse option property");
        }
        props.delete(OPTION_PARAM);
    }
    props.forEach((value, key) => setPropertyOnObject(key, value, option));
    return option;
};
const setPropertyOnObject = (prop, value, obj) => {
    if (!prop || !value) {
        return obj;
    }
    const props = prop.split(".");
    let parent = obj;
    for (let i = 0; i < props.length; i++) {
        const name = props[i];
        if (i === props.length - 1) {
            parent[name] = value;
        }
        else {
            parent[name] = parent[name] || {};
            parent = parent[name];
        }
    }
    return obj;
};
//# sourceMappingURL=ECharts.js.map