import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { basename } from "path";
import { Checkbox } from "@patternfly/react-core/dist/esm/components/Checkbox";
import { HelpIcon } from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { Icon } from "@patternfly/react-core/dist/esm/components/Icon/Icon";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip";
import { useCancelableEffect } from "@kie-tools-core/react-hooks/dist/useCancelableEffect";
import { useTestScenarioEditorI18n } from "../i18n";
import { useTestScenarioEditorStore, useTestScenarioEditorStoreApi } from "../store/TestScenarioStoreContext";
import { useExternalModels } from "../externalModels/TestScenarioEditorDependenciesContext";
import { useTestScenarioEditor } from "../TestScenarioEditorContext";
import "./TestScenarioDrawerSettingsPanel.css";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
function TestScenarioDrawerSettingsPanel() {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
    const { i18n } = useTestScenarioEditorI18n();
    const { openFileNormalizedPosixPathRelativeToTheWorkspaceRoot } = useTestScenarioEditor();
    const { onRequestExternalModelsAvailableToInclude, onRequestExternalModelByPath } = useExternalModels();
    const [allDmnModelNormalizedPosixRelativePaths, setAllDmnModelNormalizedPosixRelativePaths] = useState(undefined);
    const [dmnNotFoundError, setDmnNotFoundError] = useState(undefined);
    const settingsModel = useTestScenarioEditorStore((state) => state.scesim.model.ScenarioSimulationModel.settings);
    const [selectedDmnPathRelativeToThisScesim, setSelectedDmnPathRelativeToThisScesim] = useState((_a = settingsModel.dmnFilePath) === null || _a === void 0 ? void 0 : _a.__$$text);
    const testScenarioEditorStoreApi = useTestScenarioEditorStoreApi();
    const testScenarioType = (_b = settingsModel.type) === null || _b === void 0 ? void 0 : _b.__$$text.toUpperCase();
    const [selectedDmnModel, setSelectedDmnModel] = useState(undefined);
    useCancelableEffect(useCallback(({ canceled }) => {
        onRequestExternalModelsAvailableToInclude === null || onRequestExternalModelsAvailableToInclude === void 0 ? void 0 : onRequestExternalModelsAvailableToInclude().then((paths) => {
            if (canceled.get()) {
                setAllDmnModelNormalizedPosixRelativePaths(undefined);
                return;
            }
            setAllDmnModelNormalizedPosixRelativePaths(paths.sort((modelA, modelB) => basename(modelA).localeCompare(basename(modelB))));
        }).catch((err) => {
            console.error(err);
        });
    }, [onRequestExternalModelsAvailableToInclude]));
    useCancelableEffect(useCallback(({ canceled }) => {
        if (!selectedDmnPathRelativeToThisScesim || onRequestExternalModelByPath === undefined) {
            return;
        }
        onRequestExternalModelByPath(selectedDmnPathRelativeToThisScesim)
            .then((externalDmnModel) => {
            console.debug("[TestScenarioDrawerSettingsPanel] The below external DMN model have been loaded ", externalDmnModel);
            if (canceled.get() || !externalDmnModel) {
                setSelectedDmnModel(undefined);
                setDmnNotFoundError(new Error(`The related DMN file ${selectedDmnPathRelativeToThisScesim} can't be loaded`));
                return;
            }
            setSelectedDmnModel(externalDmnModel);
            testScenarioEditorStoreApi.setState((state) => {
                state.scesim.model.ScenarioSimulationModel.settings.dmnFilePath.__$$text =
                    selectedDmnPathRelativeToThisScesim;
                state.scesim.model.ScenarioSimulationModel.settings.dmnName.__$$text =
                    externalDmnModel.model.definitions["@_name"];
                state.scesim.model.ScenarioSimulationModel.settings.dmnNamespace.__$$text =
                    externalDmnModel.model.definitions["@_namespace"];
            });
            setDmnNotFoundError(undefined);
        })
            .catch((err) => {
            setSelectedDmnModel(undefined);
            setDmnNotFoundError(err);
            console.error(`[TestScenarioDrawerSettingsPanel] An error occurred when parsing the selected model '${selectedDmnPathRelativeToThisScesim}'. Please double-check it is a non-empty valid model.`);
            console.error(err);
        });
    }, [onRequestExternalModelByPath, selectedDmnPathRelativeToThisScesim, testScenarioEditorStoreApi]));
    const isSelectedDmnValid = useMemo(() => {
        var _a;
        return !dmnNotFoundError &&
            (!selectedDmnModel ||
                selectedDmnModel.normalizedPosixPathRelativeToTheOpenFile === ((_a = settingsModel.dmnFilePath) === null || _a === void 0 ? void 0 : _a.__$$text));
    }, [dmnNotFoundError, selectedDmnModel, (_c = settingsModel.dmnFilePath) === null || _c === void 0 ? void 0 : _c.__$$text]);
    const updateSettingsField = useCallback((fieldName, value) => testScenarioEditorStoreApi.setState((state) => {
        state.scesim.model.ScenarioSimulationModel.settings[fieldName] = {
            __$$text: value,
        };
    }), [testScenarioEditorStoreApi]);
    const [isModelSelectOpen, setModelSelectOpen] = useState(false);
    return (_jsxs(_Fragment, { children: [_jsx(Title, { className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6", children: i18n.drawer.settings.fileName }), _jsx(TextInput, { "aria-label": "filename", className: "kie-scesim-editor-drawer-settings--text-input", isDisabled: true, type: "text", value: basename(openFileNormalizedPosixPathRelativeToTheWorkspaceRoot !== null && openFileNormalizedPosixPathRelativeToTheWorkspaceRoot !== void 0 ? openFileNormalizedPosixPathRelativeToTheWorkspaceRoot : "") }), _jsx(Title, { className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6", children: i18n.drawer.settings.assetType }), _jsx(TextInput, { "aria-label": "asset-type", className: "kie-scesim-editor-drawer-settings--text-input", isDisabled: true, type: "text", value: testScenarioType }), testScenarioType === "DMN" ? (_jsxs(_Fragment, { children: [_jsx(Title, { className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6", children: i18n.drawer.settings.dmnModel }), _jsx(Select, { variant: SelectVariant.single, "aria-label": "form-select-input", className: "kie-scesim-editor-drawer-settings--form-select", ouiaId: "BasicFormSelect", onToggle: setModelSelectOpen, isOpen: isModelSelectOpen, maxHeight: "350px", onSelect: (e, path) => {
                            if (typeof path !== "string") {
                                throw new Error(`Invalid path for an included model ${JSON.stringify(path)}`);
                            }
                            setSelectedDmnPathRelativeToThisScesim(path);
                            console.debug("[TestScenarioDrawerSettingsPanel] Selected path: ", path);
                            setModelSelectOpen(false);
                        }, validated: isSelectedDmnValid ? undefined : "error", selections: isSelectedDmnValid ? (_d = settingsModel.dmnFilePath) === null || _d === void 0 ? void 0 : _d.__$$text : undefined, children: !selectedDmnModel
                            ? [
                                _jsx(SelectOption, { isDisabled: true, children: i18n.drawer.settings.dmnModelReferenceError }, undefined),
                            ]
                            : (((_e = allDmnModelNormalizedPosixRelativePaths === null || allDmnModelNormalizedPosixRelativePaths === void 0 ? void 0 : allDmnModelNormalizedPosixRelativePaths.length) !== null && _e !== void 0 ? _e : 0) > 0 &&
                                (allDmnModelNormalizedPosixRelativePaths === null || allDmnModelNormalizedPosixRelativePaths === void 0 ? void 0 : allDmnModelNormalizedPosixRelativePaths.map((normalizedPosixPathRelativeToTheOpenFile) => (_jsx(SelectOption, { value: normalizedPosixPathRelativeToTheOpenFile, description: normalizedPosixPathRelativeToTheOpenFile, children: basename(normalizedPosixPathRelativeToTheOpenFile) }, normalizedPosixPathRelativeToTheOpenFile))))) || [
                                _jsx(SelectOption, { isDisabled: true, description: "", value: undefined, children: i18n.creationPanel.dmnNoPresent }, "none-dmn"),
                            ] }), _jsx(Title, { className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6", children: i18n.drawer.settings.dmnName }), _jsx(TextInput, { "aria-label": "dmn-name", className: "kie-scesim-editor-drawer-settings--text-input", isDisabled: true, type: "text", value: (_f = settingsModel.dmnName) === null || _f === void 0 ? void 0 : _f.__$$text }), _jsx(Title, { className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6", children: i18n.drawer.settings.dmnNameSpace }), _jsx(TextInput, { "aria-label": "dmn-namespace", className: "kie-scesim-editor-drawer-settings--text-input", isDisabled: true, type: "text", value: (_g = settingsModel.dmnNamespace) === null || _g === void 0 ? void 0 : _g.__$$text })] })) : (_jsxs(_Fragment, { children: [_jsxs(Title, { className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6", children: [i18n.drawer.settings.kieSessionRule, _jsx(Tooltip, { content: i18n.drawer.settings.kieSessionRuleTooltip, children: _jsx(Icon, { className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }), _jsx(TextInput, { "aria-label": "rule-session", className: "kie-scesim-editor-drawer-settings--text-input", onChange: (value) => updateSettingsField("dmoSession", value), placeholder: i18n.drawer.settings.kieSessionRulePlaceholder, type: "text", value: (_h = settingsModel.dmoSession) === null || _h === void 0 ? void 0 : _h.__$$text }), _jsxs(Title, { className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6", children: [i18n.drawer.settings.ruleFlowGroup, _jsx(Tooltip, { content: i18n.drawer.settings.ruleFlowGroupTooltip, children: _jsx(Icon, { className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }), _jsx(TextInput, { "aria-label": "rule-flow-group", className: "kie-scesim-editor-drawer-settings--text-input", onChange: (value) => updateSettingsField("ruleFlowGroup", value), placeholder: i18n.drawer.settings.ruleFlowGroupPlaceholder, type: "text", value: (_j = settingsModel.ruleFlowGroup) === null || _j === void 0 ? void 0 : _j.__$$text }), _jsxs("div", { className: "kie-scesim-editor-drawer-settings--checkbox-group", children: [_jsx("div", { className: "kie-scesim-editor-drawer-settings--checkbox", children: _jsx(Checkbox, { id: "stateless-session", isChecked: (_l = (_k = settingsModel.stateless) === null || _k === void 0 ? void 0 : _k.__$$text) !== null && _l !== void 0 ? _l : false, label: i18n.drawer.settings.statelessSessionRule, onChange: (value) => updateSettingsField("stateless", value) }) }), _jsx(Tooltip, { content: i18n.drawer.settings.statelessSessionRuleTooltip, children: _jsx(Icon, { className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] })] })), _jsxs("div", { className: "kie-scesim-editor-drawer-settings--checkbox-group", children: [_jsx("div", { className: "kie-scesim-editor-drawer-settings--checkbox", children: _jsx(Checkbox, { id: "skip-test", isChecked: (_o = (_m = settingsModel.skipFromBuild) === null || _m === void 0 ? void 0 : _m.__$$text) !== null && _o !== void 0 ? _o : false, label: i18n.drawer.settings.testSkipped, onChange: (value) => updateSettingsField("skipFromBuild", value) }) }), _jsx(Tooltip, { content: i18n.drawer.settings.testSkippedTooltip, children: _jsx(Icon, { className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] })] }));
}
export default TestScenarioDrawerSettingsPanel;
//# sourceMappingURL=TestScenarioDrawerSettingsPanel.js.map