import { pushFactMappings } from "./pushFactMappings";
const EMPTY_GIVEN_FACTMAPPING = {
    className: "java.lang.Void",
    columnWidth: 300,
    expressionAlias: "PROPERTY-1",
    expressionElements: [],
    expressionIdentifierType: "GIVEN",
    factAlias: "INSTANCE-1",
    factIdentifierName: "INSTANCE-1",
    factIdentifierClassName: "java.lang.Void",
    genericTypes: undefined,
};
const EMPTY_EXPECT_FACTMAPPING = {
    className: "java.lang.Void",
    columnWidth: 300,
    expressionAlias: "PROPERTY-2",
    expressionElements: [],
    expressionIdentifierType: "EXPECT",
    factAlias: "INSTANCE-2",
    factIdentifierName: "INSTANCE-2",
    factIdentifierClassName: "java.lang.Void",
    genericTypes: undefined,
};
export function createNewDmnTypeTestScenario({ dmnModel, factMappingsModel, factMappingValuesModel, isAutoFillTableEnabled, isTestSkipped, settingsModel, }) {
    var _a;
    settingsModel.dmnFilePath = { __$$text: dmnModel.normalizedPosixPathRelativeToTheOpenFile };
    settingsModel.dmnName = { __$$text: dmnModel.model.definitions["@_name"] };
    settingsModel.dmnNamespace = { __$$text: dmnModel.model.definitions["@_namespace"] };
    settingsModel.skipFromBuild = { __$$text: isTestSkipped };
    settingsModel.type = { __$$text: "DMN" };
    let givenFactMappingsToPush = [];
    let expectFactMappingsToPush = [];
    if (isAutoFillTableEnabled && dmnModel.model.definitions.drgElement) {
        const itemDefinitions = new Map((_a = dmnModel.model.definitions.itemDefinition) === null || _a === void 0 ? void 0 : _a.map((itemDefinition) => [itemDefinition["@_name"], itemDefinition]));
        const inputDataElements = dmnModel.model.definitions.drgElement.filter((drgElement) => drgElement.__$$element === "inputData");
        const decisionElements = dmnModel.model.definitions.drgElement.filter((drgElement) => drgElement.__$$element === "decision");
        givenFactMappingsToPush = generateFactMappingsAndFactMappingValuesFromDmnModel(inputDataElements, "GIVEN", itemDefinitions);
        expectFactMappingsToPush = generateFactMappingsAndFactMappingValuesFromDmnModel(decisionElements, "EXPECT", itemDefinitions);
    }
    if (givenFactMappingsToPush.length === 0) {
        givenFactMappingsToPush.push(EMPTY_GIVEN_FACTMAPPING);
    }
    if (expectFactMappingsToPush.length === 0) {
        expectFactMappingsToPush.push(EMPTY_EXPECT_FACTMAPPING);
    }
    pushFactMappings({
        factMappingsModel,
        factMappingValuesModel,
        factMappingsToPush: [...givenFactMappingsToPush, ...expectFactMappingsToPush],
    });
}
function generateFactMappingsAndFactMappingValuesFromDmnModel(drgElements, expressionIdentifierType, allItemDefinitionsMap) {
    const factMappingsToPush = [];
    drgElements.forEach((drgElement) => {
        const itemDefinition = allItemDefinitionsMap.get(drgElement.variable["@_typeRef"]);
        if (!(itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.itemComponent) || (itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.itemComponent.length) === 0) {
            factMappingsToPush.push({
                className: (itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition["@_isCollection"]) ? "java.util.List" : drgElement.variable["@_typeRef"],
                columnWidth: 100,
                expressionAlias: "value",
                expressionElements: [drgElement.variable["@_name"]],
                expressionIdentifierType: expressionIdentifierType,
                factAlias: drgElement.variable["@_name"],
                factIdentifierName: drgElement.variable["@_name"],
                factIdentifierClassName: drgElement.variable["@_typeRef"],
                genericTypes: (itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition["@_isCollection"]) ? [drgElement.variable["@_typeRef"]] : undefined,
            });
        }
        else {
            itemDefinition === null || itemDefinition === void 0 ? void 0 : itemDefinition.itemComponent.forEach((itemComponent) => {
                factMappingsToPush.push(...recursevlyNavigateItemComponent(allItemDefinitionsMap, 100, [drgElement.variable["@_name"]], expressionIdentifierType, itemComponent, drgElement.variable["@_name"], drgElement.variable["@_typeRef"]));
            });
        }
    });
    return factMappingsToPush.sort((a, b) => a.expressionElements.join().localeCompare(b.expressionElements.join()));
}
function recursevlyNavigateItemComponent(allItemDefinitionsMap, columnWidth, expressionElements, expressionIdentifierType, itemComponent, name, typeRef) {
    var _a, _b, _c, _d, _e;
    const factMappingsToReturn = [];
    const currentItemDefinition = allItemDefinitionsMap.has((_b = (_a = itemComponent === null || itemComponent === void 0 ? void 0 : itemComponent.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : "")
        ? allItemDefinitionsMap.get((_d = (_c = itemComponent === null || itemComponent === void 0 ? void 0 : itemComponent.typeRef) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "")
        : itemComponent;
    const isCollection = (_e = itemComponent === null || itemComponent === void 0 ? void 0 : itemComponent["@_isCollection"]) !== null && _e !== void 0 ? _e : false;
    if (!(currentItemDefinition === null || currentItemDefinition === void 0 ? void 0 : currentItemDefinition.typeRef) && (currentItemDefinition === null || currentItemDefinition === void 0 ? void 0 : currentItemDefinition.itemComponent) && !isCollection) {
        currentItemDefinition.itemComponent.forEach((nestedItemComponent) => {
            factMappingsToReturn.push(...recursevlyNavigateItemComponent(allItemDefinitionsMap, columnWidth, [...expressionElements, itemComponent["@_name"]], expressionIdentifierType, nestedItemComponent, name, typeRef));
        });
    }
    else {
        factMappingsToReturn.push({
            className: (itemComponent === null || itemComponent === void 0 ? void 0 : itemComponent["@_isCollection"]) ? "java.util.List" : itemComponent.typeRef.__$$text,
            columnWidth: columnWidth,
            expressionAlias: [...expressionElements.slice(1), itemComponent["@_name"]].join("."),
            expressionElements: [...expressionElements, itemComponent["@_name"]],
            expressionIdentifierType: expressionIdentifierType,
            factAlias: name,
            factIdentifierName: name,
            factIdentifierClassName: typeRef,
            genericTypes: (itemComponent === null || itemComponent === void 0 ? void 0 : itemComponent["@_isCollection"]) ? [itemComponent.typeRef.__$$text] : undefined,
        });
    }
    return factMappingsToReturn;
}
//# sourceMappingURL=createNewDmnTypeTestScenario.js.map