import { enableMapSet } from "immer";
import { create } from "zustand";
import { immer } from "zustand/middleware/immer";
import { computeDmnDataObjects } from "./computed/computeDmnDataObjects";
import { computeTestScenarioDataObjects } from "./computed/computeTestScenarioDataObjects";
import { computeDataObjects } from "./computed/computeDataObjects";
enableMapSet();
export var TestScenarioEditorDock;
(function (TestScenarioEditorDock) {
    TestScenarioEditorDock[TestScenarioEditorDock["CHEATSHEET"] = 0] = "CHEATSHEET";
    TestScenarioEditorDock[TestScenarioEditorDock["DATA_OBJECT"] = 1] = "DATA_OBJECT";
    TestScenarioEditorDock[TestScenarioEditorDock["SETTINGS"] = 2] = "SETTINGS";
})(TestScenarioEditorDock || (TestScenarioEditorDock = {}));
export var TestScenarioEditorTab;
(function (TestScenarioEditorTab) {
    TestScenarioEditorTab[TestScenarioEditorTab["BACKGROUND"] = 0] = "BACKGROUND";
    TestScenarioEditorTab[TestScenarioEditorTab["SIMULATION"] = 1] = "SIMULATION";
})(TestScenarioEditorTab || (TestScenarioEditorTab = {}));
export const defaultStaticState = () => ({
    navigation: {
        dock: {
            isOpen: true,
            selected: TestScenarioEditorDock.DATA_OBJECT,
        },
        tab: TestScenarioEditorTab.SIMULATION,
    },
    table: {
        background: {
            selectedColumn: null,
        },
        simulation: {
            selectedColumn: null,
        },
    },
});
export function createTestScenarioEditorStore(model, computedCache) {
    console.debug("[TestScenarioEditorStore] Creating store with above model and empty cache ", model);
    const { ...defaultState } = defaultStaticState();
    return create(immer(() => ({
        ...defaultState,
        scesim: {
            model: model,
        },
        dispatch(state) {
            return {
                navigation: {
                    reset: () => {
                        state.navigation.tab = TestScenarioEditorTab.SIMULATION;
                        state.navigation.dock.isOpen = true;
                        state.navigation.dock.selected = TestScenarioEditorDock.DATA_OBJECT;
                        state.table.background.selectedColumn = null;
                        state.table.simulation.selectedColumn = null;
                    },
                },
                table: {
                    updateSelectedColumn: (columnMetadata) => {
                        if (state.navigation.tab === TestScenarioEditorTab.BACKGROUND) {
                            state.table.background.selectedColumn = columnMetadata;
                        }
                        else {
                            state.table.simulation.selectedColumn = columnMetadata;
                        }
                    },
                },
            };
        },
        computed(state) {
            return {
                getDataObjects: (externalModelsByNamespace) => computedCache.cached("getDataObjects", computeDataObjects, [
                    state.computed(state).getTestScenarioDataObjects(),
                    state.computed(state).getDmnDataObjects(externalModelsByNamespace),
                    state.scesim.model.ScenarioSimulationModel.settings.type,
                ]),
                getDmnDataObjects: (externalModelsByNamespace) => computedCache.cached("getDmnDataObjects", computeDmnDataObjects, [
                    externalModelsByNamespace,
                    state.scesim.model.ScenarioSimulationModel.settings,
                ]),
                getTestScenarioDataObjects: () => computedCache.cachedData("getTestScenarioDataObjects", computeTestScenarioDataObjects, [state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping], [state.scesim.model.ScenarioSimulationModel.settings.type]),
            };
        },
    })));
}
//# sourceMappingURL=TestScenarioEditorStore.js.map