export function messageBusClientApiMock() {
    const mocks = new Map();
    const proxyMock = (value) => new Proxy({}, {
        get: (target, name) => {
            var _a;
            return (_a = mocks.get(name)) !== null && _a !== void 0 ? _a : mocks.set(name, value).get(name);
        },
    });
    return {
        notifications: proxyMock({
            send: jest.fn(),
            subscribe: jest.fn(),
            unsubscribe: jest.fn(),
        }),
        requests: proxyMock(jest.fn()),
        shared: proxyMock({
            set: jest.fn(),
            subscribe: jest.fn(),
            unsubscribe: jest.fn(),
        }),
    };
}
//# sourceMappingURL=messageBusClientApiMock.js.map