import * as ApolloReactCommon from "@apollo/react-common";
import * as ApolloReactHooks from "@apollo/react-hooks";
export declare namespace GraphQL {
    type Maybe<T> = T | null;
    type InputMaybe<T> = Maybe<T>;
    type Exact<T extends {
        [key: string]: unknown;
    }> = {
        [K in keyof T]: T[K];
    };
    type MakeOptional<T, K extends keyof T> = Omit<T, K> & {
        [SubKey in K]?: Maybe<T[SubKey]>;
    };
    type MakeMaybe<T, K extends keyof T> = Omit<T, K> & {
        [SubKey in K]: Maybe<T[SubKey]>;
    };
    type Scalars = {
        ID: string;
        String: string;
        Boolean: boolean;
        Int: number;
        Float: number;
        DateTime: any;
        JSON: any;
        BigDecimal: any;
        Long: any;
    };
    type Query = {
        __typename?: "Query";
        Jobs?: Maybe<Array<Maybe<Job>>>;
        ProcessDefinitions?: Maybe<Array<Maybe<ProcessDefinition>>>;
        ProcessInstances?: Maybe<Array<Maybe<ProcessInstance>>>;
        UserTaskInstances?: Maybe<Array<Maybe<UserTaskInstance>>>;
    };
    type QueryJobsArgs = {
        orderBy?: InputMaybe<JobOrderBy>;
        pagination?: InputMaybe<Pagination>;
        where?: InputMaybe<JobArgument>;
    };
    type QueryProcessDefinitionsArgs = {
        orderBy?: InputMaybe<ProcessDefinitionOrderBy>;
        pagination?: InputMaybe<Pagination>;
        where?: InputMaybe<ProcessDefinitionArgument>;
    };
    type QueryProcessInstancesArgs = {
        orderBy?: InputMaybe<ProcessInstanceOrderBy>;
        pagination?: InputMaybe<Pagination>;
        where?: InputMaybe<ProcessInstanceArgument>;
    };
    type QueryUserTaskInstancesArgs = {
        orderBy?: InputMaybe<UserTaskInstanceOrderBy>;
        pagination?: InputMaybe<Pagination>;
        where?: InputMaybe<UserTaskInstanceArgument>;
    };
    type JobOrderBy = {
        executionCounter?: InputMaybe<OrderBy>;
        expirationTime?: InputMaybe<OrderBy>;
        lastUpdate?: InputMaybe<OrderBy>;
        priority?: InputMaybe<OrderBy>;
        processId?: InputMaybe<OrderBy>;
        retries?: InputMaybe<OrderBy>;
        rootProcessId?: InputMaybe<OrderBy>;
        status?: InputMaybe<OrderBy>;
    };
    enum OrderBy {
        Asc = "ASC",
        Desc = "DESC"
    }
    type Pagination = {
        limit?: InputMaybe<Scalars["Int"]>;
        offset?: InputMaybe<Scalars["Int"]>;
    };
    type JobArgument = {
        and?: InputMaybe<Array<JobArgument>>;
        expirationTime?: InputMaybe<DateArgument>;
        id?: InputMaybe<IdArgument>;
        lastUpdate?: InputMaybe<DateArgument>;
        nodeInstanceId?: InputMaybe<IdArgument>;
        not?: InputMaybe<JobArgument>;
        or?: InputMaybe<Array<JobArgument>>;
        priority?: InputMaybe<NumericArgument>;
        processId?: InputMaybe<StringArgument>;
        processInstanceId?: InputMaybe<IdArgument>;
        rootProcessId?: InputMaybe<StringArgument>;
        rootProcessInstanceId?: InputMaybe<IdArgument>;
        scheduledId?: InputMaybe<IdArgument>;
        status?: InputMaybe<JobStatusArgument>;
    };
    type DateArgument = {
        between?: InputMaybe<DateRange>;
        equal?: InputMaybe<Scalars["DateTime"]>;
        greaterThan?: InputMaybe<Scalars["DateTime"]>;
        greaterThanEqual?: InputMaybe<Scalars["DateTime"]>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
        lessThan?: InputMaybe<Scalars["DateTime"]>;
        lessThanEqual?: InputMaybe<Scalars["DateTime"]>;
    };
    type DateRange = {
        from: Scalars["DateTime"];
        to: Scalars["DateTime"];
    };
    type IdArgument = {
        equal?: InputMaybe<Scalars["String"]>;
        in?: InputMaybe<Array<Scalars["String"]>>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
    };
    type NumericArgument = {
        between?: InputMaybe<NumericRange>;
        equal?: InputMaybe<Scalars["Int"]>;
        greaterThan?: InputMaybe<Scalars["Int"]>;
        greaterThanEqual?: InputMaybe<Scalars["Int"]>;
        in?: InputMaybe<Array<Scalars["Int"]>>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
        lessThan?: InputMaybe<Scalars["Int"]>;
        lessThanEqual?: InputMaybe<Scalars["Int"]>;
    };
    type NumericRange = {
        from: Scalars["Int"];
        to: Scalars["Int"];
    };
    type StringArgument = {
        equal?: InputMaybe<Scalars["String"]>;
        in?: InputMaybe<Array<Scalars["String"]>>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
        like?: InputMaybe<Scalars["String"]>;
    };
    type JobStatusArgument = {
        equal?: InputMaybe<JobStatus>;
        in?: InputMaybe<Array<InputMaybe<JobStatus>>>;
    };
    enum JobStatus {
        Canceled = "CANCELED",
        Error = "ERROR",
        Executed = "EXECUTED",
        Retry = "RETRY",
        Scheduled = "SCHEDULED"
    }
    type Job = {
        __typename?: "Job";
        callbackEndpoint?: Maybe<Scalars["String"]>;
        endpoint?: Maybe<Scalars["String"]>;
        executionCounter?: Maybe<Scalars["Int"]>;
        expirationTime?: Maybe<Scalars["DateTime"]>;
        id: Scalars["String"];
        lastUpdate?: Maybe<Scalars["DateTime"]>;
        nodeInstanceId?: Maybe<Scalars["String"]>;
        priority?: Maybe<Scalars["Int"]>;
        processId?: Maybe<Scalars["String"]>;
        processInstanceId?: Maybe<Scalars["String"]>;
        repeatInterval?: Maybe<Scalars["Int"]>;
        repeatLimit?: Maybe<Scalars["Int"]>;
        retries?: Maybe<Scalars["Int"]>;
        rootProcessId?: Maybe<Scalars["String"]>;
        rootProcessInstanceId?: Maybe<Scalars["String"]>;
        scheduledId?: Maybe<Scalars["String"]>;
        status: JobStatus;
    };
    type ProcessDefinitionOrderBy = {
        id?: InputMaybe<OrderBy>;
        name?: InputMaybe<OrderBy>;
        version?: InputMaybe<OrderBy>;
    };
    type ProcessDefinitionArgument = {
        and?: InputMaybe<Array<ProcessDefinitionArgument>>;
        id?: InputMaybe<StringArgument>;
        name?: InputMaybe<StringArgument>;
        not?: InputMaybe<ProcessDefinitionArgument>;
        or?: InputMaybe<Array<ProcessDefinitionArgument>>;
        version?: InputMaybe<StringArgument>;
    };
    type ProcessDefinition = {
        __typename?: "ProcessDefinition";
        addons?: Maybe<Array<Scalars["String"]>>;
        annotations?: Maybe<Array<Maybe<Scalars["String"]>>>;
        description?: Maybe<Scalars["String"]>;
        endpoint?: Maybe<Scalars["String"]>;
        id: Scalars["String"];
        metadata?: Maybe<Scalars["JSON"]>;
        name?: Maybe<Scalars["String"]>;
        nodes?: Maybe<Array<Node>>;
        roles?: Maybe<Array<Scalars["String"]>>;
        serviceUrl?: Maybe<Scalars["String"]>;
        source?: Maybe<Scalars["String"]>;
        type?: Maybe<Scalars["String"]>;
        version?: Maybe<Scalars["String"]>;
    };
    type Node = {
        __typename?: "Node";
        id: Scalars["String"];
        metadata: NodeMetadata;
        name: Scalars["String"];
        type: Scalars["String"];
        uniqueId: Scalars["String"];
    };
    type NodeMetadata = {
        __typename?: "NodeMetadata";
        action?: Maybe<Scalars["String"]>;
        branch?: Maybe<Scalars["String"]>;
        state?: Maybe<Scalars["String"]>;
        UniqueId: Scalars["String"];
    };
    type ProcessInstanceOrderBy = {
        businessKey?: InputMaybe<OrderBy>;
        createdBy?: InputMaybe<OrderBy>;
        end?: InputMaybe<OrderBy>;
        error?: InputMaybe<ProcessInstanceErrorOrderBy>;
        lastUpdate?: InputMaybe<OrderBy>;
        processId?: InputMaybe<OrderBy>;
        processName?: InputMaybe<OrderBy>;
        rootProcessId?: InputMaybe<OrderBy>;
        start?: InputMaybe<OrderBy>;
        state?: InputMaybe<OrderBy>;
        updatedBy?: InputMaybe<OrderBy>;
    };
    type ProcessInstanceErrorOrderBy = {
        message?: InputMaybe<OrderBy>;
        nodeDefinitionId?: InputMaybe<OrderBy>;
    };
    type ProcessInstanceArgument = {
        addons?: InputMaybe<StringArrayArgument>;
        and?: InputMaybe<Array<ProcessInstanceArgument>>;
        businessKey?: InputMaybe<StringArgument>;
        createdBy?: InputMaybe<StringArgument>;
        end?: InputMaybe<DateArgument>;
        endpoint?: InputMaybe<StringArgument>;
        error?: InputMaybe<ProcessInstanceErrorArgument>;
        id?: InputMaybe<IdArgument>;
        lastUpdate?: InputMaybe<DateArgument>;
        milestones?: InputMaybe<MilestoneArgument>;
        nodes?: InputMaybe<NodeInstanceArgument>;
        not?: InputMaybe<ProcessInstanceArgument>;
        or?: InputMaybe<Array<ProcessInstanceArgument>>;
        parentProcessInstanceId?: InputMaybe<IdArgument>;
        processId?: InputMaybe<StringArgument>;
        processName?: InputMaybe<StringArgument>;
        roles?: InputMaybe<StringArrayArgument>;
        rootProcessId?: InputMaybe<StringArgument>;
        rootProcessInstanceId?: InputMaybe<IdArgument>;
        start?: InputMaybe<DateArgument>;
        state?: InputMaybe<ProcessInstanceStateArgument>;
        updatedBy?: InputMaybe<StringArgument>;
        variables?: InputMaybe<Scalars["JSON"]>;
    };
    type StringArrayArgument = {
        contains?: InputMaybe<Scalars["String"]>;
        containsAll?: InputMaybe<Array<Scalars["String"]>>;
        containsAny?: InputMaybe<Array<Scalars["String"]>>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
    };
    type ProcessInstanceErrorArgument = {
        message?: InputMaybe<StringArgument>;
        nodeDefinitionId?: InputMaybe<StringArgument>;
    };
    type MilestoneArgument = {
        id?: InputMaybe<IdArgument>;
        name?: InputMaybe<StringArgument>;
        status?: InputMaybe<MilestoneStatusArgument>;
    };
    type MilestoneStatusArgument = {
        equal?: InputMaybe<MilestoneStatus>;
        in?: InputMaybe<Array<InputMaybe<MilestoneStatus>>>;
    };
    enum MilestoneStatus {
        Active = "ACTIVE",
        Available = "AVAILABLE",
        Completed = "COMPLETED"
    }
    type NodeInstanceArgument = {
        definitionId?: InputMaybe<StringArgument>;
        enter?: InputMaybe<DateArgument>;
        exit?: InputMaybe<DateArgument>;
        id?: InputMaybe<IdArgument>;
        name?: InputMaybe<StringArgument>;
        nodeId?: InputMaybe<StringArgument>;
        type?: InputMaybe<StringArgument>;
    };
    type ProcessInstanceStateArgument = {
        equal?: InputMaybe<ProcessInstanceState>;
        in?: InputMaybe<Array<InputMaybe<ProcessInstanceState>>>;
    };
    enum ProcessInstanceState {
        Aborted = "ABORTED",
        Active = "ACTIVE",
        Completed = "COMPLETED",
        Error = "ERROR",
        Pending = "PENDING",
        Suspended = "SUSPENDED"
    }
    type ProcessInstance = {
        __typename?: "ProcessInstance";
        addons?: Maybe<Array<Scalars["String"]>>;
        businessKey?: Maybe<Scalars["String"]>;
        childProcessInstances?: Maybe<Array<ProcessInstance>>;
        createdBy?: Maybe<Scalars["String"]>;
        definition?: Maybe<ProcessDefinition>;
        diagram?: Maybe<Scalars["String"]>;
        end?: Maybe<Scalars["DateTime"]>;
        endpoint: Scalars["String"];
        error?: Maybe<ProcessInstanceError>;
        id: Scalars["String"];
        identity?: Maybe<Scalars["String"]>;
        lastUpdate: Scalars["DateTime"];
        milestones?: Maybe<Array<Milestone>>;
        nodeDefinitions?: Maybe<Array<Node>>;
        nodes?: Maybe<Array<NodeInstance>>;
        parentProcessInstance?: Maybe<ProcessInstance>;
        parentProcessInstanceId?: Maybe<Scalars["String"]>;
        processId: Scalars["String"];
        processName?: Maybe<Scalars["String"]>;
        roles?: Maybe<Array<Scalars["String"]>>;
        rootProcessId?: Maybe<Scalars["String"]>;
        rootProcessInstanceId?: Maybe<Scalars["String"]>;
        serviceUrl?: Maybe<Scalars["String"]>;
        slaDueDate?: Maybe<Scalars["DateTime"]>;
        source?: Maybe<Scalars["String"]>;
        start?: Maybe<Scalars["DateTime"]>;
        state?: Maybe<ProcessInstanceState>;
        updatedBy?: Maybe<Scalars["String"]>;
        variables?: Maybe<Scalars["JSON"]>;
        version?: Maybe<Scalars["String"]>;
    };
    type ProcessInstanceError = {
        __typename?: "ProcessInstanceError";
        message?: Maybe<Scalars["String"]>;
        nodeDefinitionId: Scalars["String"];
    };
    type Milestone = {
        __typename?: "Milestone";
        id: Scalars["String"];
        name: Scalars["String"];
        status: MilestoneStatus;
    };
    type NodeInstance = {
        __typename?: "NodeInstance";
        definitionId: Scalars["String"];
        enter: Scalars["DateTime"];
        exit?: Maybe<Scalars["DateTime"]>;
        id: Scalars["String"];
        name: Scalars["String"];
        nodeId: Scalars["String"];
        slaDueDate?: Maybe<Scalars["DateTime"]>;
        type: Scalars["String"];
    };
    type UserTaskInstanceOrderBy = {
        actualOwner?: InputMaybe<OrderBy>;
        completed?: InputMaybe<OrderBy>;
        description?: InputMaybe<OrderBy>;
        lastUpdate?: InputMaybe<OrderBy>;
        name?: InputMaybe<OrderBy>;
        priority?: InputMaybe<OrderBy>;
        processId?: InputMaybe<OrderBy>;
        referenceName?: InputMaybe<OrderBy>;
        started?: InputMaybe<OrderBy>;
        state?: InputMaybe<OrderBy>;
    };
    type UserTaskInstanceArgument = {
        actualOwner?: InputMaybe<StringArgument>;
        adminGroups?: InputMaybe<StringArrayArgument>;
        adminUsers?: InputMaybe<StringArrayArgument>;
        and?: InputMaybe<Array<UserTaskInstanceArgument>>;
        attachments?: InputMaybe<AttachmentArgument>;
        comments?: InputMaybe<CommentArgument>;
        completed?: InputMaybe<DateArgument>;
        description?: InputMaybe<StringArgument>;
        excludedUsers?: InputMaybe<StringArrayArgument>;
        id?: InputMaybe<IdArgument>;
        lastUpdate?: InputMaybe<DateArgument>;
        name?: InputMaybe<StringArgument>;
        not?: InputMaybe<UserTaskInstanceArgument>;
        or?: InputMaybe<Array<UserTaskInstanceArgument>>;
        potentialGroups?: InputMaybe<StringArrayArgument>;
        potentialUsers?: InputMaybe<StringArrayArgument>;
        priority?: InputMaybe<StringArgument>;
        processId?: InputMaybe<StringArgument>;
        processInstanceId?: InputMaybe<IdArgument>;
        referenceName?: InputMaybe<StringArgument>;
        started?: InputMaybe<DateArgument>;
        state?: InputMaybe<StringArgument>;
    };
    type AttachmentArgument = {
        id?: InputMaybe<IdArgument>;
        name?: InputMaybe<StringArgument>;
    };
    type CommentArgument = {
        id?: InputMaybe<IdArgument>;
        name?: InputMaybe<StringArgument>;
    };
    type UserTaskInstance = {
        __typename?: "UserTaskInstance";
        actualOwner?: Maybe<Scalars["String"]>;
        adminGroups?: Maybe<Array<Scalars["String"]>>;
        adminUsers?: Maybe<Array<Scalars["String"]>>;
        attachments?: Maybe<Array<Attachment>>;
        comments?: Maybe<Array<Comment>>;
        completed?: Maybe<Scalars["DateTime"]>;
        description?: Maybe<Scalars["String"]>;
        endpoint?: Maybe<Scalars["String"]>;
        excludedUsers?: Maybe<Array<Scalars["String"]>>;
        externalReferenceId?: Maybe<Scalars["String"]>;
        id: Scalars["String"];
        inputs?: Maybe<Scalars["String"]>;
        lastUpdate: Scalars["DateTime"];
        name?: Maybe<Scalars["String"]>;
        outputs?: Maybe<Scalars["String"]>;
        potentialGroups?: Maybe<Array<Scalars["String"]>>;
        potentialUsers?: Maybe<Array<Scalars["String"]>>;
        priority?: Maybe<Scalars["String"]>;
        processId?: Maybe<Scalars["String"]>;
        processInstanceId: Scalars["String"];
        referenceName?: Maybe<Scalars["String"]>;
        rootProcessId?: Maybe<Scalars["String"]>;
        rootProcessInstanceId?: Maybe<Scalars["String"]>;
        schema?: Maybe<Scalars["String"]>;
        slaDueDate?: Maybe<Scalars["DateTime"]>;
        started?: Maybe<Scalars["DateTime"]>;
        state?: Maybe<Scalars["String"]>;
    };
    type UserTaskInstanceSchemaArgs = {
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type Attachment = {
        __typename?: "Attachment";
        content: Scalars["String"];
        id: Scalars["String"];
        name: Scalars["String"];
        updatedAt: Scalars["DateTime"];
        updatedBy: Scalars["String"];
    };
    type Comment = {
        __typename?: "Comment";
        content: Scalars["String"];
        id: Scalars["String"];
        updatedAt: Scalars["DateTime"];
        updatedBy: Scalars["String"];
    };
    type Mutation = {
        __typename?: "Mutation";
        JobCancel?: Maybe<Scalars["String"]>;
        JobReschedule?: Maybe<Scalars["String"]>;
        NodeInstanceCancel?: Maybe<Scalars["String"]>;
        NodeInstanceRetrigger?: Maybe<Scalars["String"]>;
        NodeInstanceTrigger?: Maybe<Scalars["String"]>;
        ProcessInstanceAbort?: Maybe<Scalars["String"]>;
        ProcessInstanceRetry?: Maybe<Scalars["String"]>;
        ProcessInstanceSkip?: Maybe<Scalars["String"]>;
        ProcessInstanceUpdateVariables?: Maybe<Scalars["String"]>;
        UserTaskInstanceAttachmentCreate?: Maybe<Scalars["String"]>;
        UserTaskInstanceAttachmentDelete?: Maybe<Scalars["String"]>;
        UserTaskInstanceAttachmentUpdate?: Maybe<Scalars["String"]>;
        UserTaskInstanceCommentCreate?: Maybe<Scalars["String"]>;
        UserTaskInstanceCommentDelete?: Maybe<Scalars["String"]>;
        UserTaskInstanceCommentUpdate?: Maybe<Scalars["String"]>;
        UserTaskInstanceUpdate?: Maybe<Scalars["String"]>;
    };
    type MutationJobCancelArgs = {
        id?: InputMaybe<Scalars["String"]>;
    };
    type MutationJobRescheduleArgs = {
        data?: InputMaybe<Scalars["String"]>;
        id?: InputMaybe<Scalars["String"]>;
    };
    type MutationNodeInstanceCancelArgs = {
        id?: InputMaybe<Scalars["String"]>;
        nodeInstanceId?: InputMaybe<Scalars["String"]>;
    };
    type MutationNodeInstanceRetriggerArgs = {
        id?: InputMaybe<Scalars["String"]>;
        nodeInstanceId?: InputMaybe<Scalars["String"]>;
    };
    type MutationNodeInstanceTriggerArgs = {
        id?: InputMaybe<Scalars["String"]>;
        nodeId?: InputMaybe<Scalars["String"]>;
    };
    type MutationProcessInstanceAbortArgs = {
        id?: InputMaybe<Scalars["String"]>;
    };
    type MutationProcessInstanceRetryArgs = {
        id?: InputMaybe<Scalars["String"]>;
    };
    type MutationProcessInstanceSkipArgs = {
        id?: InputMaybe<Scalars["String"]>;
    };
    type MutationProcessInstanceUpdateVariablesArgs = {
        id?: InputMaybe<Scalars["String"]>;
        variables?: InputMaybe<Scalars["String"]>;
    };
    type MutationUserTaskInstanceAttachmentCreateArgs = {
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        name?: InputMaybe<Scalars["String"]>;
        taskId?: InputMaybe<Scalars["String"]>;
        uri?: InputMaybe<Scalars["String"]>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type MutationUserTaskInstanceAttachmentDeleteArgs = {
        attachmentId?: InputMaybe<Scalars["String"]>;
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type MutationUserTaskInstanceAttachmentUpdateArgs = {
        attachmentId?: InputMaybe<Scalars["String"]>;
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        name?: InputMaybe<Scalars["String"]>;
        uri?: InputMaybe<Scalars["String"]>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type MutationUserTaskInstanceCommentCreateArgs = {
        comment?: InputMaybe<Scalars["String"]>;
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        taskId?: InputMaybe<Scalars["String"]>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type MutationUserTaskInstanceCommentDeleteArgs = {
        commentId?: InputMaybe<Scalars["String"]>;
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type MutationUserTaskInstanceCommentUpdateArgs = {
        comment?: InputMaybe<Scalars["String"]>;
        commentId?: InputMaybe<Scalars["String"]>;
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type MutationUserTaskInstanceUpdateArgs = {
        actualOwner?: InputMaybe<Scalars["String"]>;
        adminGroups?: InputMaybe<Array<Scalars["String"]>>;
        adminUsers?: InputMaybe<Array<Scalars["String"]>>;
        description?: InputMaybe<Scalars["String"]>;
        excludedUsers?: InputMaybe<Array<Scalars["String"]>>;
        groups?: InputMaybe<Array<InputMaybe<Scalars["String"]>>>;
        inputParams?: InputMaybe<Scalars["String"]>;
        potentialGroups?: InputMaybe<Array<Scalars["String"]>>;
        potentialUsers?: InputMaybe<Array<Scalars["String"]>>;
        priority?: InputMaybe<Scalars["String"]>;
        taskId?: InputMaybe<Scalars["String"]>;
        user?: InputMaybe<Scalars["String"]>;
    };
    type Subscription = {
        __typename?: "Subscription";
        JobAdded: Job;
        JobUpdated: Job;
        ProcessInstanceAdded: ProcessInstance;
        ProcessInstanceUpdated: ProcessInstance;
        UserTaskInstanceAdded: UserTaskInstance;
        UserTaskInstanceUpdated: UserTaskInstance;
    };
    type BigDecimalArgument = {
        between?: InputMaybe<BigDecimalRange>;
        equal?: InputMaybe<Scalars["BigDecimal"]>;
        greaterThan?: InputMaybe<Scalars["BigDecimal"]>;
        greaterThanEqual?: InputMaybe<Scalars["BigDecimal"]>;
        in?: InputMaybe<Array<Scalars["BigDecimal"]>>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
        lessThan?: InputMaybe<Scalars["BigDecimal"]>;
        lessThanEqual?: InputMaybe<Scalars["BigDecimal"]>;
    };
    type BigDecimalRange = {
        from: Scalars["BigDecimal"];
        to: Scalars["BigDecimal"];
    };
    type BooleanArgument = {
        equal?: InputMaybe<Scalars["Boolean"]>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
    };
    type FloatArgument = {
        between?: InputMaybe<FloatRange>;
        equal?: InputMaybe<Scalars["Float"]>;
        greaterThan?: InputMaybe<Scalars["Float"]>;
        greaterThanEqual?: InputMaybe<Scalars["Float"]>;
        in?: InputMaybe<Array<Scalars["Float"]>>;
        isNull?: InputMaybe<Scalars["Boolean"]>;
        lessThan?: InputMaybe<Scalars["Float"]>;
        lessThanEqual?: InputMaybe<Scalars["Float"]>;
    };
    type FloatRange = {
        from: Scalars["Float"];
        to: Scalars["Float"];
    };
    type KogitoMetadata = {
        __typename?: "KogitoMetadata";
        lastUpdate: Scalars["DateTime"];
        processInstances?: Maybe<Array<Maybe<ProcessInstanceMeta>>>;
        userTasks?: Maybe<Array<Maybe<UserTaskInstanceMeta>>>;
    };
    type ProcessInstanceMeta = {
        __typename?: "ProcessInstanceMeta";
        businessKey?: Maybe<Scalars["String"]>;
        createdBy?: Maybe<Scalars["String"]>;
        end?: Maybe<Scalars["DateTime"]>;
        endpoint: Scalars["String"];
        id: Scalars["String"];
        lastUpdate: Scalars["DateTime"];
        parentProcessInstanceId?: Maybe<Scalars["String"]>;
        processId: Scalars["String"];
        processName?: Maybe<Scalars["String"]>;
        roles?: Maybe<Array<Scalars["String"]>>;
        rootProcessId?: Maybe<Scalars["String"]>;
        rootProcessInstanceId?: Maybe<Scalars["String"]>;
        serviceUrl?: Maybe<Scalars["String"]>;
        start: Scalars["DateTime"];
        state: ProcessInstanceState;
        updatedBy?: Maybe<Scalars["String"]>;
        version?: Maybe<Scalars["String"]>;
    };
    type UserTaskInstanceMeta = {
        __typename?: "UserTaskInstanceMeta";
        actualOwner?: Maybe<Scalars["String"]>;
        adminGroups?: Maybe<Array<Scalars["String"]>>;
        adminUsers?: Maybe<Array<Scalars["String"]>>;
        attachments?: Maybe<Array<Attachment>>;
        comments?: Maybe<Array<Comment>>;
        completed?: Maybe<Scalars["DateTime"]>;
        description?: Maybe<Scalars["String"]>;
        excludedUsers?: Maybe<Array<Scalars["String"]>>;
        id: Scalars["String"];
        lastUpdate: Scalars["DateTime"];
        name?: Maybe<Scalars["String"]>;
        potentialGroups?: Maybe<Array<Scalars["String"]>>;
        potentialUsers?: Maybe<Array<Scalars["String"]>>;
        priority?: Maybe<Scalars["String"]>;
        processInstanceId: Scalars["String"];
        referenceName?: Maybe<Scalars["String"]>;
        started: Scalars["DateTime"];
        state: Scalars["String"];
    };
    type KogitoMetadataArgument = {
        lastUpdate?: InputMaybe<DateArgument>;
        processInstances?: InputMaybe<ProcessInstanceMetaArgument>;
        userTasks?: InputMaybe<UserTaskInstanceMetaArgument>;
    };
    type ProcessInstanceMetaArgument = {
        businessKey?: InputMaybe<StringArgument>;
        createdBy?: InputMaybe<StringArgument>;
        end?: InputMaybe<DateArgument>;
        endpoint?: InputMaybe<StringArgument>;
        id?: InputMaybe<IdArgument>;
        parentProcessInstanceId?: InputMaybe<IdArgument>;
        processId?: InputMaybe<StringArgument>;
        processName?: InputMaybe<StringArgument>;
        roles?: InputMaybe<StringArrayArgument>;
        rootProcessId?: InputMaybe<StringArgument>;
        rootProcessInstanceId?: InputMaybe<IdArgument>;
        start?: InputMaybe<DateArgument>;
        state?: InputMaybe<ProcessInstanceStateArgument>;
        updatedBy?: InputMaybe<StringArgument>;
    };
    type UserTaskInstanceMetaArgument = {
        actualOwner?: InputMaybe<StringArgument>;
        adminGroups?: InputMaybe<StringArrayArgument>;
        adminUsers?: InputMaybe<StringArrayArgument>;
        completed?: InputMaybe<DateArgument>;
        description?: InputMaybe<StringArgument>;
        excludedUsers?: InputMaybe<StringArrayArgument>;
        id?: InputMaybe<IdArgument>;
        name?: InputMaybe<StringArgument>;
        potentialGroups?: InputMaybe<StringArrayArgument>;
        potentialUsers?: InputMaybe<StringArrayArgument>;
        priority?: InputMaybe<StringArgument>;
        processInstanceId?: InputMaybe<IdArgument>;
        referenceName?: InputMaybe<StringArgument>;
        started?: InputMaybe<DateArgument>;
        state?: InputMaybe<StringArgument>;
    };
    type KogitoMetadataOrderBy = {
        lastUpdate?: InputMaybe<OrderBy>;
    };
    type LongArgument = {
        between?: InputMaybe<LongRange>;
        equal?: InputMaybe<Scalars["Long"]>;
        greaterThan?: InputMaybe<Scalars["Long"]>;
        greaterThanEqual?: InputMaybe<Scalars["Long"]>;
        in?: InputMaybe<Array<Scalars["Long"]>>;
        isNull?: InputMaybe<Scalars["Long"]>;
        lessThan?: InputMaybe<Scalars["Long"]>;
        lessThanEqual?: InputMaybe<Scalars["Long"]>;
    };
    type LongRange = {
        from: Scalars["Long"];
        to: Scalars["Long"];
    };
    type __Directive = {
        __typename?: "__Directive";
        name: Scalars["String"];
        description?: Maybe<Scalars["String"]>;
        locations: Array<__DirectiveLocation>;
        args: Array<__InputValue>;
    };
    enum __DirectiveLocation {
        Query = "QUERY",
        Mutation = "MUTATION",
        Subscription = "SUBSCRIPTION",
        Field = "FIELD",
        FragmentDefinition = "FRAGMENT_DEFINITION",
        FragmentSpread = "FRAGMENT_SPREAD",
        InlineFragment = "INLINE_FRAGMENT",
        VariableDefinition = "VARIABLE_DEFINITION",
        Schema = "SCHEMA",
        Scalar = "SCALAR",
        Object = "OBJECT",
        FieldDefinition = "FIELD_DEFINITION",
        ArgumentDefinition = "ARGUMENT_DEFINITION",
        Interface = "INTERFACE",
        Union = "UNION",
        Enum = "ENUM",
        EnumValue = "ENUM_VALUE",
        InputObject = "INPUT_OBJECT",
        InputFieldDefinition = "INPUT_FIELD_DEFINITION"
    }
    type __EnumValue = {
        __typename?: "__EnumValue";
        name: Scalars["String"];
        description?: Maybe<Scalars["String"]>;
        isDeprecated: Scalars["Boolean"];
        deprecationReason?: Maybe<Scalars["String"]>;
    };
    type __Field = {
        __typename?: "__Field";
        name: Scalars["String"];
        description?: Maybe<Scalars["String"]>;
        args: Array<__InputValue>;
        type: __Type;
        isDeprecated: Scalars["Boolean"];
        deprecationReason?: Maybe<Scalars["String"]>;
    };
    type __InputValue = {
        __typename?: "__InputValue";
        name: Scalars["String"];
        description?: Maybe<Scalars["String"]>;
        type: __Type;
        defaultValue?: Maybe<Scalars["String"]>;
    };
    type __Schema = {
        __typename?: "__Schema";
        types: Array<__Type>;
        queryType: __Type;
        mutationType?: Maybe<__Type>;
        subscriptionType?: Maybe<__Type>;
        directives: Array<__Directive>;
    };
    type __Type = {
        __typename?: "__Type";
        kind: __TypeKind;
        name?: Maybe<Scalars["String"]>;
        description?: Maybe<Scalars["String"]>;
        fields?: Maybe<Array<__Field>>;
        interfaces?: Maybe<Array<__Type>>;
        possibleTypes?: Maybe<Array<__Type>>;
        enumValues?: Maybe<Array<__EnumValue>>;
        inputFields?: Maybe<Array<__InputValue>>;
        ofType?: Maybe<__Type>;
    };
    type __TypeFieldsArgs = {
        includeDeprecated?: InputMaybe<Scalars["Boolean"]>;
    };
    type __TypeEnumValuesArgs = {
        includeDeprecated?: InputMaybe<Scalars["Boolean"]>;
    };
    enum __TypeKind {
        Scalar = "SCALAR",
        Object = "OBJECT",
        Interface = "INTERFACE",
        Union = "UNION",
        Enum = "ENUM",
        InputObject = "INPUT_OBJECT",
        List = "LIST",
        NonNull = "NON_NULL"
    }
    type GetProcessInstancesQueryVariables = Exact<{
        where?: InputMaybe<ProcessInstanceArgument>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
        orderBy?: InputMaybe<ProcessInstanceOrderBy>;
    }>;
    type GetProcessInstancesQuery = {
        __typename?: "Query";
        ProcessInstances?: Array<{
            __typename?: "ProcessInstance";
            id: string;
            processId: string;
            processName?: string | null;
            parentProcessInstanceId?: string | null;
            rootProcessInstanceId?: string | null;
            roles?: Array<string> | null;
            state?: ProcessInstanceState | null;
            start?: any | null;
            lastUpdate: any;
            addons?: Array<string> | null;
            businessKey?: string | null;
            serviceUrl?: string | null;
            error?: {
                __typename?: "ProcessInstanceError";
                nodeDefinitionId: string;
                message?: string | null;
            } | null;
        } | null> | null;
    };
    type GetChildInstancesQueryVariables = Exact<{
        rootProcessInstanceId?: InputMaybe<Scalars["String"]>;
    }>;
    type GetChildInstancesQuery = {
        __typename?: "Query";
        ProcessInstances?: Array<{
            __typename?: "ProcessInstance";
            id: string;
            processId: string;
            processName?: string | null;
            parentProcessInstanceId?: string | null;
            rootProcessInstanceId?: string | null;
            roles?: Array<string> | null;
            state?: ProcessInstanceState | null;
            start?: any | null;
            lastUpdate: any;
            serviceUrl?: string | null;
            addons?: Array<string> | null;
            businessKey?: string | null;
            error?: {
                __typename?: "ProcessInstanceError";
                nodeDefinitionId: string;
                message?: string | null;
            } | null;
        } | null> | null;
    };
    type GetProcessInstanceByIdQueryVariables = Exact<{
        id?: InputMaybe<Scalars["String"]>;
    }>;
    type GetProcessInstanceByIdQuery = {
        __typename?: "Query";
        ProcessInstances?: Array<{
            __typename?: "ProcessInstance";
            id: string;
            processId: string;
            processName?: string | null;
            businessKey?: string | null;
            parentProcessInstanceId?: string | null;
            roles?: Array<string> | null;
            variables?: any | null;
            state?: ProcessInstanceState | null;
            start?: any | null;
            lastUpdate: any;
            end?: any | null;
            addons?: Array<string> | null;
            endpoint: string;
            serviceUrl?: string | null;
            source?: string | null;
            parentProcessInstance?: {
                __typename?: "ProcessInstance";
                id: string;
                processName?: string | null;
                businessKey?: string | null;
            } | null;
            error?: {
                __typename?: "ProcessInstanceError";
                nodeDefinitionId: string;
                message?: string | null;
            } | null;
            childProcessInstances?: Array<{
                __typename?: "ProcessInstance";
                id: string;
                processName?: string | null;
                businessKey?: string | null;
            }> | null;
            nodes?: Array<{
                __typename?: "NodeInstance";
                id: string;
                nodeId: string;
                name: string;
                enter: any;
                exit?: any | null;
                type: string;
                definitionId: string;
            }> | null;
            milestones?: Array<{
                __typename?: "Milestone";
                id: string;
                name: string;
                status: MilestoneStatus;
            }> | null;
        } | null> | null;
    };
    type GetColumnPickerAttributesQueryVariables = Exact<{
        columnPickerType: Scalars["String"];
    }>;
    type GetColumnPickerAttributesQuery = {
        __typename?: "Query";
        __type?: {
            __typename?: "__Type";
            name?: string | null;
            fields?: Array<{
                __typename?: "__Field";
                name: string;
                type: {
                    __typename?: "__Type";
                    name?: string | null;
                    kind: __TypeKind;
                    fields?: Array<{
                        __typename?: "__Field";
                        name: string;
                        type: {
                            __typename?: "__Type";
                            name?: string | null;
                            kind: __TypeKind;
                        };
                    }> | null;
                };
            }> | null;
        } | null;
    };
    type GetQueryTypesQueryVariables = Exact<{
        [key: string]: never;
    }>;
    type GetQueryTypesQuery = {
        __typename?: "Query";
        __schema: {
            __typename?: "__Schema";
            queryType: Array<{
                __typename?: "__Type";
                name?: string | null;
                kind: __TypeKind;
                fields?: Array<{
                    __typename?: "__Field";
                    name: string;
                    type: {
                        __typename?: "__Type";
                        name?: string | null;
                        kind: __TypeKind;
                    };
                }> | null;
                inputFields?: Array<{
                    __typename?: "__InputValue";
                    name: string;
                    type: {
                        __typename?: "__Type";
                        name?: string | null;
                        kind: __TypeKind;
                    };
                }> | null;
            }>;
        };
    };
    type GetQueryFieldsQueryVariables = Exact<{
        [key: string]: never;
    }>;
    type GetQueryFieldsQuery = {
        __typename?: "Query";
        __type?: {
            __typename?: "__Type";
            name?: string | null;
            fields?: Array<{
                __typename?: "__Field";
                name: string;
                args: Array<{
                    __typename?: "__InputValue";
                    name: string;
                    type: {
                        __typename?: "__Type";
                        kind: __TypeKind;
                        name?: string | null;
                    };
                }>;
                type: {
                    __typename?: "__Type";
                    ofType?: {
                        __typename?: "__Type";
                        name?: string | null;
                    } | null;
                };
            }> | null;
        } | null;
    };
    type GetInputFieldsFromQueryQueryVariables = Exact<{
        currentQuery: Scalars["String"];
    }>;
    type GetInputFieldsFromQueryQuery = {
        __typename?: "Query";
        __type?: {
            __typename?: "__Type";
            name?: string | null;
            inputFields?: Array<{
                __typename?: "__InputValue";
                name: string;
                type: {
                    __typename?: "__Type";
                    name?: string | null;
                    kind: __TypeKind;
                    inputFields?: Array<{
                        __typename?: "__InputValue";
                        name: string;
                        type: {
                            __typename?: "__Type";
                            name?: string | null;
                        };
                    }> | null;
                };
            }> | null;
        } | null;
    };
    type GetInputFieldsFromTypeQueryVariables = Exact<{
        type: Scalars["String"];
    }>;
    type GetInputFieldsFromTypeQuery = {
        __typename?: "Query";
        __type?: {
            __typename?: "__Type";
            name?: string | null;
            inputFields?: Array<{
                __typename?: "__InputValue";
                name: string;
                type: {
                    __typename?: "__Type";
                    name?: string | null;
                    kind: __TypeKind;
                    enumValues?: Array<{
                        __typename?: "__EnumValue";
                        name: string;
                    }> | null;
                    ofType?: {
                        __typename?: "__Type";
                        kind: __TypeKind;
                        name?: string | null;
                        enumValues?: Array<{
                            __typename?: "__EnumValue";
                            name: string;
                        }> | null;
                    } | null;
                };
            }> | null;
        } | null;
    };
    type GetUserTasksByStatesQueryVariables = Exact<{
        state?: InputMaybe<Array<Scalars["String"]> | Scalars["String"]>;
        orderBy?: InputMaybe<UserTaskInstanceOrderBy>;
    }>;
    type GetUserTasksByStatesQuery = {
        __typename?: "Query";
        UserTaskInstances?: Array<{
            __typename?: "UserTaskInstance";
            id: string;
            name?: string | null;
            referenceName?: string | null;
            description?: string | null;
            priority?: string | null;
            processInstanceId: string;
            processId?: string | null;
            rootProcessInstanceId?: string | null;
            rootProcessId?: string | null;
            state?: string | null;
            actualOwner?: string | null;
            adminGroups?: Array<string> | null;
            adminUsers?: Array<string> | null;
            completed?: any | null;
            started?: any | null;
            excludedUsers?: Array<string> | null;
            potentialGroups?: Array<string> | null;
            potentialUsers?: Array<string> | null;
            inputs?: string | null;
            outputs?: string | null;
            endpoint?: string | null;
        } | null> | null;
    };
    type GetUserTaskByIdQueryVariables = Exact<{
        id?: InputMaybe<Scalars["String"]>;
    }>;
    type GetUserTaskByIdQuery = {
        __typename?: "Query";
        UserTaskInstances?: Array<{
            __typename?: "UserTaskInstance";
            id: string;
            description?: string | null;
            name?: string | null;
            priority?: string | null;
            processInstanceId: string;
            processId?: string | null;
            rootProcessInstanceId?: string | null;
            rootProcessId?: string | null;
            state?: string | null;
            actualOwner?: string | null;
            adminGroups?: Array<string> | null;
            adminUsers?: Array<string> | null;
            completed?: any | null;
            started?: any | null;
            excludedUsers?: Array<string> | null;
            potentialGroups?: Array<string> | null;
            potentialUsers?: Array<string> | null;
            inputs?: string | null;
            outputs?: string | null;
            referenceName?: string | null;
            endpoint?: string | null;
            lastUpdate: any;
        } | null> | null;
    };
    type GetTasksForUserQueryVariables = Exact<{
        whereArgument?: InputMaybe<UserTaskInstanceArgument>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
        orderBy?: InputMaybe<UserTaskInstanceOrderBy>;
    }>;
    type GetTasksForUserQuery = {
        __typename?: "Query";
        UserTaskInstances?: Array<{
            __typename?: "UserTaskInstance";
            id: string;
            name?: string | null;
            referenceName?: string | null;
            description?: string | null;
            priority?: string | null;
            processInstanceId: string;
            processId?: string | null;
            rootProcessInstanceId?: string | null;
            rootProcessId?: string | null;
            state?: string | null;
            actualOwner?: string | null;
            adminGroups?: Array<string> | null;
            adminUsers?: Array<string> | null;
            completed?: any | null;
            started?: any | null;
            excludedUsers?: Array<string> | null;
            potentialGroups?: Array<string> | null;
            potentialUsers?: Array<string> | null;
            inputs?: string | null;
            outputs?: string | null;
            lastUpdate: any;
            endpoint?: string | null;
        } | null> | null;
    };
    type GetJobsByProcessInstanceIdQueryVariables = Exact<{
        processInstanceId?: InputMaybe<Scalars["String"]>;
    }>;
    type GetJobsByProcessInstanceIdQuery = {
        __typename?: "Query";
        Jobs?: Array<{
            __typename?: "Job";
            id: string;
            processId?: string | null;
            processInstanceId?: string | null;
            rootProcessId?: string | null;
            status: JobStatus;
            expirationTime?: any | null;
            priority?: number | null;
            callbackEndpoint?: string | null;
            repeatInterval?: number | null;
            repeatLimit?: number | null;
            scheduledId?: string | null;
            retries?: number | null;
            lastUpdate?: any | null;
            endpoint?: string | null;
            nodeInstanceId?: string | null;
            executionCounter?: number | null;
        } | null> | null;
    };
    type GetJobsWithFiltersQueryVariables = Exact<{
        values?: InputMaybe<Array<InputMaybe<JobStatus>> | InputMaybe<JobStatus>>;
        orderBy?: InputMaybe<JobOrderBy>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
    }>;
    type GetJobsWithFiltersQuery = {
        __typename?: "Query";
        Jobs?: Array<{
            __typename?: "Job";
            id: string;
            processId?: string | null;
            processInstanceId?: string | null;
            rootProcessId?: string | null;
            status: JobStatus;
            expirationTime?: any | null;
            priority?: number | null;
            callbackEndpoint?: string | null;
            repeatInterval?: number | null;
            repeatLimit?: number | null;
            scheduledId?: string | null;
            retries?: number | null;
            lastUpdate?: any | null;
            endpoint?: string | null;
            nodeInstanceId?: string | null;
            executionCounter?: number | null;
        } | null> | null;
    };
    type AbortProcessInstanceMutationVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>;
    type AbortProcessInstanceMutation = {
        __typename?: "Mutation";
        ProcessInstanceAbort?: string | null;
    };
    type SkipProcessInstanceMutationVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>;
    type SkipProcessInstanceMutation = {
        __typename?: "Mutation";
        ProcessInstanceSkip?: string | null;
    };
    type RetryProcessInstanceMutationVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>;
    type RetryProcessInstanceMutation = {
        __typename?: "Mutation";
        ProcessInstanceRetry?: string | null;
    };
    type GetProcessInstanceSvgQueryVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>;
    type GetProcessInstanceSvgQuery = {
        __typename?: "Query";
        ProcessInstances?: Array<{
            __typename?: "ProcessInstance";
            diagram?: string | null;
        } | null> | null;
    };
    type GetProcessDefinitionsQueryVariables = Exact<{
        [key: string]: never;
    }>;
    type GetProcessDefinitionsQuery = {
        __typename?: "Query";
        ProcessDefinitions?: Array<{
            __typename?: "ProcessDefinition";
            id: string;
            endpoint?: string | null;
        } | null> | null;
    };
    type GetProcessDefinitionNodesQueryVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>;
    type GetProcessDefinitionNodesQuery = {
        __typename?: "Query";
        ProcessDefinitions?: Array<{
            __typename?: "ProcessDefinition";
            nodes?: Array<{
                __typename?: "Node";
                id: string;
                name: string;
                type: string;
            }> | null;
        } | null> | null;
    };
    type HandleNodeTriggerMutationVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        nodeId?: InputMaybe<Scalars["String"]>;
    }>;
    type HandleNodeTriggerMutation = {
        __typename?: "Mutation";
        NodeInstanceTrigger?: string | null;
    };
    type HandleNodeInstanceCancelMutationVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        nodeInstanceId?: InputMaybe<Scalars["String"]>;
    }>;
    type HandleNodeInstanceCancelMutation = {
        __typename?: "Mutation";
        NodeInstanceCancel?: string | null;
    };
    type HandleNodeInstanceRetriggerMutationVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        nodeInstanceId?: InputMaybe<Scalars["String"]>;
    }>;
    type HandleNodeInstanceRetriggerMutation = {
        __typename?: "Mutation";
        NodeInstanceRetrigger?: string | null;
    };
    type HandleProcessVariableUpdateMutationVariables = Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        processInstanceVariables?: InputMaybe<Scalars["String"]>;
    }>;
    type HandleProcessVariableUpdateMutation = {
        __typename?: "Mutation";
        ProcessInstanceUpdateVariables?: string | null;
    };
    type JobCancelMutationVariables = Exact<{
        jobId?: InputMaybe<Scalars["String"]>;
    }>;
    type JobCancelMutation = {
        __typename?: "Mutation";
        JobCancel?: string | null;
    };
    type HandleJobRescheduleMutationVariables = Exact<{
        jobId?: InputMaybe<Scalars["String"]>;
        data?: InputMaybe<Scalars["String"]>;
    }>;
    type HandleJobRescheduleMutation = {
        __typename?: "Mutation";
        JobReschedule?: string | null;
    };
    const GetProcessInstancesDocument: any;
    function useGetProcessInstancesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetProcessInstancesQuery, GetProcessInstancesQueryVariables>): ApolloReactCommon.QueryResult<GetProcessInstancesQuery, Exact<{
        where?: InputMaybe<ProcessInstanceArgument>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
        orderBy?: InputMaybe<ProcessInstanceOrderBy>;
    }>>;
    function useGetProcessInstancesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetProcessInstancesQuery, GetProcessInstancesQueryVariables>): ApolloReactHooks.QueryTuple<GetProcessInstancesQuery, Exact<{
        where?: InputMaybe<ProcessInstanceArgument>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
        orderBy?: InputMaybe<ProcessInstanceOrderBy>;
    }>>;
    type GetProcessInstancesQueryHookResult = ReturnType<typeof useGetProcessInstancesQuery>;
    type GetProcessInstancesLazyQueryHookResult = ReturnType<typeof useGetProcessInstancesLazyQuery>;
    type GetProcessInstancesQueryResult = ApolloReactCommon.QueryResult<GetProcessInstancesQuery, GetProcessInstancesQueryVariables>;
    const GetChildInstancesDocument: any;
    function useGetChildInstancesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetChildInstancesQuery, GetChildInstancesQueryVariables>): ApolloReactCommon.QueryResult<GetChildInstancesQuery, Exact<{
        rootProcessInstanceId?: InputMaybe<Scalars["String"]>;
    }>>;
    function useGetChildInstancesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetChildInstancesQuery, GetChildInstancesQueryVariables>): ApolloReactHooks.QueryTuple<GetChildInstancesQuery, Exact<{
        rootProcessInstanceId?: InputMaybe<Scalars["String"]>;
    }>>;
    type GetChildInstancesQueryHookResult = ReturnType<typeof useGetChildInstancesQuery>;
    type GetChildInstancesLazyQueryHookResult = ReturnType<typeof useGetChildInstancesLazyQuery>;
    type GetChildInstancesQueryResult = ApolloReactCommon.QueryResult<GetChildInstancesQuery, GetChildInstancesQueryVariables>;
    const GetProcessInstanceByIdDocument: any;
    function useGetProcessInstanceByIdQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetProcessInstanceByIdQuery, GetProcessInstanceByIdQueryVariables>): ApolloReactCommon.QueryResult<GetProcessInstanceByIdQuery, Exact<{
        id?: InputMaybe<Scalars["String"]>;
    }>>;
    function useGetProcessInstanceByIdLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetProcessInstanceByIdQuery, GetProcessInstanceByIdQueryVariables>): ApolloReactHooks.QueryTuple<GetProcessInstanceByIdQuery, Exact<{
        id?: InputMaybe<Scalars["String"]>;
    }>>;
    type GetProcessInstanceByIdQueryHookResult = ReturnType<typeof useGetProcessInstanceByIdQuery>;
    type GetProcessInstanceByIdLazyQueryHookResult = ReturnType<typeof useGetProcessInstanceByIdLazyQuery>;
    type GetProcessInstanceByIdQueryResult = ApolloReactCommon.QueryResult<GetProcessInstanceByIdQuery, GetProcessInstanceByIdQueryVariables>;
    const GetColumnPickerAttributesDocument: any;
    function useGetColumnPickerAttributesQuery(baseOptions: ApolloReactHooks.QueryHookOptions<GetColumnPickerAttributesQuery, GetColumnPickerAttributesQueryVariables>): ApolloReactCommon.QueryResult<GetColumnPickerAttributesQuery, Exact<{
        columnPickerType: Scalars["String"];
    }>>;
    function useGetColumnPickerAttributesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetColumnPickerAttributesQuery, GetColumnPickerAttributesQueryVariables>): ApolloReactHooks.QueryTuple<GetColumnPickerAttributesQuery, Exact<{
        columnPickerType: Scalars["String"];
    }>>;
    type GetColumnPickerAttributesQueryHookResult = ReturnType<typeof useGetColumnPickerAttributesQuery>;
    type GetColumnPickerAttributesLazyQueryHookResult = ReturnType<typeof useGetColumnPickerAttributesLazyQuery>;
    type GetColumnPickerAttributesQueryResult = ApolloReactCommon.QueryResult<GetColumnPickerAttributesQuery, GetColumnPickerAttributesQueryVariables>;
    const GetQueryTypesDocument: any;
    function useGetQueryTypesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetQueryTypesQuery, GetQueryTypesQueryVariables>): ApolloReactCommon.QueryResult<GetQueryTypesQuery, Exact<{
        [key: string]: never;
    }>>;
    function useGetQueryTypesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetQueryTypesQuery, GetQueryTypesQueryVariables>): ApolloReactHooks.QueryTuple<GetQueryTypesQuery, Exact<{
        [key: string]: never;
    }>>;
    type GetQueryTypesQueryHookResult = ReturnType<typeof useGetQueryTypesQuery>;
    type GetQueryTypesLazyQueryHookResult = ReturnType<typeof useGetQueryTypesLazyQuery>;
    type GetQueryTypesQueryResult = ApolloReactCommon.QueryResult<GetQueryTypesQuery, GetQueryTypesQueryVariables>;
    const GetQueryFieldsDocument: any;
    function useGetQueryFieldsQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetQueryFieldsQuery, GetQueryFieldsQueryVariables>): ApolloReactCommon.QueryResult<GetQueryFieldsQuery, Exact<{
        [key: string]: never;
    }>>;
    function useGetQueryFieldsLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetQueryFieldsQuery, GetQueryFieldsQueryVariables>): ApolloReactHooks.QueryTuple<GetQueryFieldsQuery, Exact<{
        [key: string]: never;
    }>>;
    type GetQueryFieldsQueryHookResult = ReturnType<typeof useGetQueryFieldsQuery>;
    type GetQueryFieldsLazyQueryHookResult = ReturnType<typeof useGetQueryFieldsLazyQuery>;
    type GetQueryFieldsQueryResult = ApolloReactCommon.QueryResult<GetQueryFieldsQuery, GetQueryFieldsQueryVariables>;
    const GetInputFieldsFromQueryDocument: any;
    function useGetInputFieldsFromQueryQuery(baseOptions: ApolloReactHooks.QueryHookOptions<GetInputFieldsFromQueryQuery, GetInputFieldsFromQueryQueryVariables>): ApolloReactCommon.QueryResult<GetInputFieldsFromQueryQuery, Exact<{
        currentQuery: Scalars["String"];
    }>>;
    function useGetInputFieldsFromQueryLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetInputFieldsFromQueryQuery, GetInputFieldsFromQueryQueryVariables>): ApolloReactHooks.QueryTuple<GetInputFieldsFromQueryQuery, Exact<{
        currentQuery: Scalars["String"];
    }>>;
    type GetInputFieldsFromQueryQueryHookResult = ReturnType<typeof useGetInputFieldsFromQueryQuery>;
    type GetInputFieldsFromQueryLazyQueryHookResult = ReturnType<typeof useGetInputFieldsFromQueryLazyQuery>;
    type GetInputFieldsFromQueryQueryResult = ApolloReactCommon.QueryResult<GetInputFieldsFromQueryQuery, GetInputFieldsFromQueryQueryVariables>;
    const GetInputFieldsFromTypeDocument: any;
    function useGetInputFieldsFromTypeQuery(baseOptions: ApolloReactHooks.QueryHookOptions<GetInputFieldsFromTypeQuery, GetInputFieldsFromTypeQueryVariables>): ApolloReactCommon.QueryResult<GetInputFieldsFromTypeQuery, Exact<{
        type: Scalars["String"];
    }>>;
    function useGetInputFieldsFromTypeLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetInputFieldsFromTypeQuery, GetInputFieldsFromTypeQueryVariables>): ApolloReactHooks.QueryTuple<GetInputFieldsFromTypeQuery, Exact<{
        type: Scalars["String"];
    }>>;
    type GetInputFieldsFromTypeQueryHookResult = ReturnType<typeof useGetInputFieldsFromTypeQuery>;
    type GetInputFieldsFromTypeLazyQueryHookResult = ReturnType<typeof useGetInputFieldsFromTypeLazyQuery>;
    type GetInputFieldsFromTypeQueryResult = ApolloReactCommon.QueryResult<GetInputFieldsFromTypeQuery, GetInputFieldsFromTypeQueryVariables>;
    const GetUserTasksByStatesDocument: any;
    function useGetUserTasksByStatesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetUserTasksByStatesQuery, GetUserTasksByStatesQueryVariables>): ApolloReactCommon.QueryResult<GetUserTasksByStatesQuery, Exact<{
        state?: InputMaybe<Array<Scalars["String"]> | Scalars["String"]>;
        orderBy?: InputMaybe<UserTaskInstanceOrderBy>;
    }>>;
    function useGetUserTasksByStatesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetUserTasksByStatesQuery, GetUserTasksByStatesQueryVariables>): ApolloReactHooks.QueryTuple<GetUserTasksByStatesQuery, Exact<{
        state?: InputMaybe<Array<Scalars["String"]> | Scalars["String"]>;
        orderBy?: InputMaybe<UserTaskInstanceOrderBy>;
    }>>;
    type GetUserTasksByStatesQueryHookResult = ReturnType<typeof useGetUserTasksByStatesQuery>;
    type GetUserTasksByStatesLazyQueryHookResult = ReturnType<typeof useGetUserTasksByStatesLazyQuery>;
    type GetUserTasksByStatesQueryResult = ApolloReactCommon.QueryResult<GetUserTasksByStatesQuery, GetUserTasksByStatesQueryVariables>;
    const GetUserTaskByIdDocument: any;
    function useGetUserTaskByIdQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetUserTaskByIdQuery, GetUserTaskByIdQueryVariables>): ApolloReactCommon.QueryResult<GetUserTaskByIdQuery, Exact<{
        id?: InputMaybe<Scalars["String"]>;
    }>>;
    function useGetUserTaskByIdLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetUserTaskByIdQuery, GetUserTaskByIdQueryVariables>): ApolloReactHooks.QueryTuple<GetUserTaskByIdQuery, Exact<{
        id?: InputMaybe<Scalars["String"]>;
    }>>;
    type GetUserTaskByIdQueryHookResult = ReturnType<typeof useGetUserTaskByIdQuery>;
    type GetUserTaskByIdLazyQueryHookResult = ReturnType<typeof useGetUserTaskByIdLazyQuery>;
    type GetUserTaskByIdQueryResult = ApolloReactCommon.QueryResult<GetUserTaskByIdQuery, GetUserTaskByIdQueryVariables>;
    const GetTasksForUserDocument: any;
    function useGetTasksForUserQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetTasksForUserQuery, GetTasksForUserQueryVariables>): ApolloReactCommon.QueryResult<GetTasksForUserQuery, Exact<{
        whereArgument?: InputMaybe<UserTaskInstanceArgument>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
        orderBy?: InputMaybe<UserTaskInstanceOrderBy>;
    }>>;
    function useGetTasksForUserLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetTasksForUserQuery, GetTasksForUserQueryVariables>): ApolloReactHooks.QueryTuple<GetTasksForUserQuery, Exact<{
        whereArgument?: InputMaybe<UserTaskInstanceArgument>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
        orderBy?: InputMaybe<UserTaskInstanceOrderBy>;
    }>>;
    type GetTasksForUserQueryHookResult = ReturnType<typeof useGetTasksForUserQuery>;
    type GetTasksForUserLazyQueryHookResult = ReturnType<typeof useGetTasksForUserLazyQuery>;
    type GetTasksForUserQueryResult = ApolloReactCommon.QueryResult<GetTasksForUserQuery, GetTasksForUserQueryVariables>;
    const GetJobsByProcessInstanceIdDocument: any;
    function useGetJobsByProcessInstanceIdQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetJobsByProcessInstanceIdQuery, GetJobsByProcessInstanceIdQueryVariables>): ApolloReactCommon.QueryResult<GetJobsByProcessInstanceIdQuery, Exact<{
        processInstanceId?: InputMaybe<Scalars["String"]>;
    }>>;
    function useGetJobsByProcessInstanceIdLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetJobsByProcessInstanceIdQuery, GetJobsByProcessInstanceIdQueryVariables>): ApolloReactHooks.QueryTuple<GetJobsByProcessInstanceIdQuery, Exact<{
        processInstanceId?: InputMaybe<Scalars["String"]>;
    }>>;
    type GetJobsByProcessInstanceIdQueryHookResult = ReturnType<typeof useGetJobsByProcessInstanceIdQuery>;
    type GetJobsByProcessInstanceIdLazyQueryHookResult = ReturnType<typeof useGetJobsByProcessInstanceIdLazyQuery>;
    type GetJobsByProcessInstanceIdQueryResult = ApolloReactCommon.QueryResult<GetJobsByProcessInstanceIdQuery, GetJobsByProcessInstanceIdQueryVariables>;
    const GetJobsWithFiltersDocument: any;
    function useGetJobsWithFiltersQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetJobsWithFiltersQuery, GetJobsWithFiltersQueryVariables>): ApolloReactCommon.QueryResult<GetJobsWithFiltersQuery, Exact<{
        values?: InputMaybe<Array<InputMaybe<JobStatus>> | InputMaybe<JobStatus>>;
        orderBy?: InputMaybe<JobOrderBy>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
    }>>;
    function useGetJobsWithFiltersLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetJobsWithFiltersQuery, GetJobsWithFiltersQueryVariables>): ApolloReactHooks.QueryTuple<GetJobsWithFiltersQuery, Exact<{
        values?: InputMaybe<Array<InputMaybe<JobStatus>> | InputMaybe<JobStatus>>;
        orderBy?: InputMaybe<JobOrderBy>;
        offset?: InputMaybe<Scalars["Int"]>;
        limit?: InputMaybe<Scalars["Int"]>;
    }>>;
    type GetJobsWithFiltersQueryHookResult = ReturnType<typeof useGetJobsWithFiltersQuery>;
    type GetJobsWithFiltersLazyQueryHookResult = ReturnType<typeof useGetJobsWithFiltersLazyQuery>;
    type GetJobsWithFiltersQueryResult = ApolloReactCommon.QueryResult<GetJobsWithFiltersQuery, GetJobsWithFiltersQueryVariables>;
    const AbortProcessInstanceDocument: any;
    type AbortProcessInstanceMutationFn = ApolloReactCommon.MutationFunction<AbortProcessInstanceMutation, AbortProcessInstanceMutationVariables>;
    function useAbortProcessInstanceMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<AbortProcessInstanceMutation, AbortProcessInstanceMutationVariables>): ApolloReactHooks.MutationTuple<AbortProcessInstanceMutation, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>>;
    type AbortProcessInstanceMutationHookResult = ReturnType<typeof useAbortProcessInstanceMutation>;
    type AbortProcessInstanceMutationResult = ApolloReactCommon.MutationResult<AbortProcessInstanceMutation>;
    type AbortProcessInstanceMutationOptions = ApolloReactCommon.BaseMutationOptions<AbortProcessInstanceMutation, AbortProcessInstanceMutationVariables>;
    const SkipProcessInstanceDocument: any;
    type SkipProcessInstanceMutationFn = ApolloReactCommon.MutationFunction<SkipProcessInstanceMutation, SkipProcessInstanceMutationVariables>;
    function useSkipProcessInstanceMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<SkipProcessInstanceMutation, SkipProcessInstanceMutationVariables>): ApolloReactHooks.MutationTuple<SkipProcessInstanceMutation, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>>;
    type SkipProcessInstanceMutationHookResult = ReturnType<typeof useSkipProcessInstanceMutation>;
    type SkipProcessInstanceMutationResult = ApolloReactCommon.MutationResult<SkipProcessInstanceMutation>;
    type SkipProcessInstanceMutationOptions = ApolloReactCommon.BaseMutationOptions<SkipProcessInstanceMutation, SkipProcessInstanceMutationVariables>;
    const RetryProcessInstanceDocument: any;
    type RetryProcessInstanceMutationFn = ApolloReactCommon.MutationFunction<RetryProcessInstanceMutation, RetryProcessInstanceMutationVariables>;
    function useRetryProcessInstanceMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<RetryProcessInstanceMutation, RetryProcessInstanceMutationVariables>): ApolloReactHooks.MutationTuple<RetryProcessInstanceMutation, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>>;
    type RetryProcessInstanceMutationHookResult = ReturnType<typeof useRetryProcessInstanceMutation>;
    type RetryProcessInstanceMutationResult = ApolloReactCommon.MutationResult<RetryProcessInstanceMutation>;
    type RetryProcessInstanceMutationOptions = ApolloReactCommon.BaseMutationOptions<RetryProcessInstanceMutation, RetryProcessInstanceMutationVariables>;
    const GetProcessInstanceSvgDocument: any;
    function useGetProcessInstanceSvgQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetProcessInstanceSvgQuery, GetProcessInstanceSvgQueryVariables>): ApolloReactCommon.QueryResult<GetProcessInstanceSvgQuery, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>>;
    function useGetProcessInstanceSvgLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetProcessInstanceSvgQuery, GetProcessInstanceSvgQueryVariables>): ApolloReactHooks.QueryTuple<GetProcessInstanceSvgQuery, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>>;
    type GetProcessInstanceSvgQueryHookResult = ReturnType<typeof useGetProcessInstanceSvgQuery>;
    type GetProcessInstanceSvgLazyQueryHookResult = ReturnType<typeof useGetProcessInstanceSvgLazyQuery>;
    type GetProcessInstanceSvgQueryResult = ApolloReactCommon.QueryResult<GetProcessInstanceSvgQuery, GetProcessInstanceSvgQueryVariables>;
    const GetProcessDefinitionsDocument: any;
    function useGetProcessDefinitionsQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetProcessDefinitionsQuery, GetProcessDefinitionsQueryVariables>): ApolloReactCommon.QueryResult<GetProcessDefinitionsQuery, Exact<{
        [key: string]: never;
    }>>;
    function useGetProcessDefinitionsLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetProcessDefinitionsQuery, GetProcessDefinitionsQueryVariables>): ApolloReactHooks.QueryTuple<GetProcessDefinitionsQuery, Exact<{
        [key: string]: never;
    }>>;
    type GetProcessDefinitionsQueryHookResult = ReturnType<typeof useGetProcessDefinitionsQuery>;
    type GetProcessDefinitionsLazyQueryHookResult = ReturnType<typeof useGetProcessDefinitionsLazyQuery>;
    type GetProcessDefinitionsQueryResult = ApolloReactCommon.QueryResult<GetProcessDefinitionsQuery, GetProcessDefinitionsQueryVariables>;
    const GetProcessDefinitionNodesDocument: any;
    function useGetProcessDefinitionNodesQuery(baseOptions?: ApolloReactHooks.QueryHookOptions<GetProcessDefinitionNodesQuery, GetProcessDefinitionNodesQueryVariables>): ApolloReactCommon.QueryResult<GetProcessDefinitionNodesQuery, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>>;
    function useGetProcessDefinitionNodesLazyQuery(baseOptions?: ApolloReactHooks.LazyQueryHookOptions<GetProcessDefinitionNodesQuery, GetProcessDefinitionNodesQueryVariables>): ApolloReactHooks.QueryTuple<GetProcessDefinitionNodesQuery, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
    }>>;
    type GetProcessDefinitionNodesQueryHookResult = ReturnType<typeof useGetProcessDefinitionNodesQuery>;
    type GetProcessDefinitionNodesLazyQueryHookResult = ReturnType<typeof useGetProcessDefinitionNodesLazyQuery>;
    type GetProcessDefinitionNodesQueryResult = ApolloReactCommon.QueryResult<GetProcessDefinitionNodesQuery, GetProcessDefinitionNodesQueryVariables>;
    const HandleNodeTriggerDocument: any;
    type HandleNodeTriggerMutationFn = ApolloReactCommon.MutationFunction<HandleNodeTriggerMutation, HandleNodeTriggerMutationVariables>;
    function useHandleNodeTriggerMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<HandleNodeTriggerMutation, HandleNodeTriggerMutationVariables>): ApolloReactHooks.MutationTuple<HandleNodeTriggerMutation, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        nodeId?: InputMaybe<Scalars["String"]>;
    }>>;
    type HandleNodeTriggerMutationHookResult = ReturnType<typeof useHandleNodeTriggerMutation>;
    type HandleNodeTriggerMutationResult = ApolloReactCommon.MutationResult<HandleNodeTriggerMutation>;
    type HandleNodeTriggerMutationOptions = ApolloReactCommon.BaseMutationOptions<HandleNodeTriggerMutation, HandleNodeTriggerMutationVariables>;
    const HandleNodeInstanceCancelDocument: any;
    type HandleNodeInstanceCancelMutationFn = ApolloReactCommon.MutationFunction<HandleNodeInstanceCancelMutation, HandleNodeInstanceCancelMutationVariables>;
    function useHandleNodeInstanceCancelMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<HandleNodeInstanceCancelMutation, HandleNodeInstanceCancelMutationVariables>): ApolloReactHooks.MutationTuple<HandleNodeInstanceCancelMutation, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        nodeInstanceId?: InputMaybe<Scalars["String"]>;
    }>>;
    type HandleNodeInstanceCancelMutationHookResult = ReturnType<typeof useHandleNodeInstanceCancelMutation>;
    type HandleNodeInstanceCancelMutationResult = ApolloReactCommon.MutationResult<HandleNodeInstanceCancelMutation>;
    type HandleNodeInstanceCancelMutationOptions = ApolloReactCommon.BaseMutationOptions<HandleNodeInstanceCancelMutation, HandleNodeInstanceCancelMutationVariables>;
    const HandleNodeInstanceRetriggerDocument: any;
    type HandleNodeInstanceRetriggerMutationFn = ApolloReactCommon.MutationFunction<HandleNodeInstanceRetriggerMutation, HandleNodeInstanceRetriggerMutationVariables>;
    function useHandleNodeInstanceRetriggerMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<HandleNodeInstanceRetriggerMutation, HandleNodeInstanceRetriggerMutationVariables>): ApolloReactHooks.MutationTuple<HandleNodeInstanceRetriggerMutation, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        nodeInstanceId?: InputMaybe<Scalars["String"]>;
    }>>;
    type HandleNodeInstanceRetriggerMutationHookResult = ReturnType<typeof useHandleNodeInstanceRetriggerMutation>;
    type HandleNodeInstanceRetriggerMutationResult = ApolloReactCommon.MutationResult<HandleNodeInstanceRetriggerMutation>;
    type HandleNodeInstanceRetriggerMutationOptions = ApolloReactCommon.BaseMutationOptions<HandleNodeInstanceRetriggerMutation, HandleNodeInstanceRetriggerMutationVariables>;
    const HandleProcessVariableUpdateDocument: any;
    type HandleProcessVariableUpdateMutationFn = ApolloReactCommon.MutationFunction<HandleProcessVariableUpdateMutation, HandleProcessVariableUpdateMutationVariables>;
    function useHandleProcessVariableUpdateMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<HandleProcessVariableUpdateMutation, HandleProcessVariableUpdateMutationVariables>): ApolloReactHooks.MutationTuple<HandleProcessVariableUpdateMutation, Exact<{
        processId?: InputMaybe<Scalars["String"]>;
        processInstanceVariables?: InputMaybe<Scalars["String"]>;
    }>>;
    type HandleProcessVariableUpdateMutationHookResult = ReturnType<typeof useHandleProcessVariableUpdateMutation>;
    type HandleProcessVariableUpdateMutationResult = ApolloReactCommon.MutationResult<HandleProcessVariableUpdateMutation>;
    type HandleProcessVariableUpdateMutationOptions = ApolloReactCommon.BaseMutationOptions<HandleProcessVariableUpdateMutation, HandleProcessVariableUpdateMutationVariables>;
    const JobCancelDocument: any;
    type JobCancelMutationFn = ApolloReactCommon.MutationFunction<JobCancelMutation, JobCancelMutationVariables>;
    function useJobCancelMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<JobCancelMutation, JobCancelMutationVariables>): ApolloReactHooks.MutationTuple<JobCancelMutation, Exact<{
        jobId?: InputMaybe<Scalars["String"]>;
    }>>;
    type JobCancelMutationHookResult = ReturnType<typeof useJobCancelMutation>;
    type JobCancelMutationResult = ApolloReactCommon.MutationResult<JobCancelMutation>;
    type JobCancelMutationOptions = ApolloReactCommon.BaseMutationOptions<JobCancelMutation, JobCancelMutationVariables>;
    const HandleJobRescheduleDocument: any;
    type HandleJobRescheduleMutationFn = ApolloReactCommon.MutationFunction<HandleJobRescheduleMutation, HandleJobRescheduleMutationVariables>;
    function useHandleJobRescheduleMutation(baseOptions?: ApolloReactHooks.MutationHookOptions<HandleJobRescheduleMutation, HandleJobRescheduleMutationVariables>): ApolloReactHooks.MutationTuple<HandleJobRescheduleMutation, Exact<{
        jobId?: InputMaybe<Scalars["String"]>;
        data?: InputMaybe<Scalars["String"]>;
    }>>;
    type HandleJobRescheduleMutationHookResult = ReturnType<typeof useHandleJobRescheduleMutation>;
    type HandleJobRescheduleMutationResult = ApolloReactCommon.MutationResult<HandleJobRescheduleMutation>;
    type HandleJobRescheduleMutationOptions = ApolloReactCommon.BaseMutationOptions<HandleJobRescheduleMutation, HandleJobRescheduleMutationVariables>;
}
//# sourceMappingURL=types.d.ts.map