import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { Dropdown, DropdownItem, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { checkProcessInstanceState } from "../utils/ProcessListUtils";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ProcessListActionsKebab = ({ processInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent, ouiaId, ouiaSafe, }) => {
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const onSelect = useCallback(() => {
        setIsKebabOpen(!isKebabOpen);
    }, [isKebabOpen]);
    const onToggle = useCallback((isOpen) => {
        setIsKebabOpen(isOpen);
    }, []);
    const dropDownList = useMemo(() => {
        const result = [];
        if (processInstance.state === ProcessInstanceState.Error) {
            result.push(_jsx(DropdownItem, { onClick: () => onRetryClick(processInstance), children: "Retry" }, "Retry"));
            result.push(_jsx(DropdownItem, { onClick: () => onSkipClick(processInstance), children: "Skip" }, "Skip"));
        }
        if (onOpenTriggerCloudEvent) {
            result.push(_jsx(DropdownItem, { onClick: () => onOpenTriggerCloudEvent(processInstance), children: "Send Cloud Event" }, "CloudEvent"));
        }
        result.push(_jsx(DropdownItem, { onClick: () => onAbortClick(processInstance), children: "Abort" }, "Abort"));
        return result;
    }, [processInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent]);
    return (_jsx(Dropdown, { onSelect: onSelect, toggle: _jsx(KebabToggle, { isDisabled: checkProcessInstanceState(processInstance), onToggle: onToggle, "data-testid": "kebab-toggle", id: "kebab-toggle" }), isOpen: isKebabOpen, isPlain: true, position: "right", "aria-label": "process instance actions dropdown", "aria-labelledby": "process instance actions dropdown", dropdownItems: dropDownList, ...componentOuiaProps(ouiaId, "process-list-actions-kebab", ouiaSafe) }));
};
export default ProcessListActionsKebab;
//# sourceMappingURL=ProcessListActionsKebab.js.map