import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import React, { useState } from "react";
import { Dropdown, DropdownItem, KebabToggle, DropdownPosition, DropdownToggle, DropdownToggleCheckbox, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Toolbar, ToolbarItem, ToolbarContent, ToolbarFilter, ToolbarToggleGroup, ToolbarGroup, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { OverflowMenu, OverflowMenuContent, OverflowMenuControl, OverflowMenuItem, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import _ from "lodash";
import "../styles.css";
import { formatForBulkListProcessInstance } from "../utils/ProcessListUtils";
import { ProcessInstanceState, } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { BulkListType, } from "@kie-tools/runtime-tools-components/dist/components/BulkList";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
var Category;
(function (Category) {
    Category["STATUS"] = "Status";
    Category["BUSINESS_KEY"] = "Business key";
})(Category || (Category = {}));
var BulkSelectionType;
(function (BulkSelectionType) {
    BulkSelectionType["NONE"] = "NONE";
    BulkSelectionType["PARENT"] = "PARENT";
    BulkSelectionType["PARENT_CHILD"] = "PARENT_CHILD";
})(BulkSelectionType || (BulkSelectionType = {}));
const ProcessListToolbar = ({ filters, setFilters, applyFilter, refresh, processStates, setProcessStates, selectedInstances, setSelectedInstances, processInstances, setProcessInstances, isAllChecked, setIsAllChecked, driver, defaultStatusFilter, singularProcessLabel, pluralProcessLabel, ouiaId, ouiaSafe, }) => {
    const [isExpanded, setIsExpanded] = useState(false);
    const [businessKeyInput, setBusinessKeyInput] = useState("");
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [operationType, setOperationType] = useState();
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [isCheckboxDropdownOpen, setisCheckboxDropdownOpen] = useState(false);
    const [operationResults, setOperationResults] = useState({
        ABORT: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
        SKIP: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
        RETRY: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
    });
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const operations = {
        ABORT: {
            type: BulkListType.PROCESS_INSTANCE,
            results: operationResults[OperationType.ABORT],
            messages: {
                successMessage: `Aborted ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()}: `,
                noItemsMessage: `No ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were aborted`,
                warningMessage: !processStates.includes(ProcessInstanceState.Aborted)
                    ? `Note: The ${singularProcessLabel === null || singularProcessLabel === void 0 ? void 0 : singularProcessLabel.toLowerCase()} status has been updated. The list may appear inconsistent until you refresh any applied filters.`
                    : "",
                ignoredMessage: `These ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were ignored because they were already completed or aborted.`,
            },
            functions: {
                perform: async () => {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance.state === ProcessInstanceState.Aborted || instance.state === ProcessInstanceState.Completed) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    await driver.handleProcessMultipleAction(remainingInstances, OperationType.ABORT).then((result) => {
                        onShowMessage("Abort operation", result.successProcessInstances, result.failedProcessInstances, ignoredItems, OperationType.ABORT);
                        processInstances.forEach((instance) => {
                            result.successProcessInstances.forEach((successInstances) => {
                                if (successInstances.id === instance.id) {
                                    instance.state = ProcessInstanceState.Aborted;
                                }
                            });
                        });
                        setProcessInstances([...processInstances]);
                    });
                },
            },
        },
        SKIP: {
            type: BulkListType.PROCESS_INSTANCE,
            results: operationResults[OperationType.SKIP],
            messages: {
                successMessage: `Skipped ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()}: `,
                noItemsMessage: `No ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were skipped`,
                ignoredMessage: `These ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were ignored because they were not in error state.`,
            },
            functions: {
                perform: async () => {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance.state !== ProcessInstanceState.Error) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    await driver.handleProcessMultipleAction(remainingInstances, OperationType.SKIP).then((result) => {
                        onShowMessage("Skip operation", result.successProcessInstances, result.failedProcessInstances, ignoredItems, OperationType.SKIP);
                    });
                },
            },
        },
        RETRY: {
            type: BulkListType.PROCESS_INSTANCE,
            results: operationResults[OperationType.RETRY],
            messages: {
                successMessage: `Retriggered ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()}: `,
                noItemsMessage: `No ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were retriggered`,
                ignoredMessage: `These ${pluralProcessLabel === null || pluralProcessLabel === void 0 ? void 0 : pluralProcessLabel.toLowerCase()} were ignored because they were not in error state.`,
            },
            functions: {
                perform: async () => {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance["state"] !== ProcessInstanceState.Error) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    await driver.handleProcessMultipleAction(remainingInstances, OperationType.RETRY).then((result) => {
                        onShowMessage("Retry operation", result.successProcessInstances, result.failedProcessInstances, ignoredItems, OperationType.RETRY);
                    });
                },
            },
        },
    };
    const onShowMessage = (title, successItems, failedItems, ignoredItems, operation) => {
        setModalTitle(title);
        setTitleType("success");
        setOperationType(operation);
        setOperationResults({
            ...operationResults,
            [operation]: {
                ...operationResults[operation],
                successItems: formatForBulkListProcessInstance(successItems),
                failedItems: formatForBulkListProcessInstance(failedItems),
                ignoredItems: formatForBulkListProcessInstance(ignoredItems),
            },
        });
        handleModalToggle();
    };
    const checkboxDropdownToggle = () => {
        setisCheckboxDropdownOpen(!isCheckboxDropdownOpen);
    };
    const onStatusToggle = (isExpandedItem) => {
        setIsExpanded(isExpandedItem);
    };
    const onProcessManagementButtonSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onProcessManagementKebabToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const onSelect = (event, selection) => {
        if (processStates.includes(selection)) {
            const newProcessStates = [...processStates].filter((state) => state !== selection);
            setProcessStates(newProcessStates);
        }
        else {
            setProcessStates([...processStates, selection]);
        }
    };
    const onDeleteChip = async (categoryName, value) => {
        var _a;
        const clonedProcessStates = [...processStates];
        const clonedBusinessKeyArray = [...((_a = filters.businessKey) !== null && _a !== void 0 ? _a : [])];
        switch (categoryName) {
            case Category.STATUS:
                _.remove(clonedProcessStates, (status) => {
                    return status === value;
                });
                setProcessStates(clonedProcessStates);
                setFilters({ ...filters, status: clonedProcessStates });
                break;
            case Category.BUSINESS_KEY:
                _.remove(clonedBusinessKeyArray, (businessKey) => {
                    return businessKey === value;
                });
                setFilters({ ...filters, businessKey: clonedBusinessKeyArray });
                break;
        }
        await applyFilter({
            status: clonedProcessStates,
            businessKey: clonedBusinessKeyArray,
        });
    };
    const onApplyFilter = async () => {
        var _a;
        setBusinessKeyInput("");
        const clonedBusinessKeyArray = [...((_a = filters.businessKey) !== null && _a !== void 0 ? _a : [])];
        if (businessKeyInput && !clonedBusinessKeyArray.includes(businessKeyInput)) {
            clonedBusinessKeyArray.push(businessKeyInput);
        }
        setFilters({
            ...filters,
            status: processStates,
            businessKey: clonedBusinessKeyArray,
        });
        await applyFilter({
            status: processStates,
            businessKey: clonedBusinessKeyArray,
        });
    };
    const onEnterClicked = async (event) => {
        if (event.key === "Enter") {
            businessKeyInput.length > 0 && (await onApplyFilter());
        }
    };
    const resetAllFilters = () => {
        const defaultFilters = {
            status: defaultStatusFilter,
            businessKey: [],
        };
        setProcessStates(defaultFilters.status);
        setFilters(defaultFilters);
        applyFilter(defaultFilters);
    };
    const resetSelected = () => {
        const clonedProcessInstances = _.cloneDeep(processInstances);
        clonedProcessInstances.forEach((processInstance) => {
            var _a;
            processInstance.isSelected = false;
            if (!_.isEmpty(processInstance.childProcessInstances)) {
                (_a = processInstance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                    childInstance.isSelected = false;
                });
            }
        });
        setProcessInstances(clonedProcessInstances);
        setSelectedInstances([]);
        setIsAllChecked(false);
    };
    const handleCheckboxSelectClick = (selection, isCheckBoxClicked) => {
        const clonedProcessInstances = [...processInstances];
        if (selection === BulkSelectionType.NONE) {
            clonedProcessInstances.forEach((instance) => {
                instance.isSelected = false;
                instance.childProcessInstances &&
                    instance.childProcessInstances.length > 0 &&
                    instance.childProcessInstances.forEach((childInstance) => {
                        childInstance.isSelected = false;
                    });
            });
            setSelectedInstances([]);
        }
        if (selection === BulkSelectionType.PARENT) {
            const tempSelectedInstances = [];
            clonedProcessInstances.forEach((instance) => {
                var _a;
                if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                    instance.isSelected = true;
                    tempSelectedInstances.push(instance);
                }
                instance.childProcessInstances &&
                    instance.childProcessInstances.length > 0 &&
                    instance.childProcessInstances.forEach((childInstance) => {
                        childInstance.isSelected = false;
                    });
            });
            setSelectedInstances(tempSelectedInstances);
        }
        if (selection === BulkSelectionType.PARENT_CHILD) {
            const tempSelectedInstances = [];
            if (isAllChecked && isCheckBoxClicked) {
                tempSelectedInstances.length = 0;
                clonedProcessInstances.forEach((instance) => {
                    var _a;
                    if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                        instance.isSelected = false;
                    }
                    instance.childProcessInstances &&
                        instance.childProcessInstances.length > 0 &&
                        instance.childProcessInstances.forEach((childInstance) => {
                            var _a;
                            if (childInstance.serviceUrl && ((_a = childInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                                if (instance.isOpen) {
                                    childInstance.isSelected = false;
                                }
                            }
                        });
                });
            }
            else {
                clonedProcessInstances.forEach((instance) => {
                    var _a;
                    if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                        instance.isSelected = true;
                        tempSelectedInstances.push(instance);
                    }
                    instance.childProcessInstances &&
                        instance.childProcessInstances.length > 0 &&
                        instance.childProcessInstances.forEach((childInstance) => {
                            var _a;
                            if (childInstance.serviceUrl && ((_a = childInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                                if (instance.isOpen) {
                                    childInstance.isSelected = true;
                                    tempSelectedInstances.push(childInstance);
                                }
                            }
                        });
                });
            }
            setSelectedInstances(tempSelectedInstances);
        }
        setProcessInstances(clonedProcessInstances);
    };
    const statusMenuItems = [
        _jsx(SelectOption, { value: "ACTIVE" }, "ACTIVE"),
        _jsx(SelectOption, { value: "COMPLETED" }, "COMPLETED"),
        _jsx(SelectOption, { value: "ERROR" }, "ERROR"),
        _jsx(SelectOption, { value: "ABORTED" }, "ABORTED"),
        _jsx(SelectOption, { value: "SUSPENDED" }, "SUSPENDED"),
    ];
    const checkboxItems = [
        _jsx(DropdownItem, { onClick: () => handleCheckboxSelectClick(BulkSelectionType.NONE, false), id: "none", children: "Select none" }, "none"),
        _jsx(DropdownItem, { onClick: () => handleCheckboxSelectClick(BulkSelectionType.PARENT, false), id: "all-parent", children: "Select all parent processes" }, "all-parent"),
        _jsx(DropdownItem, { onClick: () => handleCheckboxSelectClick(BulkSelectionType.PARENT_CHILD, false), id: "all-parent-child", children: "Select all processes" }, "all-parent-child"),
    ];
    const dropdownItemsProcesManagementButtons = () => {
        return [
            _jsx(DropdownItem, { "data-testid": "multi-abort", onClick: operations[OperationType.ABORT].functions.perform, isDisabled: selectedInstances.length === 0, children: "Abort selected" }, "abort"),
            _jsx(DropdownItem, { "data-testid": "multi-skip", onClick: operations[OperationType.SKIP].functions.perform, isDisabled: selectedInstances.length === 0, children: "Skip selected" }, "skip"),
            _jsx(DropdownItem, { "data-testid": "multi-retry", onClick: operations[OperationType.RETRY].functions.perform, isDisabled: selectedInstances.length === 0, children: "Retry selected" }, "retry"),
        ];
    };
    const buttonItems = (_jsxs(OverflowMenu, { breakpoint: "xl", children: [_jsxs(OverflowMenuContent, { children: [_jsx(OverflowMenuItem, { children: _jsx(Button, { variant: "secondary", onClick: operations[OperationType.ABORT].functions.perform, isDisabled: selectedInstances.length === 0, children: "Abort selected" }) }), _jsx(OverflowMenuItem, { children: _jsx(Button, { variant: "secondary", onClick: operations[OperationType.SKIP].functions.perform, isDisabled: selectedInstances.length === 0, children: "Skip selected" }) }), _jsx(OverflowMenuItem, { children: _jsx(Button, { variant: "secondary", onClick: operations[OperationType.RETRY].functions.perform, isDisabled: selectedInstances.length === 0, children: "Retry selected" }) })] }), _jsx(OverflowMenuControl, { children: _jsx(Dropdown, { onSelect: onProcessManagementButtonSelect, toggle: _jsx(KebabToggle, { onToggle: onProcessManagementKebabToggle }), isOpen: isKebabOpen, isPlain: true, dropdownItems: dropdownItemsProcesManagementButtons() }) })] }));
    const toggleGroupItems = (_jsxs(React.Fragment, { children: [_jsxs(ToolbarGroup, { variant: "filter-group", children: [_jsx(ToolbarItem, { variant: "bulk-select", id: "bulk-select", children: _jsx(Dropdown, { position: DropdownPosition.left, toggle: _jsx(DropdownToggle, { isDisabled: filters.status.length === 0, onToggle: checkboxDropdownToggle, splitButtonItems: [
                                    _jsx(DropdownToggleCheckbox, { id: "select-all-checkbox", "aria-label": "Select all", isChecked: isAllChecked, onChange: () => handleCheckboxSelectClick(BulkSelectionType.PARENT_CHILD, true), isDisabled: filters.status.length === 0 }, "split-checkbox"),
                                ], children: selectedInstances.length === 0 ? "" : selectedInstances.length + " selected" }), dropdownItems: checkboxItems, isOpen: isCheckboxDropdownOpen }) }), _jsx(ToolbarFilter, { chips: filters.status, deleteChip: onDeleteChip, className: "kogito-management-console__state-dropdown-list pf-u-mr-sm", categoryName: "Status", id: "datatoolbar-filter-status", children: _jsx(Select, { variant: SelectVariant.checkbox, "aria-label": "Status", onToggle: onStatusToggle, onSelect: onSelect, selections: processStates, isOpen: isExpanded, placeholderText: "Status", id: "status-select", "data-testid": "status-select", children: statusMenuItems }) }), _jsx(ToolbarFilter, { chips: filters.businessKey, deleteChip: onDeleteChip, categoryName: Category.BUSINESS_KEY, children: _jsx(InputGroup, { children: _jsx(TextInput, { name: "businessKey", id: "businessKey", "data-testid": "businesskey", type: "search", "aria-label": "business key", onChange: setBusinessKeyInput, onKeyPress: onEnterClicked, placeholder: "Filter by business key", value: businessKeyInput }) }) }), _jsx(ToolbarItem, { children: _jsx(Button, { variant: "primary", onClick: onApplyFilter, "data-testid": "apply-filter-button", children: "Apply filter" }) })] }), _jsxs(ToolbarGroup, { children: [_jsx(ToolbarItem, { variant: "separator" }), _jsx(ToolbarGroup, { className: "pf-u-ml-md", id: "process-management-buttons", children: buttonItems })] })] }));
    const toolbarItems = (_jsxs(React.Fragment, { children: [_jsx(ToolbarToggleGroup, { toggleIcon: _jsx(FilterIcon, {}), breakpoint: "xl", children: toggleGroupItems }), _jsx(ToolbarGroup, { variant: "icon-button-group", children: _jsx(ToolbarItem, { children: _jsx(Tooltip, { content: "Refresh", children: _jsx(Button, { variant: "plain", onClick: refresh, "data-testid": "refresh", children: _jsx(SyncIcon, {}) }) }) }) })] }));
    return (_jsxs(_Fragment, { children: [_jsx(ProcessInfoModal, { modalTitle: setTitle(titleType, modalTitle), isModalOpen: isModalOpen, operationResult: operations[operationType], handleModalToggle: handleModalToggle, resetSelected: resetSelected, ouiaId: "operation-result" }), _jsx(Toolbar, { "data-testid": "data-toolbar-with-filter", className: "pf-m-toggle-group-container kogito-management-console__state-dropdown-list", collapseListedFiltersBreakpoint: "xl", clearAllFilters: resetAllFilters, clearFiltersButtonText: "Reset to default", ...componentOuiaProps(ouiaId, "process-list-toolbar", ouiaSafe), children: _jsx(ToolbarContent, { children: toolbarItems }) })] }));
};
export default ProcessListToolbar;
//# sourceMappingURL=ProcessListToolbar.js.map