import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import get from "lodash/get";
import has from "lodash/has";
import isEmpty from "lodash/isEmpty";
import set from "lodash/set";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import EmptyTaskForm from "../EmptyTaskForm/EmptyTaskForm";
import TaskFormRenderer from "../TaskFormRenderer/TaskFormRenderer";
import { parseTaskSchema } from "../utils/TaskFormDataUtils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
var State;
(function (State) {
    State[State["READY"] = 0] = "READY";
    State[State["SUBMITTING"] = 1] = "SUBMITTING";
    State[State["SUBMITTED"] = 2] = "SUBMITTED";
})(State || (State = {}));
export const TaskForm = ({ userTask, schema, driver, phases, ouiaId, ouiaSafe, }) => {
    const [formData, setFormData] = useState(null);
    const [formState, setFormState] = useState(State.READY);
    const [taskFormSchema, setTaskFormSchema] = useState();
    const [taskFormAssignments, setTaskFormAssignments] = useState();
    useEffect(() => {
        const parsedSchema = parseTaskSchema(schema);
        setTaskFormSchema(parsedSchema.schema);
        setTaskFormAssignments(parsedSchema.assignments);
    }, []);
    if (formState === State.SUBMITTING) {
        return (_jsx(Bullseye, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form") + "-submit-spinner", "task-form", true), children: _jsx(KogitoSpinner, { spinnerText: `Submitting for task ${userTask.referenceName} (${userTask.id.substring(0, 5)})` }) }));
    }
    if (formState === State.READY || formState === State.SUBMITTED) {
        const doSubmit = async (phase, data, onSuccess, onFailure) => {
            try {
                setFormState(State.SUBMITTING);
                setFormData(data);
                const payload = {};
                taskFormAssignments.outputs.forEach((output) => {
                    if (has(data, output)) {
                        set(payload, output, get(data, output));
                    }
                });
                const result = await driver.doSubmit(phase, payload);
                if (onSuccess) {
                    onSuccess(result);
                }
            }
            catch (err) {
                if (onFailure) {
                    onFailure(err);
                }
            }
            finally {
                setFormState(State.SUBMITTED);
            }
        };
        if (!taskFormSchema) {
            return (_jsx(Bullseye, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form-") + "-loading-spinner", "task-form", true), children: _jsx(KogitoSpinner, { spinnerText: `Loading Task form...` }) }));
        }
        if (isEmpty(taskFormSchema.properties)) {
            return (_jsx(EmptyTaskForm, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form") + "-empty-form", "task-form", ouiaSafe), userTask: userTask, enabled: formState == State.READY, formSchema: taskFormSchema, submit: (phase) => doSubmit(phase, {}) }));
        }
        return (_jsx(TaskFormRenderer, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form") + "-form-renderer", "task-form", ouiaSafe), userTask: userTask, formSchema: taskFormSchema, formData: formData, enabled: formState == State.READY, phases: phases, submit: doSubmit }));
    }
    return null;
};
export default TaskForm;
//# sourceMappingURL=TaskForm.js.map