#!/usr/bin/env node
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.XSD__TYPES = exports.__XSD_PARSER = void 0;
var fs = require("fs");
var path = require("path");
var xml_parser_ts_1 = require("@kie-tools/xml-parser-ts");
var meta_1 = require("./schemas/xsd-incomplete--manually-written/ts-gen/meta");
var lodash_1 = require("lodash");
exports.__XSD_PARSER = (0, xml_parser_ts_1.getParser)({
    ns: meta_1.ns,
    meta: meta_1.meta,
    subs: {},
    elements: {},
    root: { element: "xsd:schema", type: "schema" },
});
var __LOGS = {
    done: function (location) { return "[xml-parser-ts-codegen] Done for '".concat(location, "'."); },
};
exports.XSD__TYPES = new Map([
    ["xsd:boolean", { type: "primitive", tsEquivalent: "boolean", annotation: "xsd:boolean" }],
    ["xsd:QName", { type: "primitive", tsEquivalent: "string", annotation: "xsd:QName" }],
    ["xsd:string", { type: "primitive", tsEquivalent: "string", annotation: "xsd:string" }],
    ["xsd:int", { type: "primitive", tsEquivalent: "number", annotation: "xsd:int" }],
    ["xsd:integer", { type: "primitive", tsEquivalent: "number", annotation: "xsd:integer" }],
    ["xsd:dateTime", { type: "primitive", tsEquivalent: "string", annotation: "xsd:dateTime" }],
    ["xsd:double", { type: "primitive", tsEquivalent: "number", annotation: "xsd:double" }],
    ["xsd:long", { type: "primitive", tsEquivalent: "number", annotation: "xsd:long" }],
    ["xsd:float", { type: "primitive", tsEquivalent: "number", annotation: "xsd:float" }],
    ["xsd:duration", { type: "primitive", tsEquivalent: "string", annotation: "xsd:duration" }],
    ["xsd:IDREF", { type: "primitive", tsEquivalent: "string", annotation: "xsd:IDREF" }],
    ["xsd:anyURI", { type: "primitive", tsEquivalent: "string", annotation: "xsd:anyURI" }],
    ["xsd:anyType", { type: "primitive", tsEquivalent: "string", annotation: "xsd:antType" }],
    ["xsd:IDREFS", { type: "primitive", tsEquivalent: "string", annotation: "xsd:IDREFS" }],
    ["xsd:ID", { type: "primitive", tsEquivalent: "string", annotation: "xsd:ID" }],
]);
function fetchXsdString(baseLocation, relativeLocation) {
    return __awaiter(this, void 0, void 0, function () {
        var url, p;
        return __generator(this, function (_a) {
            try {
                url = new URL(relativeLocation);
                throw new Error("URLs not yet supported.");
            }
            catch (e) {
                p = path.resolve(baseLocation, relativeLocation);
                return [2, { location: p, xsdString: fs.readFileSync(p) }];
            }
            return [2];
        });
    });
}
function parseDeep(__XSD_PARSER, baseLocation, relativeLocation) {
    return __awaiter(this, void 0, void 0, function () {
        var xsdString, schema, includePromises, importPromises, includes, imports, sameNs, schemaPlusIncludes, sameNs_1, sameNs_1_1, _a, k, v, includesFromOtherNs;
        var e_1, _b;
        var _c, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0: return [4, fetchXsdString(baseLocation, relativeLocation)];
                case 1:
                    xsdString = (_e.sent()).xsdString;
                    schema = __XSD_PARSER.parse({ type: "xml", xml: xsdString }).json;
                    includePromises = ((_c = schema["xsd:schema"]["xsd:include"]) !== null && _c !== void 0 ? _c : []).map(function (i) {
                        return parseDeep(__XSD_PARSER, baseLocation, i["@_schemaLocation"]);
                    });
                    importPromises = ((_d = schema["xsd:schema"]["xsd:import"]) !== null && _d !== void 0 ? _d : []).map(function (i) {
                        return parseDeep(__XSD_PARSER, baseLocation, i["@_schemaLocation"]);
                    });
                    return [4, Promise.all(includePromises)];
                case 2:
                    includes = (_e.sent()).flatMap(function (s) { return s; });
                    return [4, Promise.all(importPromises)];
                case 3:
                    imports = (_e.sent()).flatMap(function (s) { return s; });
                    sameNs = includes.filter(function (_a) {
                        var _b = __read(_a, 2), k = _b[0], v = _b[1];
                        return v["xsd:schema"]["@_targetNamespace"] === schema["xsd:schema"]["@_targetNamespace"];
                    });
                    schemaPlusIncludes = schema;
                    try {
                        for (sameNs_1 = __values(sameNs), sameNs_1_1 = sameNs_1.next(); !sameNs_1_1.done; sameNs_1_1 = sameNs_1.next()) {
                            _a = __read(sameNs_1_1.value, 2), k = _a[0], v = _a[1];
                            schemaPlusIncludes = (0, lodash_1.mergeWith)(schemaPlusIncludes, v, function (a, b) {
                                if (Array.isArray(a) && Array.isArray(b)) {
                                    return __spreadArray(__spreadArray([], __read(a), false), __read(b), false);
                                }
                            });
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (sameNs_1_1 && !sameNs_1_1.done && (_b = sameNs_1.return)) _b.call(sameNs_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    includesFromOtherNs = includes.filter(function (_a) {
                        var _b = __read(_a, 2), k = _b[0], v = _b[1];
                        return v["xsd:schema"]["@_targetNamespace"] !== schema["xsd:schema"]["@_targetNamespace"];
                    });
                    return [2, __spreadArray(__spreadArray([[relativeLocation, schema]], __read(imports), false), __read(includesFromOtherNs), false)];
            }
        });
    });
}
function main() {
    return __awaiter(this, void 0, void 0, function () {
        var __LOCATION, __ROOT_ELEMENT_NAME, __BASE_LOCATION, __RELATIVE_LOCATION, __ROOT_ELEMENT, __RELATIVE_LOCATION_WITHOUT_EXTENSION, __CONVENTIONS, __XSDS, _a, __SIMPLE_TYPES, __COMPLEX_TYPES, _loop_1, _b, _c, _d, location_1, xsd, __GLOBAL_ELEMENTS, _e, _f, _g, location_2, xsd, _h, _j, e, a, __SUBSTITUTIONS, _k, _l, _m, baseLoc, _1, xsds, _o, _p, _q, _r, xLocation, xsd, localizedSubstitutions, _s, _t, e, subsGroup, elem, localizedElementName, accumulatedSubstitutionElements, e_2_1, __NAMED_TYPES_BY_TS_NAME, __META_TYPE_MAPPING, rootTsTypeName, ts, __SIMPLE_TYPES_1, __SIMPLE_TYPES_1_1, sp, enumName, __COMPLEX_TYPES_1, __COMPLEX_TYPES_1_1, ct, typeName, _u, metaProperties, needsExtensionType, anonymousTypes, properties, doc, anonymousTypesString, rootElementBaseType, rootElementBaseType, meta;
        var e_3, _v, e_4, _w, e_5, _x, e_2, _y, e_6, _z, e_7, _0, e_8, _1, e_9, _2;
        var _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27;
        return __generator(this, function (_28) {
            switch (_28.label) {
                case 0:
                    __LOCATION = process.argv[2];
                    __ROOT_ELEMENT_NAME = process.argv[3];
                    __BASE_LOCATION = path.dirname(__LOCATION);
                    __RELATIVE_LOCATION = path.basename(__LOCATION);
                    __ROOT_ELEMENT = "".concat(__RELATIVE_LOCATION, "__").concat(__ROOT_ELEMENT_NAME);
                    __RELATIVE_LOCATION_WITHOUT_EXTENSION = __RELATIVE_LOCATION.replace(path.extname(__RELATIVE_LOCATION), "");
                    __CONVENTIONS = {
                        outputFileForGeneratedTypes: path.resolve(".", path.join(__BASE_LOCATION, "ts-gen/types.ts")),
                        outputFileForGeneratedMeta: path.resolve(".", path.join(__BASE_LOCATION, "ts-gen/meta.ts")),
                    };
                    _a = Map.bind;
                    return [4, parseDeep(exports.__XSD_PARSER, __BASE_LOCATION, __RELATIVE_LOCATION)];
                case 1:
                    __XSDS = new (_a.apply(Map, [void 0, _28.sent()]))();
                    __SIMPLE_TYPES = Array.from(__XSDS.entries()).flatMap(function (_a) {
                        var _b = __read(_a, 2), location = _b[0], schema = _b[1];
                        return (schema["xsd:schema"]["xsd:simpleType"] || []).flatMap(function (s) {
                            var _a, _b;
                            if (s["xsd:union"]) {
                                if (s["xsd:union"]["@_memberTypes"] === "xsd:anyURI") {
                                    return [
                                        {
                                            comment: "xsd:anyURI",
                                            type: "simple",
                                            kind: "enum",
                                            name: (_a = s["@_name"]) !== null && _a !== void 0 ? _a : s["@_name"],
                                            declaredAtRelativeLocation: location,
                                            values: [],
                                        },
                                    ];
                                }
                                return ((_b = s["xsd:union"]["xsd:simpleType"]) !== null && _b !== void 0 ? _b : []).flatMap(function (ss) {
                                    return xsdSimpleTypeToXptcSimpleType(ss, location, s["@_name"]);
                                });
                            }
                            else {
                                return xsdSimpleTypeToXptcSimpleType(s, location, s["@_name"]);
                            }
                        });
                    });
                    __COMPLEX_TYPES = [];
                    _loop_1 = function (location_1, xsd) {
                        var e_10, _29;
                        var _loop_2 = function (xsdCt) {
                            var isAbstract = (_3 = xsdCt["@_abstract"]) !== null && _3 !== void 0 ? _3 : false;
                            var extensionElement = (_5 = (_4 = xsdCt["xsd:complexContent"]) === null || _4 === void 0 ? void 0 : _4["xsd:extension"]) !== null && _5 !== void 0 ? _5 : (_6 = xsdCt["xsd:simpleContent"]) === null || _6 === void 0 ? void 0 : _6["xsd:extension"];
                            __COMPLEX_TYPES.push({
                                type: "complex",
                                comment: isAbstract ? "abstract" : "",
                                isAbstract: isAbstract,
                                isAnonymous: false,
                                name: xsdCt["@_name"],
                                isSimpleContent: !!xsdCt["xsd:simpleContent"],
                                needsExtensionType: !!xsdCt["xsd:anyAttribute"] || !!((_7 = xsdCt["xsd:sequence"]) === null || _7 === void 0 ? void 0 : _7["xsd:any"]),
                                declaredAtRelativeLocation: location_1,
                                childOf: extensionElement === null || extensionElement === void 0 ? void 0 : extensionElement["@_base"],
                                elements: __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], __read(((_9 = (_8 = xsdCt["xsd:all"]) === null || _8 === void 0 ? void 0 : _8["xsd:element"]) !== null && _9 !== void 0 ? _9 : []).map(function (s) {
                                    return xsdElementToXptcElement(xsdCt["@_name"], s, location_1);
                                })), false), __read(((_11 = (_10 = xsdCt["xsd:sequence"]) === null || _10 === void 0 ? void 0 : _10["xsd:element"]) !== null && _11 !== void 0 ? _11 : []).map(function (s) {
                                    return xsdElementToXptcElement(xsdCt["@_name"], s, location_1);
                                })), false), __read(((_13 = (_12 = extensionElement === null || extensionElement === void 0 ? void 0 : extensionElement["xsd:sequence"]) === null || _12 === void 0 ? void 0 : _12["xsd:element"]) !== null && _13 !== void 0 ? _13 : []).map(function (s) {
                                    return xsdElementToXptcElement(xsdCt["@_name"], s, location_1);
                                })), false), __read(((_16 = (_15 = (_14 = extensionElement === null || extensionElement === void 0 ? void 0 : extensionElement["xsd:sequence"]) === null || _14 === void 0 ? void 0 : _14["xsd:choice"]) === null || _15 === void 0 ? void 0 : _15["xsd:element"]) !== null && _16 !== void 0 ? _16 : []).map(function (s) {
                                    return xsdElementToXptcElement(xsdCt["@_name"], s, location_1, { forceOptional: true });
                                })), false), __read(((_18 = (_17 = extensionElement === null || extensionElement === void 0 ? void 0 : extensionElement["xsd:choice"]) === null || _17 === void 0 ? void 0 : _17["xsd:element"]) !== null && _18 !== void 0 ? _18 : []).map(function (s) {
                                    return xsdElementToXptcElement(xsdCt["@_name"], s, location_1, { forceOptional: true });
                                })), false), __read(((_21 = (_20 = (_19 = extensionElement === null || extensionElement === void 0 ? void 0 : extensionElement["xsd:choice"]) === null || _19 === void 0 ? void 0 : _19["xsd:sequence"]) === null || _20 === void 0 ? void 0 : _20["xsd:element"]) !== null && _21 !== void 0 ? _21 : []).map(function (s) {
                                    return xsdElementToXptcElement(xsdCt["@_name"], s, location_1, { forceOptional: true });
                                })), false),
                                attributes: __spreadArray(__spreadArray([], __read(((_22 = xsdCt["xsd:attribute"]) !== null && _22 !== void 0 ? _22 : []).map(function (a) { return xsdAttributeToXptcAttribute(a); })), false), __read(((_23 = extensionElement === null || extensionElement === void 0 ? void 0 : extensionElement["xsd:attribute"]) !== null && _23 !== void 0 ? _23 : []).map(function (a) { return xsdAttributeToXptcAttribute(a); })), false),
                            });
                        };
                        try {
                            for (var _30 = (e_10 = void 0, __values(xsd["xsd:schema"]["xsd:complexType"] || [])), _31 = _30.next(); !_31.done; _31 = _30.next()) {
                                var xsdCt = _31.value;
                                _loop_2(xsdCt);
                            }
                        }
                        catch (e_10_1) { e_10 = { error: e_10_1 }; }
                        finally {
                            try {
                                if (_31 && !_31.done && (_29 = _30.return)) _29.call(_30);
                            }
                            finally { if (e_10) throw e_10.error; }
                        }
                    };
                    try {
                        for (_b = __values(__XSDS.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
                            _d = __read(_c.value, 2), location_1 = _d[0], xsd = _d[1];
                            _loop_1(location_1, xsd);
                        }
                    }
                    catch (e_3_1) { e_3 = { error: e_3_1 }; }
                    finally {
                        try {
                            if (_c && !_c.done && (_v = _b.return)) _v.call(_b);
                        }
                        finally { if (e_3) throw e_3.error; }
                    }
                    __GLOBAL_ELEMENTS = new Map();
                    try {
                        for (_e = __values(__XSDS.entries()), _f = _e.next(); !_f.done; _f = _e.next()) {
                            _g = __read(_f.value, 2), location_2 = _g[0], xsd = _g[1];
                            try {
                                for (_h = (e_5 = void 0, __values(xsd["xsd:schema"]["xsd:element"] || [])), _j = _h.next(); !_j.done; _j = _h.next()) {
                                    e = _j.value;
                                    a = xsdElementToXptcElement("GLOBAL", __assign(__assign({}, e), { "@_minOccurs": 0, "@_maxOccurs": "unbounded" }), location_2, {
                                        forceOptional: false,
                                    });
                                    __GLOBAL_ELEMENTS.set("".concat(location_2, "__").concat(e["@_name"]), {
                                        name: e["@_name"],
                                        isAbstract: (_24 = e["@_abstract"]) !== null && _24 !== void 0 ? _24 : false,
                                        substitutionGroup: e["@_substitutionGroup"],
                                        type: e["@_type"],
                                        declaredAtRelativeLocation: location_2,
                                        anonymousType: a.kind === "ofAnonymousType" ? a.anonymousType : undefined,
                                    });
                                }
                            }
                            catch (e_5_1) { e_5 = { error: e_5_1 }; }
                            finally {
                                try {
                                    if (_j && !_j.done && (_x = _h.return)) _x.call(_h);
                                }
                                finally { if (e_5) throw e_5.error; }
                            }
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (_f && !_f.done && (_w = _e.return)) _w.call(_e);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                    __SUBSTITUTIONS = new Map();
                    _28.label = 2;
                case 2:
                    _28.trys.push([2, 7, 8, 9]);
                    _k = __values(__XSDS.entries()), _l = _k.next();
                    _28.label = 3;
                case 3:
                    if (!!_l.done) return [3, 6];
                    _m = __read(_l.value, 2), baseLoc = _m[0], _1 = _m[1];
                    _o = Map.bind;
                    return [4, parseDeep(exports.__XSD_PARSER, __BASE_LOCATION, baseLoc)];
                case 4:
                    xsds = new (_o.apply(Map, [void 0, _28.sent()]))();
                    try {
                        for (_p = (e_6 = void 0, __values(xsds.entries())), _q = _p.next(); !_q.done; _q = _p.next()) {
                            _r = __read(_q.value, 2), xLocation = _r[0], xsd = _r[1];
                            localizedSubstitutions = (_25 = __SUBSTITUTIONS.get(xLocation)) !== null && _25 !== void 0 ? _25 : new Map();
                            __SUBSTITUTIONS.set(xLocation, localizedSubstitutions);
                            try {
                                for (_s = (e_7 = void 0, __values(xsd["xsd:schema"]["xsd:element"] || [])), _t = _s.next(); !_t.done; _t = _s.next()) {
                                    e = _t.value;
                                    if (e["@_substitutionGroup"]) {
                                        subsGroup = getXptcElementFromLocalElementRef(__XSDS, __GLOBAL_ELEMENTS, xLocation, e["@_substitutionGroup"]);
                                        if (!subsGroup) {
                                            throw new Error("Invalid subsitution group for element '".concat(e["@_name"], "'"));
                                        }
                                        elem = getXptcElementFromLocalElementRef(__XSDS, __GLOBAL_ELEMENTS, xLocation, e["@_name"]);
                                        if (!elem) {
                                            throw new Error("Invalid element '".concat(e["@_name"], "'"));
                                        }
                                        localizedElementName = "".concat(subsGroup.declaredAtRelativeLocation, "__").concat(subsGroup.name);
                                        accumulatedSubstitutionElements = new Set(__spreadArray(__spreadArray([], __read(((_26 = localizedSubstitutions.get(localizedElementName)) !== null && _26 !== void 0 ? _26 : [])), false), [
                                            "".concat(xLocation, "__").concat(elem.name),
                                        ], false));
                                        localizedSubstitutions.set(localizedElementName, __spreadArray([], __read(accumulatedSubstitutionElements), false));
                                    }
                                }
                            }
                            catch (e_7_1) { e_7 = { error: e_7_1 }; }
                            finally {
                                try {
                                    if (_t && !_t.done && (_0 = _s.return)) _0.call(_s);
                                }
                                finally { if (e_7) throw e_7.error; }
                            }
                        }
                    }
                    catch (e_6_1) { e_6 = { error: e_6_1 }; }
                    finally {
                        try {
                            if (_q && !_q.done && (_z = _p.return)) _z.call(_p);
                        }
                        finally { if (e_6) throw e_6.error; }
                    }
                    _28.label = 5;
                case 5:
                    _l = _k.next();
                    return [3, 3];
                case 6: return [3, 9];
                case 7:
                    e_2_1 = _28.sent();
                    e_2 = { error: e_2_1 };
                    return [3, 9];
                case 8:
                    try {
                        if (_l && !_l.done && (_y = _k.return)) _y.call(_k);
                    }
                    finally { if (e_2) throw e_2.error; }
                    return [7];
                case 9:
                    Array.from(__GLOBAL_ELEMENTS.values()).forEach(function (e) {
                        if (!e.anonymousType) {
                            return;
                        }
                        else {
                            __COMPLEX_TYPES.push(e.anonymousType);
                        }
                    });
                    __NAMED_TYPES_BY_TS_NAME = new Map(__spreadArray(__spreadArray([], __read(__SIMPLE_TYPES.map(function (st) { return [getTsNameFromNamedType(st.declaredAtRelativeLocation, st.name), st]; })), false), __read(__COMPLEX_TYPES.map(function (ct) {
                        if (ct.isAnonymous) {
                            var name_1 = getAnonymousMetaTypeName(ct.forElementWithName, "GLOBAL");
                            return [getTsNameFromNamedType(ct.declaredAtRelativeLocation, name_1), ct];
                        }
                        else {
                            return [getTsNameFromNamedType(ct.declaredAtRelativeLocation, ct.name), ct];
                        }
                    })), false));
                    __META_TYPE_MAPPING = new Map();
                    rootTsTypeName = getTsNameFromNamedType(__RELATIVE_LOCATION_WITHOUT_EXTENSION, (_27 = __GLOBAL_ELEMENTS.get(__ROOT_ELEMENT).type) !== null && _27 !== void 0 ? _27 : getAnonymousMetaTypeName(__ROOT_ELEMENT_NAME, "GLOBAL"));
                    ts = "";
                    try {
                        for (__SIMPLE_TYPES_1 = __values(__SIMPLE_TYPES), __SIMPLE_TYPES_1_1 = __SIMPLE_TYPES_1.next(); !__SIMPLE_TYPES_1_1.done; __SIMPLE_TYPES_1_1 = __SIMPLE_TYPES_1.next()) {
                            sp = __SIMPLE_TYPES_1_1.value;
                            if (sp.kind === "int") {
                                continue;
                            }
                            enumName = getTsNameFromNamedType(sp.declaredAtRelativeLocation, sp.name);
                            if (sp.comment === "xsd:anyURI") {
                                ts += "\nexport type ".concat(enumName, " = string; // ").concat(sp.comment, "\n");
                            }
                            else if (sp.kind === "enum") {
                                ts += "\nexport type ".concat(enumName, " = |\n").concat(sp.values.map(function (v) { return "    '".concat(v, "'"); }).join(" |\n"), "\n");
                            }
                        }
                    }
                    catch (e_8_1) { e_8 = { error: e_8_1 }; }
                    finally {
                        try {
                            if (__SIMPLE_TYPES_1_1 && !__SIMPLE_TYPES_1_1.done && (_1 = __SIMPLE_TYPES_1.return)) _1.call(__SIMPLE_TYPES_1);
                        }
                        finally { if (e_8) throw e_8.error; }
                    }
                    try {
                        for (__COMPLEX_TYPES_1 = __values(__COMPLEX_TYPES), __COMPLEX_TYPES_1_1 = __COMPLEX_TYPES_1.next(); !__COMPLEX_TYPES_1_1.done; __COMPLEX_TYPES_1_1 = __COMPLEX_TYPES_1.next()) {
                            ct = __COMPLEX_TYPES_1_1.value;
                            typeName = getTsNameFromNamedType(ct.declaredAtRelativeLocation, ct.isAnonymous ? getAnonymousMetaTypeName(ct.forElementWithName, "GLOBAL") : ct.name);
                            _u = getMetaProperties(__RELATIVE_LOCATION, __META_TYPE_MAPPING, __GLOBAL_ELEMENTS, __SUBSTITUTIONS, __XSDS, __NAMED_TYPES_BY_TS_NAME, ct, typeName), metaProperties = _u.metaProperties, needsExtensionType = _u.needsExtensionType, anonymousTypes = _u.anonymousTypes;
                            properties = metaProperties
                                .map(function (p) {
                                var _a, _b;
                                var optionalMarker = p.isOptional ? "?" : "";
                                var arrayMarker = p.isArray ? "[]" : "";
                                var tsType = p.metaType.name === "integer" || p.metaType.name === "float" || p.metaType.name === "long"
                                    ? "number"
                                    : p.metaType.name;
                                var ns = getMetaPropertyNs(__RELATIVE_LOCATION, p);
                                return "    \"".concat(ns).concat(p.name, "\"").concat(optionalMarker, ": ").concat((_b = (_a = p.typeBody) === null || _a === void 0 ? void 0 : _a.call(p, tsType)) !== null && _b !== void 0 ? _b : tsType).concat(arrayMarker, "; // from type ").concat(p.fromType, " @ ").concat(p.declaredAt);
                            })
                                .join("\n");
                            doc = ct.comment.trim() ? "/* ".concat(ct.comment, " */") : "";
                            anonymousTypesString = anonymousTypes
                                .map(function (anonType) {
                                var anonymousTypesProperties = anonType.properties.map(function (p) {
                                    return "    \"".concat(p.name, "\": ").concat(p.metaType.name === "integer" || p.metaType.name === "float" || p.metaType.name === "long"
                                        ? "number"
                                        : p.metaType.name, ";");
                                });
                                return "export interface ".concat(anonType.name, " {\n    __?: undefined;\n").concat(anonymousTypesProperties.join("\n"), "\n}");
                            })
                                .join("\n");
                            if (needsExtensionType) {
                                rootElementBaseType = rootTsTypeName === typeName ? "extends XmlParserTsRootElementBaseType" : "";
                                ts += "\nexport interface ".concat(typeName, " ").concat(rootElementBaseType, " ").concat(doc, " {\n    __?: undefined;\n").concat(properties, "\n}\n\n").concat(anonymousTypesString, "\n");
                            }
                            else {
                                rootElementBaseType = rootTsTypeName === typeName ? "XmlParserTsRootElementBaseType & " : "";
                                ts += "\nexport type ".concat(typeName, " = ").concat(rootElementBaseType, " ").concat(doc, " {\n").concat(properties, "\n}\n\n").concat(anonymousTypesString, "\n");
                            }
                        }
                    }
                    catch (e_9_1) { e_9 = { error: e_9_1 }; }
                    finally {
                        try {
                            if (__COMPLEX_TYPES_1_1 && !__COMPLEX_TYPES_1_1.done && (_2 = __COMPLEX_TYPES_1.return)) _2.call(__COMPLEX_TYPES_1);
                        }
                        finally { if (e_9) throw e_9.error; }
                    }
                    ts = "import { XmlParserTsRootElementBaseType } from \"@kie-tools/xml-parser-ts\"\n\n  ".concat(ts, "\n  ");
                    ts = "// This file was automatically generated\n  \n".concat(ts, "\n  ");
                    fs.mkdirSync(path.dirname(__CONVENTIONS.outputFileForGeneratedTypes), { recursive: true });
                    fs.writeFileSync(__CONVENTIONS.outputFileForGeneratedTypes, ts);
                    meta = "\nexport const root = {\n    element: \"".concat(getRealtiveLocationNs(__RELATIVE_LOCATION, __RELATIVE_LOCATION) + __ROOT_ELEMENT_NAME, "\",\n    type: \"").concat(rootTsTypeName, "\" \n} as const;\n\nexport const ns = new Map<string, string>([\n").concat(__spreadArray([], __read(__XSDS.entries()), false).map(function (_a) {
                        var _b = __read(_a, 2), k = _b[0], v = _b[1];
                        var uri = v["xsd:schema"]["@_targetNamespace"];
                        var ns = getRealtiveLocationNs(__RELATIVE_LOCATION, k);
                        return "    [\"".concat(uri, "\", \"").concat(ns, "\"],\n    [\"").concat(ns, "\", \"").concat(uri, "\"],");
                    })
                        .join("\n"), "\n]);\n\nexport const subs = {\n").concat(Array.from(__SUBSTITUTIONS.entries())
                        .map(function (_a) {
                        var _b = __read(_a, 2), namespace = _b[0], subs = _b[1];
                        return "  \"".concat(getRealtiveLocationNs(__RELATIVE_LOCATION, namespace), "\": {\n").concat(Array.from(subs.entries())
                            .map(function (_a) {
                            var _b = __read(_a, 2), head = _b[0], elements = _b[1];
                            return "".concat(elements
                                .map(function (e) {
                                var elementName = "".concat(getRealtiveLocationNs(__RELATIVE_LOCATION, e.split("__")[0]) + e.split("__")[1]);
                                var headName = "".concat(getRealtiveLocationNs(__RELATIVE_LOCATION, head.split("__")[0]) + head.split("__")[1]);
                                return "    \"".concat(elementName, "\": \"").concat(headName, "\",");
                            })
                                .join("\n"));
                        })
                            .join("\n"), "\n  },");
                    })
                        .join("\n"), "\n};\n\nexport const elements = {\n").concat(Array.from(__GLOBAL_ELEMENTS.entries())
                        .map(function (_a) {
                        var _b;
                        var _c = __read(_a, 2), k = _c[0], v = _c[1];
                        var s = ((_b = v.type) === null || _b === void 0 ? void 0 : _b.split(":")) || [getAnonymousMetaTypeName(v.name, "GLOBAL")];
                        var elementName = "".concat(getRealtiveLocationNs(__RELATIVE_LOCATION, k.split("__")[0])).concat(v.name);
                        var elementType = "".concat(getTsNameFromNamedType(v.declaredAtRelativeLocation, s.length === 1 ? s[0] : s[1]));
                        return "  \"".concat(elementName, "\": \"").concat(elementType, "\",");
                    })
                        .join("\n"), "\n};\n\nexport const meta = {\n");
                    Array.from(__META_TYPE_MAPPING.entries()).forEach(function (_a) {
                        var _b = __read(_a, 2), name = _b[0], type = _b[1];
                        meta += "    \"".concat(name, "\": {\n");
                        type.properties.forEach(function (p) {
                            var ns = getMetaPropertyNs(__RELATIVE_LOCATION, p);
                            meta += "        \"".concat(ns).concat(p.name, "\": { type: \"").concat(p.metaType.name, "\", isArray: ").concat(p.isArray, ", fromType: \"").concat(p.fromType, "\", xsdType: \"").concat(p.metaType.xsdType, "\" },\n");
                        });
                        meta += "    },\n";
                    });
                    meta += "} as const;\n";
                    fs.mkdirSync(path.dirname(__CONVENTIONS.outputFileForGeneratedMeta), { recursive: true });
                    fs.writeFileSync(__CONVENTIONS.outputFileForGeneratedMeta, meta);
                    console.log(__LOGS.done(__LOCATION));
                    return [2];
            }
        });
    });
}
main();
function getMetaPropertyNs(__RELATIVE_LOCATION, p) {
    var _a, _b;
    return p.name.startsWith("@_")
        ? ""
        : getRealtiveLocationNs(__RELATIVE_LOCATION, (_b = (_a = p.elem) === null || _a === void 0 ? void 0 : _a.declaredAtRelativeLocation) !== null && _b !== void 0 ? _b : p.declaredAt);
}
function getRealtiveLocationNs(__RELATIVE_LOCATION, relativeLocation) {
    return relativeLocation === __RELATIVE_LOCATION
        ? ""
        : "".concat(relativeLocation.replace(".xsd", "").toLocaleLowerCase().replaceAll(/\d/g, ""), ":");
}
function resolveElementRef(__GLOBAL_ELEMENTS, __XSDS, substitutions, referencedElement) {
    var key = "".concat(referencedElement.declaredAtRelativeLocation, "__").concat(referencedElement.name);
    var substitutionNamesForReferencedElement = substitutions.get(key);
    if (!substitutionNamesForReferencedElement) {
        return [referencedElement];
    }
    return substitutionNamesForReferencedElement.flatMap(function (substitutionElementName) {
        var substitutionElement = __GLOBAL_ELEMENTS.get(substitutionElementName);
        if (!substitutionElement) {
            throw new Error("Can't find element '".concat(substitutionElementName, "' for substitution ").concat(key));
        }
        return resolveElementRef(__GLOBAL_ELEMENTS, __XSDS, substitutions, substitutionElement);
    });
}
function getMetaTypeName(_a) {
    var name = _a.name, annotation = _a.annotation;
    return name === "number" ? (annotation === "xsd:double" || annotation === "xsd:float" ? "float" : "integer") : name;
}
function getTypeBodyForElementRef(__RELATIVE_LOCATION, __META_TYPE_MAPPING, __GLOBAL_ELEMENTS, __SUBSTITUTIONS, __XSDS, __NAMED_TYPES_BY_TS_NAME, ct, referencedElement) {
    var resolutions = resolveElementRef(__GLOBAL_ELEMENTS, __XSDS, __SUBSTITUTIONS.get(ct.declaredAtRelativeLocation), referencedElement);
    if (resolutions.length === 1 && resolutions[0] === referencedElement) {
        return undefined;
    }
    return "( /* From subsitution groups */\n".concat(resolutions
        .flatMap(function (element) {
        var _a;
        var elementNs = getRealtiveLocationNs(__RELATIVE_LOCATION, element.declaredAtRelativeLocation);
        var elementName = "".concat(elementNs).concat(element.name);
        return [
            "        ({ __$$element: \"".concat(elementName, "\" } & ").concat(getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, (_a = element.type) !== null && _a !== void 0 ? _a : getAnonymousMetaTypeName(element.name, "GLOBAL")).name, ")"),
        ];
    })
        .join(" |\n"), "\n    )");
}
function getMetaProperties(__RELATIVE_LOCATION, __META_TYPE_MAPPING, __GLOBAL_ELEMENTS, __SUBSTITUTIONS, __XSDS, __NAMED_TYPES_BY_TS_NAME, ct, metaTypeName) {
    var e_11, _a, e_12, _b, e_13, _c, e_14, _d;
    var ctMetaProperties = [];
    var anonymousTypes = [];
    var immediateParentType = ct.childOf
        ? getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, ct.childOf)
        : undefined;
    var curParentCt = immediateParentType ? __NAMED_TYPES_BY_TS_NAME.get(immediateParentType.name) : undefined;
    var needsExtensionType = ct.needsExtensionType;
    while (curParentCt) {
        var curParentCtMetaProperties = [];
        if ((curParentCt === null || curParentCt === void 0 ? void 0 : curParentCt.type) === "complex") {
            var curParentCtMetaTypeName = getTsNameFromNamedType(curParentCt.declaredAtRelativeLocation, curParentCt.isAnonymous ? getAnonymousMetaTypeName(curParentCt.forElementWithName, "GLOBAL") : curParentCt.name);
            needsExtensionType = needsExtensionType || curParentCt.needsExtensionType;
            if (curParentCt.isAnonymous) {
                throw new Error("Anonymous types are never parent types.");
            }
            try {
                for (var _e = (e_11 = void 0, __values(curParentCt.attributes)), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var a = _f.value;
                    var attributeType = getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, curParentCt.declaredAtRelativeLocation, a.localTypeRef);
                    if (!attributeType) {
                        throw new Error("Can't resolve local type ref ".concat(a.localTypeRef));
                    }
                    curParentCtMetaProperties.push({
                        declaredAt: curParentCt.declaredAtRelativeLocation,
                        fromType: curParentCtMetaTypeName,
                        elem: undefined,
                        name: "@_".concat(a.name),
                        metaType: { name: getMetaTypeName(attributeType), xsdType: attributeType.annotation },
                        isArray: false,
                        isOptional: a.isOptional,
                    });
                }
            }
            catch (e_11_1) { e_11 = { error: e_11_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
                }
                finally { if (e_11) throw e_11.error; }
            }
            var _loop_3 = function (e) {
                if (e.kind === "ofAnonymousType") {
                    var anonymousTypeName = getAnonymousMetaTypeName(e.name, metaTypeName);
                    var mp = getMetaProperties(__RELATIVE_LOCATION, __META_TYPE_MAPPING, __GLOBAL_ELEMENTS, __SUBSTITUTIONS, __XSDS, __NAMED_TYPES_BY_TS_NAME, e.anonymousType, anonymousTypeName);
                    anonymousTypes.push({ name: anonymousTypeName, properties: mp.metaProperties });
                    anonymousTypes.push.apply(anonymousTypes, __spreadArray([], __read(mp.anonymousTypes), false));
                    __META_TYPE_MAPPING.set(anonymousTypeName, {
                        name: anonymousTypeName,
                        properties: mp.metaProperties,
                    });
                    curParentCtMetaProperties.push({
                        elem: undefined,
                        declaredAt: curParentCt.declaredAtRelativeLocation,
                        fromType: curParentCtMetaTypeName,
                        name: e.name,
                        metaType: { name: anonymousTypeName, xsdType: "Anonumous type..." },
                        isArray: e.isArray,
                        isOptional: e.isOptional,
                    });
                }
                else if (e.kind === "ofNamedType") {
                    var tsType = getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, e.typeName);
                    curParentCtMetaProperties.push({
                        declaredAt: curParentCt.declaredAtRelativeLocation,
                        fromType: curParentCtMetaTypeName,
                        elem: undefined,
                        name: e.name,
                        metaType: { name: getMetaTypeName(tsType), xsdType: tsType.annotation },
                        typeBody: getTsTypeBody(tsType),
                        isArray: e.isArray,
                        isOptional: e.isOptional,
                    });
                }
                else if (e.kind === "ofRef") {
                    var referencedElement_1 = getXptcElementFromLocalElementRef(__XSDS, __GLOBAL_ELEMENTS, ct.declaredAtRelativeLocation, e.ref);
                    if (!referencedElement_1) {
                        throw new Error("Can't find reference to element '".concat(e.ref, "'"));
                    }
                    var tsType = referencedElement_1.type
                        ? getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, referencedElement_1.type)
                        : {
                            name: getTsNameFromNamedType(ct.declaredAtRelativeLocation, getAnonymousMetaTypeName(referencedElement_1.name, "GLOBAL")),
                            annotation: "Anonymous type from element " + referencedElement_1.name,
                        };
                    curParentCtMetaProperties.push({
                        declaredAt: referencedElement_1 === null || referencedElement_1 === void 0 ? void 0 : referencedElement_1.declaredAtRelativeLocation,
                        fromType: ct.isAnonymous ? "" : curParentCtMetaTypeName,
                        name: referencedElement_1.name,
                        elem: referencedElement_1,
                        metaType: { name: getMetaTypeName(tsType), xsdType: tsType.annotation },
                        typeBody: function () {
                            return getTypeBodyForElementRef(__RELATIVE_LOCATION, __META_TYPE_MAPPING, __GLOBAL_ELEMENTS, __SUBSTITUTIONS, __XSDS, __NAMED_TYPES_BY_TS_NAME, ct, referencedElement_1);
                        },
                        isArray: e.isArray,
                        isOptional: e.isOptional,
                    });
                }
                else {
                    throw new Error("Unknonwn type of element " + e);
                }
            };
            try {
                for (var _g = (e_12 = void 0, __values(curParentCt.elements)), _h = _g.next(); !_h.done; _h = _g.next()) {
                    var e = _h.value;
                    _loop_3(e);
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
                }
                finally { if (e_12) throw e_12.error; }
            }
            var nextParentType = curParentCt.childOf
                ? getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, curParentCt.declaredAtRelativeLocation, curParentCt.childOf)
                : undefined;
            ctMetaProperties = __spreadArray(__spreadArray([], __read(curParentCtMetaProperties), false), __read(ctMetaProperties), false);
            curParentCt = nextParentType ? __NAMED_TYPES_BY_TS_NAME.get(nextParentType.name) : undefined;
        }
        else if ((curParentCt === null || curParentCt === void 0 ? void 0 : curParentCt.type) === "simple") {
            throw new Error("Can't have a non-complex type as parent of another.");
        }
        else {
            curParentCt = undefined;
        }
    }
    try {
        for (var _j = __values(ct.attributes), _k = _j.next(); !_k.done; _k = _j.next()) {
            var a = _k.value;
            var attributeType = getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, a.localTypeRef);
            ctMetaProperties.push({
                declaredAt: ct.declaredAtRelativeLocation,
                fromType: metaTypeName,
                name: "@_".concat(a.name),
                elem: undefined,
                metaType: { name: getMetaTypeName(attributeType), xsdType: attributeType.annotation },
                isArray: false,
                isOptional: a.isOptional,
            });
        }
    }
    catch (e_13_1) { e_13 = { error: e_13_1 }; }
    finally {
        try {
            if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
        }
        finally { if (e_13) throw e_13.error; }
    }
    var _loop_4 = function (e) {
        if (e.kind === "ofRef") {
            var referencedElement_2 = getXptcElementFromLocalElementRef(__XSDS, __GLOBAL_ELEMENTS, ct.declaredAtRelativeLocation, e.ref);
            if (!referencedElement_2) {
                throw new Error("Can't find reference to element '".concat(e.ref, "'"));
            }
            var tsType = referencedElement_2.type
                ? getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, referencedElement_2.type)
                : {
                    name: getTsNameFromNamedType(ct.declaredAtRelativeLocation, getAnonymousMetaTypeName(referencedElement_2.name, "GLOBAL")),
                    annotation: "Anonymous type from element " + referencedElement_2.name,
                };
            ctMetaProperties.push({
                declaredAt: referencedElement_2 === null || referencedElement_2 === void 0 ? void 0 : referencedElement_2.declaredAtRelativeLocation,
                fromType: ct.isAnonymous ? "" : metaTypeName,
                name: referencedElement_2.name,
                elem: referencedElement_2,
                metaType: { name: getMetaTypeName(tsType), xsdType: tsType.annotation },
                typeBody: function () {
                    return getTypeBodyForElementRef(__RELATIVE_LOCATION, __META_TYPE_MAPPING, __GLOBAL_ELEMENTS, __SUBSTITUTIONS, __XSDS, __NAMED_TYPES_BY_TS_NAME, ct, referencedElement_2);
                },
                isArray: e.isArray,
                isOptional: e.isOptional,
            });
        }
        else if (e.kind === "ofNamedType") {
            var tsType = getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, e.typeName);
            ctMetaProperties.push({
                declaredAt: ct.declaredAtRelativeLocation,
                fromType: metaTypeName,
                name: e.name,
                elem: undefined,
                metaType: { name: getMetaTypeName(tsType), xsdType: tsType.annotation },
                typeBody: getTsTypeBody(tsType),
                isArray: e.isArray,
                isOptional: e.isOptional,
            });
        }
        else if (e.kind === "ofAnonymousType") {
            var anonymousTypeName = getAnonymousMetaTypeName(e.name, metaTypeName);
            var mp = getMetaProperties(__RELATIVE_LOCATION, __META_TYPE_MAPPING, __GLOBAL_ELEMENTS, __SUBSTITUTIONS, __XSDS, __NAMED_TYPES_BY_TS_NAME, e.anonymousType, anonymousTypeName);
            anonymousTypes.push({ name: anonymousTypeName, properties: mp.metaProperties });
            anonymousTypes.push.apply(anonymousTypes, __spreadArray([], __read(mp.anonymousTypes), false));
            __META_TYPE_MAPPING.set(anonymousTypeName, {
                name: anonymousTypeName,
                properties: mp.metaProperties,
            });
            ctMetaProperties.push({
                declaredAt: ct.declaredAtRelativeLocation,
                fromType: metaTypeName,
                name: e.name,
                elem: undefined,
                metaType: { name: anonymousTypeName, xsdType: "Anonymous type..." },
                isArray: e.isArray,
                isOptional: e.isOptional,
            });
        }
        else {
            throw new Error("Unknown kind of XptcComplexType '".concat(e, "'"));
        }
    };
    try {
        for (var _l = __values(ct.elements), _m = _l.next(); !_m.done; _m = _l.next()) {
            var e = _m.value;
            _loop_4(e);
        }
    }
    catch (e_14_1) { e_14 = { error: e_14_1 }; }
    finally {
        try {
            if (_m && !_m.done && (_d = _l.return)) _d.call(_l);
        }
        finally { if (e_14) throw e_14.error; }
    }
    if (ct.isSimpleContent && ct.childOf) {
        var t = getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, ct.declaredAtRelativeLocation, ct.childOf);
        ctMetaProperties.push({
            declaredAt: ct.declaredAtRelativeLocation,
            fromType: metaTypeName,
            name: "__$$text",
            elem: undefined,
            metaType: {
                name: t.name,
                xsdType: t.annotation,
            },
            isArray: false,
            isOptional: false,
        });
    }
    if (!(ct.type === "complex" && !ct.isAnonymous && ct.isAbstract)) {
        __META_TYPE_MAPPING.set(metaTypeName, {
            name: metaTypeName,
            properties: __spreadArray([], __read(ctMetaProperties.reduce(function (acc, p) { return acc.set(p.name, p); }, new Map()).values()), false),
        });
    }
    return { metaProperties: ctMetaProperties, needsExtensionType: needsExtensionType, anonymousTypes: anonymousTypes };
}
function getAnonymousMetaTypeName(elementName, metaTypeName) {
    return "".concat(metaTypeName, "__").concat(elementName);
}
function getTsNameFromNamedType(relativeLocation, namedTypeName) {
    var filenameWithoutExtension = path.basename(relativeLocation).replace(path.extname(relativeLocation), "");
    return "".concat(filenameWithoutExtension, "__").concat(namedTypeName).replaceAll(/[ -.]/g, "_");
}
function getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, relativeLocation, namedTypeLocalRef) {
    var _a;
    if (namedTypeLocalRef.includes(":") && namedTypeLocalRef.split(":").length === 2) {
        var _b = __read(namedTypeLocalRef.split(":"), 2), localNsName = _b[0], namedTypeName = _b[1];
        var xmlnsKey = "@_xmlns:".concat(localNsName);
        var namespace_1 = ((_a = __XSDS.get(relativeLocation)) === null || _a === void 0 ? void 0 : _a["xsd:schema"])[xmlnsKey];
        if (namespace_1 === "http://www.w3.org/2001/XMLSchema") {
            var xsdType = exports.XSD__TYPES.get(namedTypeLocalRef);
            if (!xsdType) {
                throw new Error("Unknown XSD type '".concat(namedTypeLocalRef, "'"));
            }
            return { name: xsdType.tsEquivalent, annotation: xsdType.annotation };
        }
        var referencedXsd = __spreadArray([], __read(__XSDS.entries()), false).find(function (_a) {
            var _b = __read(_a, 2), _ = _b[0], s = _b[1];
            return s["xsd:schema"]["@_targetNamespace"] === namespace_1;
        });
        if (!referencedXsd) {
            throw new Error("Can't find referenced namespace '".concat(namespace_1, "'"));
        }
        var _c = __read(referencedXsd, 2), referencedXsdRelativeLocation = _c[0], _2 = _c[1];
        var tsTypeName = getTsNameFromNamedType(referencedXsdRelativeLocation, namedTypeName);
        var namedType = __NAMED_TYPES_BY_TS_NAME.get(tsTypeName);
        if (!namedType) {
            throw new Error("Named type not found with name '".concat(namedType, "'"));
        }
        if (namedType.type === "simple" && namedType.kind === "int" && namedType.restrictionBase) {
            return getTsTypeFromLocalRef(__XSDS, __NAMED_TYPES_BY_TS_NAME, relativeLocation, namedType.restrictionBase);
        }
        return { name: tsTypeName, annotation: "type found from namespace with declaration name '".concat(localNsName, "'.") };
    }
    return {
        name: getTsNameFromNamedType(relativeLocation, namedTypeLocalRef),
        annotation: "// local type",
    };
}
function xsdSimpleTypeToXptcSimpleType(s, location, name) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if ((((_a = s["xsd:restriction"]) === null || _a === void 0 ? void 0 : _a["@_base"]) === "xsd:string" || ((_b = s["xsd:restriction"]) === null || _b === void 0 ? void 0 : _b["@_base"]) === "xsd:token") &&
        s["xsd:restriction"]["xsd:enumeration"]) {
        return {
            comment: "enum",
            type: "simple",
            kind: "enum",
            name: (_c = s["@_name"]) !== null && _c !== void 0 ? _c : name,
            declaredAtRelativeLocation: location,
            values: s["xsd:restriction"]["xsd:enumeration"].map(function (e) { return e["@_value"]; }),
        };
    }
    else if (((_d = s["xsd:restriction"]) === null || _d === void 0 ? void 0 : _d["@_base"]) === "xsd:int" || ((_e = s["xsd:restriction"]) === null || _e === void 0 ? void 0 : _e["@_base"]) === "xsd:integer") {
        return {
            comment: "int",
            type: "simple",
            kind: "int",
            restrictionBase: s["xsd:restriction"]["@_base"],
            name: (_f = s["@_name"]) !== null && _f !== void 0 ? _f : name,
            declaredAtRelativeLocation: location,
            minInclusive: (_g = s["xsd:restriction"]["xsd:minInclusive"]) === null || _g === void 0 ? void 0 : _g["@_value"],
            maxInclusive: (_h = s["xsd:restriction"]["xsd:maxInclusive"]) === null || _h === void 0 ? void 0 : _h["@_value"],
        };
    }
    else {
        throw new Error("Unknown xsd:simpleType --> ".concat(JSON.stringify(s, undefined, 2)));
    }
}
function getXptcElementFromLocalElementRef(__XSDS, __GLOBAL_ELEMENTS, relativeLocation, localElementRef) {
    var _a;
    if (localElementRef.includes(":") && localElementRef.split(":").length === 2) {
        var _b = __read(localElementRef.split(":"), 2), localNsName = _b[0], referencedElementName = _b[1];
        var xmlnsKey = "@_xmlns:".concat(localNsName);
        var namespace_2 = ((_a = __XSDS.get(relativeLocation)) === null || _a === void 0 ? void 0 : _a["xsd:schema"])[xmlnsKey];
        var referencedXsd = __spreadArray([], __read(__XSDS.entries()), false).find(function (_a) {
            var _b = __read(_a, 2), _ = _b[0], s = _b[1];
            return s["xsd:schema"]["@_targetNamespace"] === namespace_2;
        });
        if (!referencedXsd) {
            throw new Error("Can't find referenced namespace '".concat(namespace_2, "'"));
        }
        var _c = __read(referencedXsd, 2), referencedXsdRelativeLocation = _c[0], _3 = _c[1];
        return __GLOBAL_ELEMENTS.get("".concat(referencedXsdRelativeLocation, "__").concat(referencedElementName));
    }
    return __GLOBAL_ELEMENTS.get("".concat(relativeLocation, "__").concat(localElementRef));
}
function xsdElementToXptcElement(parentIdentifierForExtensionType, xsdElement, location, args) {
    var _a, _b;
    var minOccurs = (_a = xsdElement["@_minOccurs"]) !== null && _a !== void 0 ? _a : 1;
    var maxOccurs = (_b = xsdElement["@_maxOccurs"]) !== null && _b !== void 0 ? _b : 1;
    var isArray = false;
    var isOptional = false;
    if (maxOccurs !== "unbounded" && maxOccurs < minOccurs) {
        throw new Error("maxOccurs cannot be smaller than minOccurs (at '".concat(parentIdentifierForExtensionType, "')."));
    }
    if (minOccurs === 0) {
        if (maxOccurs === "unbounded") {
            isArray = true;
            isOptional = true;
        }
        else if (maxOccurs === 0) {
            throw new Error("minOccurs and maxOccurs cannot be 0 at the same time at element '".concat(parentIdentifierForExtensionType, "'."));
        }
        else if (maxOccurs === 1) {
            isOptional = true;
        }
        else if (maxOccurs > 1) {
            isArray = true;
        }
        else {
            throw new Error("Impossible scenario for minOccurs === 0. maxOccurs is '".concat(maxOccurs, "'."));
        }
    }
    else if (minOccurs === 1) {
        if (maxOccurs === "unbounded") {
            isArray = true;
        }
        else if (maxOccurs === 1) {
            isOptional = false;
        }
        else if (maxOccurs > 1) {
            isArray = true;
        }
        else {
            throw new Error("Impossible scenario for minOccurs === 1. maxOccurs is '".concat(maxOccurs, "'."));
        }
    }
    else if (minOccurs > 1) {
        if (maxOccurs === "unbounded") {
            isArray = true;
        }
        else if (maxOccurs >= minOccurs) {
            isArray = true;
        }
        else {
            throw new Error("Impossible scenario for minOccurs > 1. maxOccurs is '".concat(maxOccurs, "'."));
        }
    }
    else {
        throw new Error("Impossible scenario for minOccurs. minOccurs is '".concat(minOccurs, "(").concat(typeof minOccurs, ")' inside element '").concat(JSON.stringify(xsdElement), "'."));
    }
    if (args === null || args === void 0 ? void 0 : args.forceOptional) {
        isOptional = true;
    }
    if (xsdElement["@_type"] && xsdElement["@_name"]) {
        return {
            name: xsdElement["@_name"],
            typeName: xsdElement["@_type"],
            kind: "ofNamedType",
            isArray: isArray,
            isOptional: isOptional,
        };
    }
    if (xsdElement["xsd:complexType"] && xsdElement["@_name"]) {
        return {
            name: xsdElement["@_name"],
            kind: "ofAnonymousType",
            isArray: isArray,
            isOptional: isOptional,
            anonymousType: xsdComplexTypeToAnonymousXptcComplexType(parentIdentifierForExtensionType, xsdElement["xsd:complexType"], location, xsdElement["@_name"]),
        };
    }
    if (xsdElement["xsd:simpleType"] && xsdElement["@_name"]) {
        throw new Error("Simple types not implemented for anonymous element types.");
    }
    if (xsdElement["@_ref"]) {
        return {
            ref: xsdElement["@_ref"],
            kind: "ofRef",
            isArray: isArray,
            isOptional: isOptional,
        };
    }
    throw new Error("Unknown xsd:element structure. ".concat(JSON.stringify(xsdElement)));
}
function xsdAttributeToXptcAttribute(xsdAttribute) {
    return {
        name: xsdAttribute["@_name"],
        localTypeRef: xsdAttribute["@_type"],
        isOptional: xsdAttribute["@_use"] === undefined || xsdAttribute["@_use"] === "optional",
    };
}
function xsdComplexTypeToAnonymousXptcComplexType(parentIdentifierForExtensionType, xsdCt, location, element) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
    return {
        type: "complex",
        comment: "",
        isSimpleContent: false,
        isAnonymous: true,
        parentIdentifierForExtensionType: parentIdentifierForExtensionType,
        forElementWithName: element,
        needsExtensionType: !!xsdCt["xsd:anyAttribute"] || !!((_a = xsdCt["xsd:sequence"]) === null || _a === void 0 ? void 0 : _a["xsd:any"]),
        declaredAtRelativeLocation: location,
        childOf: (_c = (_b = xsdCt["xsd:complexContent"]) === null || _b === void 0 ? void 0 : _b["xsd:extension"]) === null || _c === void 0 ? void 0 : _c["@_base"],
        elements: __spreadArray(__spreadArray([], __read(((_e = (_d = xsdCt["xsd:sequence"]) === null || _d === void 0 ? void 0 : _d["xsd:element"]) !== null && _e !== void 0 ? _e : []).map(function (s) {
            return xsdElementToXptcElement("".concat(parentIdentifierForExtensionType, "__").concat(element), s, location);
        })), false), __read(((_j = (_h = (_g = (_f = xsdCt["xsd:complexContent"]) === null || _f === void 0 ? void 0 : _f["xsd:extension"]) === null || _g === void 0 ? void 0 : _g["xsd:sequence"]) === null || _h === void 0 ? void 0 : _h["xsd:element"]) !== null && _j !== void 0 ? _j : []).map(function (s) {
            return xsdElementToXptcElement("".concat(parentIdentifierForExtensionType, "__").concat(element), s, location);
        })), false),
        attributes: __spreadArray(__spreadArray([], __read(((_k = xsdCt["xsd:attribute"]) !== null && _k !== void 0 ? _k : []).map(function (a) { return xsdAttributeToXptcAttribute(a); })), false), __read(((_o = (_m = (_l = xsdCt["xsd:complexContent"]) === null || _l === void 0 ? void 0 : _l["xsd:extension"]) === null || _m === void 0 ? void 0 : _m["xsd:attribute"]) !== null && _o !== void 0 ? _o : []).map(function (a) {
            return xsdAttributeToXptcAttribute(a);
        })), false),
    };
}
function getTsTypeBody(tsType) {
    return tsType.annotation.startsWith("xsd:") ? function (tsTypeName) { return "{ __$$text: ".concat(tsTypeName, " }"); } : undefined;
}
//# sourceMappingURL=codegen.js.map