import { By } from "selenium-webdriver";
import GitHubEditorPage from "../github-editor/GitHubEditorPage";
import PageFragment from "../PageFragment";
class GitHubListItem extends PageFragment {
    async waitUntilLoaded() {
        return await this.tools.by(GitHubListItem.LINK_LOCATOR).wait(5000).untilPresent();
    }
    async open() {
        const link = await this.root.findElement(GitHubListItem.LINK_LOCATOR);
        await link.click();
        return await this.tools.createPage(GitHubEditorPage);
    }
}
GitHubListItem.LINK_LOCATOR = By.xpath(`.//a[@class='Link--primary']`);
export default GitHubListItem;
//# sourceMappingURL=GitHubListItem.js.map