import { By } from "selenium-webdriver";
import EditorPage from "../editor/EditorPage";
class GitHubPrPage extends EditorPage {
    async waitUntilLoaded() {
        return await this.tools.by(GitHubPrPage.SEE_AS_DIAGRAM_BUTTON_LOCATOR).wait(1000).untilPresent();
    }
    async scrollToPrHeader() {
        const panel = await this.tools.by(GitHubPrPage.PR_HEADER_LOCATOR).getElement();
        return await panel.scroll();
    }
    async isSourceOpened() {
        return await this.tools.by(GitHubPrPage.RAW_CONTENT_LOCATOR).wait(5000).isVisible();
    }
    async isDiagramOpened() {
        return await this.tools.by(EditorPage.FRAME_LOCATOR).wait(5000).isPresent();
    }
    async seeAsDiagram() {
        const seeAsDiagramButton = await this.tools.by(GitHubPrPage.SEE_AS_DIAGRAM_BUTTON_LOCATOR).getElement();
        return await seeAsDiagramButton.click();
    }
    async closeDiagram() {
        const closeDiagramButton = await this.tools.by(GitHubPrPage.CLOSE_DIAGRAM_BUTTON_LOCATOR).getElement();
        return await closeDiagramButton.click();
    }
    async original() {
        const originalButton = await this.tools.by(GitHubPrPage.ORIGINAL_BUTTON_LOCATOR).getElement();
        await originalButton.click();
        return await this.tools.by(GitHubPrPage.CHANGES_BUTTON_LOCATOR).wait(1000).untilEnabled();
    }
    async changes() {
        const changesButton = await this.tools.by(GitHubPrPage.CHANGES_BUTTON_LOCATOR).getElement();
        await changesButton.click();
        return await this.tools.by(GitHubPrPage.ORIGINAL_BUTTON_LOCATOR).wait(1000).untilEnabled();
    }
}
GitHubPrPage.SEE_AS_DIAGRAM_BUTTON_LOCATOR = By.xpath("//button[text()='See as diagram']");
GitHubPrPage.CLOSE_DIAGRAM_BUTTON_LOCATOR = By.xpath("//button[text()='Close diagram']");
GitHubPrPage.ORIGINAL_BUTTON_LOCATOR = By.xpath("//button[text()='Original']");
GitHubPrPage.CHANGES_BUTTON_LOCATOR = By.xpath("//button[text()='Changes']");
GitHubPrPage.RAW_CONTENT_LOCATOR = By.className("js-file-content");
GitHubPrPage.PR_HEADER_LOCATOR = By.className("gh-header-meta");
export default GitHubPrPage;
//# sourceMappingURL=GitHubPrPage.js.map